/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.similarity;

import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SparqlService;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.similarity.IndexBean;
import com.ontotext.forest.similarity.SimilarityConfigService;
import com.ontotext.forest.similarity.SimilarityIndexService;
import com.ontotext.trree.sdk.PluginException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPrefixDecl;
import org.eclipse.rdf4j.query.parser.sparql.ast.ParseException;
import org.eclipse.rdf4j.query.parser.sparql.ast.SyntaxTreeBuilder;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/rest/similarity"})
public class SimilarityController {
    static final String PREFIX = "http://www.ontotext.com/graphdb/similarity/";
    static final String INST_PREFIX = "http://www.ontotext.com/graphdb/similarity/instance/";
    static final String PREDICATION_PREFIX = "http://www.ontotext.com/graphdb/similarity/psi/";
    static final String GET_PLUGIN_INDEXES = "PREFIX :<http://www.ontotext.com/graphdb/similarity/> PREFIX similarity-index:<http://www.ontotext.com/graphdb/similarity/instance/>select ?index ?status ?type \nwhere {\n    ?index :status ?status .\n    ?index :type ?type .\n}";
    static final String DELETE_IDX_TEMPLATE = "PREFIX :<http://www.ontotext.com/graphdb/similarity/>\nPREFIX similarity-index:<http://www.ontotext.com/graphdb/similarity/instance/>\ninsert { ?index :deleteIndex '' } where {}";
    static final String REBUILD_INDEX_TEMPLATE = "PREFIX :<http://www.ontotext.com/graphdb/similarity/>\nPREFIX similarity-index:<http://www.ontotext.com/graphdb/similarity/instance/>\ninsert { ?index :rebuildIndex '' } where {}";
    private static final Logger LOG = LoggerFactory.getLogger(SimilarityController.class);
    public static final String TEXT = "text";
    public static final String TEXT_LITERAL = "textLiteral";
    public static final String PREDICATION = "predication";
    private String instPrefix = "similarity-index";
    @Autowired
    @Lazy
    private SimilarityIndexService similarityIndexService;
    @Autowired
    private SimilarityConfigService similarityConfigService;
    @Autowired
    private SemanticDataManagement semanticDataManagement;
    @Autowired
    private SparqlService sparqlService;
    @Autowired
    private ProxyToRemoteSesame proxyToRemoteSesame;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getSavedSimilarityIndexes(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.semanticDataManagement.getLocationFromHeaderOrThrow(), () -> {
            SemanticRepository currentRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
            Collection creatingBeans = this.similarityIndexService.getAllIndexesForRepo(currentRepository.getRepositoryID()).stream().filter(i -> "CREATING".equalsIgnoreCase(i.getStatus())).collect(Collectors.toList());
            List<Object> indexBeans = new LinkedList(creatingBeans);
            List<IndexBean> pluginBeans = this.getIndexesFromPlugin();
            List creatingIndexesNames = creatingBeans.stream().map(IndexBean::getName).collect(Collectors.toList());
            indexBeans.addAll(pluginBeans.stream().filter(ib -> !creatingIndexesNames.contains(ib.getName())).collect(Collectors.toList()));
            indexBeans = indexBeans.stream().sorted(Comparator.comparing(IndexBean::getName)).collect(Collectors.toList());
            return new ResponseEntity(indexBeans, (HttpStatusCode)HttpStatus.OK);
        });
    }

    List<IndexBean> getIndexesFromPlugin() {
        LinkedList<IndexBean> indexBeans = new LinkedList<IndexBean>();
        HashSet<String> pluginLoadedIndexes = new HashSet<String>();
        SemanticRepository currentRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        try (RepositoryConnection connection = currentRepository.getConnection();){
            TupleQueryResult indexes = connection.prepareTupleQuery(GET_PLUGIN_INDEXES).evaluate();
            while (indexes.hasNext()) {
                BindingSet index = (BindingSet)indexes.next();
                Value iri = index.getValue("index");
                String status = index.getValue("status").stringValue();
                String type = index.getValue("type").stringValue();
                if (!iri.stringValue().startsWith(INST_PREFIX)) continue;
                String indexName = iri.stringValue().substring(INST_PREFIX.length());
                pluginLoadedIndexes.add(indexName);
                IndexBean indexBean = this.similarityIndexService.getIndex(indexName, currentRepository.getRepositoryID());
                if (indexBean == null && (indexBean = this.similarityIndexService.getOldIndex(indexName)) != null) {
                    indexBean.setType(TEXT);
                }
                if (indexBean == null) {
                    indexBean = new IndexBean();
                    indexBean.setName(indexName);
                }
                indexBean.setStatus(status);
                if (TEXT.equalsIgnoreCase(type) || PREDICATION.equalsIgnoreCase(type) || TEXT_LITERAL.equalsIgnoreCase(type)) {
                    indexBean.setType(type);
                }
                this.similarityIndexService.migrateIndexesIfNeeded();
                this.similarityIndexService.saveIndex(indexBean, currentRepository.getRepositoryID());
                indexBeans.add(indexBean);
            }
        }
        return indexBeans;
    }

    @RequestMapping(value={"config"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Map<SimilarityConfigService.SearchType, String>> getSearchQueries(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.semanticDataManagement.getLocationFromHeaderOrThrow(), () -> {
            Map<SimilarityConfigService.SearchType, String> searchQueries = this.similarityConfigService.getSearchQueries();
            return new ResponseEntity(searchQueries, (HttpStatusCode)HttpStatus.OK);
        });
    }

    @RequestMapping(value={"query"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getQuery(@RequestParam String name, @RequestParam String options, @RequestParam String selectQuery, @Nullable @RequestParam String stopList, @RequestParam String infer, @RequestParam String sameAs, @RequestParam String type, @Nullable @RequestParam String analyzer, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IndexBean index = new IndexBean(name, options, selectQuery, stopList, Boolean.parseBoolean(infer), Boolean.parseBoolean(sameAs), type, analyzer);
        this.validateIndexQueries(index);
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.semanticDataManagement.getLocationFromHeaderOrThrow(), () -> new ResponseEntity((Object)this.createInsertQuery(index), (HttpStatusCode)HttpStatus.OK));
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> createIndex(@Valid @RequestBody IndexBean index, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)index, request, response, this.semanticDataManagement.getLocationFromHeaderOrThrow(), () -> this.buildIndex(index, false));
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> rebuildIndex(@Valid @RequestBody IndexBean index, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)index, request, response, this.semanticDataManagement.getLocationFromHeaderOrThrow(), () -> this.buildIndex(index, true));
    }

    private ResponseEntity<?> buildIndex(final @RequestBody IndexBean index, boolean existing) {
        String validateIndexMessage = this.validateIndexQueries(index);
        if (!StringUtils.isEmpty((CharSequence)validateIndexMessage)) {
            return new ResponseEntity((Object)validateIndexMessage, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        SemanticRepository currentRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        try (RepositoryConnection conn = currentRepository.getConnection();
             TupleQueryResult tupleQueryResult = conn.prepareTupleQuery(index.getSelectQuery()).evaluate();){
            if (!tupleQueryResult.hasNext()) {
                ResponseEntity responseEntity = new ResponseEntity((Object)"Index query returns no results.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
        }
        if (existing) {
            index.setStatus("REBUILDING");
            SemanticRepository semanticRepository = currentRepository;
            Objects.requireNonNull(semanticRepository);
            new SemanticRepository.WithConnection<Void>(this, semanticRepository){

                protected Void doInConnection() throws RepositoryException {
                    String rebuildIndexQuery = SimilarityController.REBUILD_INDEX_TEMPLATE.replace("?index", NTriplesUtil.toNTriplesString((IRI)SimpleValueFactory.getInstance().createIRI(SimilarityController.INST_PREFIX + index.getName())));
                    this.prepareAndExecuteUpdate(rebuildIndexQuery);
                    return null;
                }
            }.run();
        } else {
            index.setStatus("CREATING");
        }
        this.similarityIndexService.saveIndex(index, currentRepository.getRepositoryID());
        try {
            conn = currentRepository.getConnection();
            try {
                conn.begin();
                Update update = conn.prepareUpdate(this.createInsertQuery(index));
                update.setIncludeInferred(index.isInfer());
                update.execute();
                conn.commit();
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            index.setStatus("FAILED");
            this.similarityIndexService.saveIndex(index, currentRepository.getRepositoryID());
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    private String validateIndexQueries(IndexBean index) {
        if (StringUtils.isEmpty((CharSequence)index.getName())) {
            return "Index name cannot be empty";
        }
        if (StringUtils.isEmpty((CharSequence)index.getSelectQuery())) {
            return "Index select query cannot be empty";
        }
        if (StringUtils.isEmpty((CharSequence)index.getSearchQuery())) {
            return "Index search query cannot be empty";
        }
        if (StringUtils.isEmpty((CharSequence)index.getType()) || !index.getType().equals(TEXT) && !index.getType().equals(PREDICATION) && !index.getType().equals(TEXT_LITERAL)) {
            return "Index type should be text, predication or textLiteral but found " + index.getType();
        }
        try {
            ParsedTupleQuery parsedTupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)index.getSelectQuery(), null);
            Set bindingNames = parsedTupleQuery.getTupleExpr().getBindingNames();
            if ((index.getType().equals(TEXT) || index.getType().equals(TEXT_LITERAL)) && !bindingNames.equals(new HashSet<String>(Arrays.asList("documentID", "documentText")))) {
                return "Invalid binding names in select query. Expected [documentID, documentText] but found " + String.valueOf(bindingNames);
            }
            if (index.getType().equals(PREDICATION) && !bindingNames.equals(new HashSet<String>(Arrays.asList("subject", "predicate", "object")))) {
                return "Invalid binding names in select query. Expected [subject, predicate, object] but found " + String.valueOf(bindingNames);
            }
        }
        catch (MalformedQueryException | UnsupportedQueryLanguageException e) {
            return "Invalid select query";
        }
        try {
            QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)index.getSearchQuery(), null);
        }
        catch (MalformedQueryException | UnsupportedQueryLanguageException e) {
            return "Invalid search query";
        }
        if (!StringUtils.isEmpty((CharSequence)index.getAnalogicalQuery())) {
            try {
                QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)index.getAnalogicalQuery(), null);
            }
            catch (MalformedQueryException | UnsupportedQueryLanguageException e) {
                return "Invalid analogical query";
            }
        }
        return null;
    }

    @RequestMapping(value={"samples"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getSamples() {
        HashMap samples = new HashMap();
        samples.put(PREDICATION, new HashMap());
        samples.put(TEXT, new HashMap());
        try {
            ((Map)samples.get(TEXT)).put("literals", this.sparqlService.readQueryString("similarity-queries/text/literals"));
            ((Map)samples.get(TEXT)).put("rdfs comments", this.sparqlService.readQueryString("similarity-queries/text/rdfsComments"));
            ((Map)samples.get(PREDICATION)).put(PREDICATION, this.sparqlService.readQueryString("similarity-queries/predication/predication"));
        }
        catch (IOException e) {
            LOG.warn("Could not load sample query", (Throwable)e);
        }
        return new ResponseEntity(samples, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteIndex(final @Valid @RequestParam String name) {
        SemanticRepository currentRepository;
        SemanticRepository semanticRepository = currentRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        new SemanticRepository.WithConnection<Void>(semanticRepository){

            protected Void doInConnection() throws RepositoryException {
                SimpleValueFactory vf = SimpleValueFactory.getInstance();
                String deleteIndexQuery = SimilarityController.DELETE_IDX_TEMPLATE.replace("?index", NTriplesUtil.toNTriplesString((IRI)vf.createIRI(SimilarityController.INST_PREFIX + name)));
                this.prepareAndExecuteUpdate(deleteIndexQuery);
                try {
                    if (SimilarityController.this.similarityIndexService.getIndex(name, currentRepository.getRepositoryID()) != null) {
                        SimilarityController.this.similarityIndexService.deleteIndex(name, currentRepository.getRepositoryID());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return null;
            }
        }.run();
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    private String createInsertQuery(IndexBean index) {
        return this.createInsertQuery(index.getName(), index.getStopList(), index.getOptions(), index.getSelectQuery(), index.getType().startsWith(TEXT), index.getAnalyzer());
    }

    private String createInsertQuery(String indexName, String stopList, String options, String selectQuery, boolean isTextIndex, String analyzer) {
        LinkedHashMap<String, String> prefixes = new LinkedHashMap<String, String>();
        try {
            List prefixDecls = SyntaxTreeBuilder.parseQuery((String)selectQuery).getPrefixDeclList();
            for (ASTPrefixDecl decl : prefixDecls) {
                String prefix = decl.getPrefix();
                String iri = decl.getIRI().getValue();
                prefixes.put(prefix, iri);
                selectQuery = selectQuery.replaceFirst("(?i)prefix\\s+" + prefix + ":\\s*<" + iri + ">\\s*", "");
                if (prefix.equals("similarity-index") || !iri.equals(INST_PREFIX)) continue;
                this.instPrefix = prefix;
            }
        }
        catch (ParseException e) {
            throw new PluginException("Could not parse select statement", (Throwable)e);
        }
        String defPrefix = this.addPrefix(prefixes, "", PREFIX);
        this.instPrefix = this.addPrefix(prefixes, this.instPrefix, INST_PREFIX);
        String predPrefix = this.addPrefix(prefixes, "pred", PREDICATION_PREFIX);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry prefix : prefixes.entrySet()) {
            builder.append("PREFIX ").append((String)prefix.getKey()).append(": <").append((String)prefix.getValue()).append(">\n");
        }
        if (isTextIndex) {
            this.appendTextInsert(indexName, stopList, options, selectQuery, defPrefix, this.instPrefix, builder, analyzer);
        } else {
            this.appendPredicationInsert(indexName, options, selectQuery, predPrefix, this.instPrefix, builder);
        }
        return builder.toString();
    }

    private void appendPredicationInsert(String indexName, String options, String selectQuery, String defPrefix, String instPrefix, StringBuilder builder) {
        builder.append("insert {\n").append("\t").append(instPrefix).append(":").append(indexName).append(" ").append(defPrefix).append(":createPredicationIndex \"").append(options).append("\" ;\n");
        builder.append("\t\t").append(defPrefix).append(":subject ?subject .\n").append("\t\t").append("?subject ").append(defPrefix).append(":predicate ?predicate .\n").append("\t\t").append("?subject ").append(defPrefix).append(":object ?object .\n").append("} where {\n");
        for (String line : selectQuery.split("\n")) {
            builder.append("\t").append(line).append("\n");
        }
        builder.append("}");
    }

    private void appendTextInsert(String indexName, String stopList, String options, String selectQuery, String defPrefix, String instPrefix, StringBuilder builder, String analyzer) {
        builder.append("insert {\n").append("\t").append(instPrefix).append(":").append(indexName).append(" ").append(defPrefix).append(":createIndex \"").append(options).append("\" ;\n");
        if (stopList != null) {
            builder.append("\t\t").append(defPrefix).append(":").append("stopList \"").append(stopList).append("\" ;\n");
        }
        if (!StringUtils.isEmpty((CharSequence)analyzer)) {
            builder.append("\t\t").append(defPrefix).append(":").append("analyzer \"").append(analyzer).append("\" ;\n");
        }
        builder.append("\t\t").append(defPrefix).append(":documentID ?documentID .\n").append("\t\t").append("?documentID ").append(defPrefix).append(":documentText ?documentText .\n").append("} where {\n");
        for (String line : selectQuery.split("\n")) {
            builder.append("\t").append(line).append("\n");
        }
        builder.append("}");
    }

    private String addPrefix(Map<String, String> prefixes, String prefix, String iri) {
        while (prefixes.containsKey(prefix) && !prefixes.get(prefix).equals(iri)) {
            prefix = "sim_" + (String)prefix;
        }
        if (prefixes.containsValue(iri)) {
            return prefix;
        }
        prefixes.put((String)prefix, iri);
        return prefix;
    }

    @RequestMapping(value={"search-query"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> updateSearchQuery(@RequestBody Map<String, String> params, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded(params, request, response, this.semanticDataManagement.getLocationFromHeaderOrThrow(), () -> {
            try {
                String changedQuery = (String)params.get("changedQuery");
                SemanticRepository currentRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
                IndexBean indexBean = this.similarityIndexService.getIndex((String)params.get("name"), currentRepository.getRepositoryID());
                QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)changedQuery, null);
                if (Boolean.parseBoolean((String)params.get("isSearchQuery"))) {
                    indexBean.setSearchQuery(changedQuery);
                } else {
                    indexBean.setAnalogicalQuery(changedQuery);
                }
                this.similarityIndexService.saveIndex(indexBean, currentRepository.getRepositoryID());
            }
            catch (MalformedQueryException | UnsupportedQueryLanguageException e) {
                return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            catch (Exception e) {
                return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        });
    }
}

