/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.similarity;

import com.ontotext.forest.core.semantic.SparqlService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SimilarityConfigService {
    @Autowired
    private SparqlService sparqlService;
    Map<SearchType, String> defaultQueries = new HashMap<SearchType, String>();

    @PostConstruct
    public void init() throws IOException {
        this.defaultQueries.put(SearchType.text, this.sparqlService.readQueryString("similarity-queries/search/text"));
        this.defaultQueries.put(SearchType.predication, this.sparqlService.readQueryString("similarity-queries/search/predication"));
        this.defaultQueries.put(SearchType.analogical, this.sparqlService.readQueryString("similarity-queries/search/analogical"));
    }

    public Map<SearchType, String> getSearchQueries() {
        return this.defaultQueries;
    }

    public static enum SearchType {
        text,
        predication,
        analogical;

    }
}

