/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4jbrokers;

import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IBroker;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.MsalClientException;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.microsoft.azure.javamsalruntime.Account;
import com.microsoft.azure.javamsalruntime.AuthParameters;
import com.microsoft.azure.javamsalruntime.AuthResult;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;
import com.microsoft.azure.javamsalruntime.ReadAccountResult;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broker
implements IBroker {
    private static final Logger LOG = LoggerFactory.getLogger(Broker.class);
    private static MsalRuntimeInterop interop;
    private static Boolean brokerAvailable;
    private boolean supportWindows;

    public CompletableFuture<IAuthenticationResult> acquireToken(PublicClientApplication application, SilentParameters parameters) {
        String correlationID = application.correlationId() == null ? this.generateCorrelationID() : application.correlationId();
        Account accountResult = null;
        if (parameters.account() != null) {
            try {
                accountResult = ((ReadAccountResult)interop.readAccountById(parameters.account().homeAccountId().split("\\.")[0], correlationID).get()).getAccount();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new MsalClientException(String.format("MSALRuntime async operation interrupted when waiting for result: %s", ex.getMessage()), "interop_package_error");
            }
        }
        try {
            AuthParameters.AuthParametersBuilder authParamsBuilder = new AuthParameters.AuthParametersBuilder(application.clientId(), application.authority(), String.join((CharSequence)" ", parameters.scopes())).additionalParameters(parameters.extraQueryParameters());
            if (parameters.proofOfPossession() != null) {
                authParamsBuilder.popParameters(parameters.proofOfPossession().getHttpMethod().methodName, parameters.proofOfPossession().getUri(), parameters.proofOfPossession().getNonce());
            }
            AuthParameters authParameters = authParamsBuilder.build();
            if (accountResult == null) {
                return interop.signInSilently(authParameters, correlationID).thenCompose(acctResult -> interop.acquireTokenSilently(authParameters, correlationID, ((AuthResult)acctResult).getAccount())).thenApply(authResult -> this.parseBrokerAuthResult(application.authority(), ((AuthResult)authResult).getIdToken(), ((AuthResult)authResult).getAccessToken(), ((AuthResult)authResult).getAccount().getAccountId(), ((AuthResult)authResult).getAccount().getClientInfo(), ((AuthResult)authResult).getAccessTokenExpirationTime(), ((AuthResult)authResult).isPopAuthorization()));
            }
            return interop.acquireTokenSilently(authParameters, correlationID, accountResult).thenApply(authResult -> this.parseBrokerAuthResult(application.authority(), ((AuthResult)authResult).getIdToken(), ((AuthResult)authResult).getAccessToken(), ((AuthResult)authResult).getAccount().getAccountId(), ((AuthResult)authResult).getAccount().getClientInfo(), ((AuthResult)authResult).getAccessTokenExpirationTime(), ((AuthResult)authResult).isPopAuthorization()));
        }
        catch (MsalInteropException interopException) {
            throw new MsalClientException(interopException.getErrorMessage(), "interop_package_error");
        }
    }

    public CompletableFuture<IAuthenticationResult> acquireToken(PublicClientApplication application, InteractiveRequestParameters parameters) {
        String correlationID = application.correlationId() == null ? this.generateCorrelationID() : application.correlationId();
        try {
            AuthParameters.AuthParametersBuilder authParamsBuilder = new AuthParameters.AuthParametersBuilder(application.clientId(), application.authority(), String.join((CharSequence)" ", parameters.scopes())).redirectUri(parameters.redirectUri().toString()).additionalParameters(parameters.extraQueryParameters());
            if (parameters.proofOfPossession() != null) {
                authParamsBuilder.popParameters(parameters.proofOfPossession().getHttpMethod().methodName, parameters.proofOfPossession().getUri(), parameters.proofOfPossession().getNonce());
            }
            AuthParameters authParameters = authParamsBuilder.build();
            return interop.signInInteractively(parameters.windowHandle(), authParameters, correlationID, parameters.loginHint()).thenCompose(acctResult -> interop.acquireTokenInteractively(parameters.windowHandle(), authParameters, correlationID, ((AuthResult)acctResult).getAccount())).thenApply(authResult -> this.parseBrokerAuthResult(application.authority(), ((AuthResult)authResult).getIdToken(), ((AuthResult)authResult).getAccessToken(), ((AuthResult)authResult).getAccount().getAccountId(), ((AuthResult)authResult).getAccount().getClientInfo(), ((AuthResult)authResult).getAccessTokenExpirationTime(), ((AuthResult)authResult).isPopAuthorization()));
        }
        catch (MsalInteropException interopException) {
            throw new MsalClientException(interopException.getErrorMessage(), "interop_package_error");
        }
    }

    @Deprecated
    public CompletableFuture<IAuthenticationResult> acquireToken(PublicClientApplication application, UserNamePasswordParameters parameters) {
        String correlationID = application.correlationId() == null ? this.generateCorrelationID() : application.correlationId();
        try {
            AuthParameters.AuthParametersBuilder authParamsBuilder = new AuthParameters.AuthParametersBuilder(application.clientId(), application.authority(), String.join((CharSequence)" ", parameters.scopes())).additionalParameters(parameters.extraQueryParameters());
            if (parameters.proofOfPossession() != null) {
                authParamsBuilder.popParameters(parameters.proofOfPossession().getHttpMethod().methodName, parameters.proofOfPossession().getUri(), parameters.proofOfPossession().getNonce());
            }
            AuthParameters authParameters = authParamsBuilder.build();
            return interop.signInSilently(authParameters, correlationID).thenCompose(acctResult -> interop.acquireTokenSilently(authParameters, correlationID, ((AuthResult)acctResult).getAccount())).thenApply(authResult -> this.parseBrokerAuthResult(application.authority(), ((AuthResult)authResult).getIdToken(), ((AuthResult)authResult).getAccessToken(), ((AuthResult)authResult).getAccount().getAccountId(), ((AuthResult)authResult).getAccount().getClientInfo(), ((AuthResult)authResult).getAccessTokenExpirationTime(), ((AuthResult)authResult).isPopAuthorization()));
        }
        catch (MsalInteropException interopException) {
            throw new MsalClientException(interopException.getErrorMessage(), "interop_package_error");
        }
    }

    public void removeAccount(PublicClientApplication application, IAccount msalJavaAccount) {
        String correlationID = application.correlationId() == null ? this.generateCorrelationID() : application.correlationId();
        try {
            Account msalRuntimeAccount = ((ReadAccountResult)interop.readAccountById(msalJavaAccount.homeAccountId().split("\\.")[0], correlationID).get()).getAccount();
            if (msalRuntimeAccount != null) {
                interop.signOutSilently(application.clientId(), correlationID, msalRuntimeAccount);
            }
        }
        catch (MsalInteropException interopException) {
            throw new MsalClientException(interopException.getErrorMessage(), "interop_package_error");
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new MsalClientException(String.format("MSALRuntime async operation interrupted when waiting for result: %s", ex.getMessage()), "interop_package_error");
        }
    }

    public boolean isBrokerAvailable() {
        if (brokerAvailable == null) {
            try {
                interop.startupMsalRuntime();
                LOG.info("MSALRuntime started successfully. MSAL Java will use MSALRuntime in all supported broker flows.");
                brokerAvailable = true;
            }
            catch (MsalInteropException e) {
                LOG.warn("Exception thrown when trying to start MSALRuntime: {}", (Object)e.getErrorMessage());
                LOG.warn("MSALRuntime could not be started. MSAL Java will fall back to non-broker flows.");
                brokerAvailable = false;
            }
        }
        return brokerAvailable;
    }

    public void enableBrokerLogging(boolean enableLogging) {
        try {
            MsalRuntimeInterop.enableLogging((boolean)enableLogging);
        }
        catch (Exception ex) {
            throw new MsalClientException(String.format("Error occurred when calling MSALRuntime logging API: %s", ex.getMessage()), "interop_package_error");
        }
    }

    public void enableBrokerPIILogging(boolean enablePII) {
        try {
            MsalRuntimeInterop.enableLoggingPii((boolean)enablePII);
        }
        catch (Exception ex) {
            throw new MsalClientException(String.format("Error occurred when calling MSALRuntime PII logging API: %s", ex.getMessage()), "interop_package_error");
        }
    }

    private String generateCorrelationID() {
        return UUID.randomUUID().toString();
    }

    private Broker(Builder builder) {
        this.supportWindows = builder.supportWindows;
        if (!this.supportWindows) {
            throw new MsalClientException("At least one operating system support option must be used when building the Broker instance", "brokers_package_error");
        }
    }

    static {
        try {
            interop = new MsalRuntimeInterop();
        }
        catch (MsalInteropException e) {
            throw new MsalClientException(String.format("Could not initialize MSALRuntime: %s", e.getErrorMessage()), "interop_package_error");
        }
    }

    public static class Builder {
        private boolean supportWindows = false;

        public Builder supportWindows(boolean val) {
            this.supportWindows = val;
            return this;
        }

        public Broker build() {
            return new Broker(this);
        }
    }
}

