/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.soaas.common.connection.Endpoint;
import java.util.Objects;

public class OptimizationContext
implements ExpressionVisitorContext {
    private final OptimizationContext parentContext;
    private ExpressionValue currentNode;
    private ExpressionValue replaceWith;
    private final Endpoint endpoint;

    public OptimizationContext(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.parentContext = null;
    }

    public OptimizationContext(OptimizationContext parentContext) {
        this.parentContext = Objects.requireNonNull(parentContext, "parent context is required");
        this.endpoint = parentContext.endpoint;
    }

    public ExpressionValue getParentNode() {
        if (this.parentContext != null) {
            return this.parentContext.getCurrentNode();
        }
        return null;
    }

    public ExpressionValue getCurrentNode() {
        return this.currentNode;
    }

    public ExpressionValue getReplaceWith() {
        return this.replaceWith;
    }

    public void replaceCurrentWith(ExpressionValue replaceWith) {
        this.replaceWith = replaceWith;
    }

    public void removeCurrent() {
        this.replaceCurrentWith(null);
    }

    public OptimizationContext getParentContext() {
        return this.parentContext;
    }

    void onSibling(ExpressionValue sibling) {
        this.currentNode = sibling;
        this.replaceWith = sibling;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }
}

