/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.FilterExpressionOptimizer;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.models.ScalarType;
import com.ontotext.models.query.Equals;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionsFactory;
import com.ontotext.models.query.In;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.TraversalControl;
import com.ontotext.models.query.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class LiteralValueAndLangOptimization
extends AbstractFilterOptimization {
    private final InputValueConverter valueConverter;

    public LiteralValueAndLangOptimization(InputValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    @Override
    public TraversalControl visit(Node node, OptimizationContext context) {
        if (!node.getPropertyShape().isLiteral()) {
            return TraversalControl.CONTINUE;
        }
        Node copy = node.deepCopy();
        FilterExpressionOptimizer optimizer = new FilterExpressionOptimizer();
        OptimizationInfoCollector collector = new OptimizationInfoCollector(this.valueConverter);
        optimizer.addOptimization(collector);
        optimizer.optimize((ExpressionValue)copy, null);
        ExpressionTerm expressionTerm = collector.applyOptimizationIfApplicable(copy, currentTerm -> this.removeTerm(copy, (ExpressionTerm<?>)currentTerm));
        if (copy.isExistsCheck()) {
            copy.append(expressionTerm);
            context.replaceCurrentWith((ExpressionValue)copy);
        }
        return TraversalControl.CANCEL;
    }

    private void removeTerm(Node node, ExpressionTerm<?> oldTerm) {
        FilterExpressionOptimizer optimizer = new FilterExpressionOptimizer();
        ExpressionUpdater updater = new ExpressionUpdater(oldTerm, null);
        optimizer.addOptimization(updater);
        optimizer.optimize((ExpressionValue)node, null);
    }

    private static class OptimizationInfoCollector
    extends AbstractFilterOptimization {
        private final InputValueConverter valueConverter;
        private List<Object> values = new LinkedList<Object>();
        private List<Object> langs = new LinkedList<Object>();
        private List<ExpressionTerm<?>> langTerms = new LinkedList();
        private List<ExpressionTerm<?>> valueTerms = new LinkedList();

        OptimizationInfoCollector(InputValueConverter valueConverter) {
            this.valueConverter = valueConverter;
        }

        @Override
        public TraversalControl visit(Node target, OptimizationContext context) {
            if ("lang".equals(target.getPropertyShape().getName()) || "value".equals(target.getPropertyShape().getName())) {
                return TraversalControl.CONTINUE;
            }
            return TraversalControl.CANCEL;
        }

        public TraversalControl visit(Equals target, OptimizationContext context) {
            this.collectValues((ExpressionTerm<?>)target, Collections.singletonList(target.getValue()), context);
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visit(In target, OptimizationContext context) {
            this.collectValues((ExpressionTerm<?>)target, (List)target.getValue(), context);
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visit(Not target, OptimizationContext context) {
            return TraversalControl.QUIT;
        }

        private void collectValues(ExpressionTerm<?> term, List<Object> termValues, OptimizationContext context) {
            Node parentNode = this.findParentNode(context);
            if (parentNode == null) {
                return;
            }
            if ("lang".equals(parentNode.getPropertyShape().getName())) {
                this.langs.addAll(termValues);
                this.langTerms.add(term);
            } else if ("value".equals(parentNode.getPropertyShape().getName())) {
                this.values.addAll(termValues);
                this.valueTerms.add(term);
            }
        }

        private Node findParentNode(OptimizationContext context) {
            OptimizationContext parentContext = context.getParentContext();
            while (parentContext != null && !(parentContext.getCurrentNode() instanceof Node)) {
                if ((parentContext = parentContext.getParentContext()) != null) continue;
                return null;
            }
            if (parentContext != null && parentContext.getCurrentNode() instanceof Node) {
                return (Node)parentContext.getCurrentNode();
            }
            return null;
        }

        ExpressionTerm applyOptimizationIfApplicable(Node node, Consumer<ExpressionTerm<?>> optimization) {
            if (!this.langTerms.isEmpty() && !this.valueTerms.isEmpty()) {
                ExpressionTerm<?> term = this.combineValues(node);
                this.valueTerms.forEach(optimization);
                this.langTerms.forEach(optimization);
                return term;
            }
            return null;
        }

        private ExpressionTerm<?> combineValues(Node node) {
            ExpressionTerm term;
            ScalarType langString = (ScalarType)node.getShape().getContainedIn().getContainedIn().getTypes().get((Object)"langString");
            LinkedList newValueList = new LinkedList();
            for (Object value : this.values) {
                this.langs.stream().map(this.createValue(value, langString)).forEach(newValueList::add);
            }
            if (newValueList.size() == 1) {
                term = ExpressionsFactory.term((String)"EQ", newValueList.get(0));
            } else if (!newValueList.isEmpty()) {
                term = ExpressionsFactory.term((String)"IN", newValueList);
            } else {
                throw new IllegalStateException("Expected at least one value and lang combination!");
            }
            return term;
        }

        private Function<Object, Object> createValue(Object value, ScalarType langString) {
            return lang -> {
                HashMap<String, Object> valueMap = new HashMap<String, Object>(4);
                if (value instanceof Value) {
                    valueMap.put("value", ((Value)value).getValue());
                } else {
                    valueMap.put("value", value);
                }
                if (lang instanceof Value) {
                    valueMap.put("lang", ((Value)lang).getValue());
                } else {
                    valueMap.put("lang", lang);
                }
                return this.valueConverter.convert(valueMap, langString);
            };
        }
    }

    private static class ExpressionUpdater
    extends AbstractFilterOptimization {
        private final ExpressionTerm<?> termToReplace;
        private final ExpressionTerm<?> termToSet;

        private ExpressionUpdater(ExpressionTerm<?> termToReplace, ExpressionTerm<?> termToSet) {
            this.termToReplace = termToReplace;
            this.termToSet = termToSet;
        }

        @Override
        public TraversalControl visit(Node node, OptimizationContext context) {
            if (node.isExistsCheck()) {
                context.removeCurrent();
                return TraversalControl.RERUN;
            }
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visit(Equals target, OptimizationContext context) {
            return this.replaceOrRemoveTerm((ExpressionTerm<?>)target, context);
        }

        public TraversalControl visit(In target, OptimizationContext context) {
            return this.replaceOrRemoveTerm((ExpressionTerm<?>)target, context);
        }

        @Override
        protected TraversalControl visitExpression(Expression expression, OptimizationContext context) {
            if (expression.getTerms().isEmpty()) {
                context.removeCurrent();
                return TraversalControl.RERUN;
            }
            return TraversalControl.CONTINUE;
        }

        private TraversalControl replaceOrRemoveTerm(ExpressionTerm<?> target, OptimizationContext context) {
            if (this.termToReplace == target) {
                if (this.termToSet == null) {
                    context.removeCurrent();
                    return TraversalControl.RERUN;
                }
                context.replaceCurrentWith((ExpressionValue)this.termToSet);
                return TraversalControl.QUIT;
            }
            return TraversalControl.CONTINUE;
        }
    }
}

