/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.TraversalControl;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class LangStringFilterOptimization
extends AbstractFilterOptimization {
    @Override
    public TraversalControl visit(Node target, OptimizationContext context) {
        if (!target.getPropertyShape().isLiteral()) {
            return TraversalControl.CONTINUE;
        }
        if (target.isExistsCheck()) {
            return TraversalControl.CONTINUE;
        }
        List terms = ((Expression)target.getValue()).getTerms();
        if (terms.stream().anyMatch(LangStringFilterOptimization.isValueExists())) {
            terms.removeIf(LangStringFilterOptimization.isValueExists());
            return TraversalControl.CANCEL;
        }
        if (terms.stream().anyMatch(LangStringFilterOptimization.isValueExistsInsideExpression())) {
            LangStringFilterOptimization.iterateSubExpression((Expression)target.getValue()).forEach(exp -> {
                LangStringFilterOptimization.iterateSubExpression(exp).forEach(expression -> expression.getTerms().removeIf(LangStringFilterOptimization.isValueExists()));
                exp.getTerms().removeIf(LangStringFilterOptimization.emptyExpression());
            });
            terms.removeIf(LangStringFilterOptimization.emptyExpression());
            return TraversalControl.CANCEL;
        }
        return TraversalControl.CONTINUE;
    }

    private static Predicate<? super ExpressionTerm> emptyExpression() {
        return term -> term instanceof Expression && ((List)((Expression)term).getValue()).isEmpty();
    }

    private static Stream<Expression> iterateSubExpression(Expression exp) {
        return exp.getTerms().stream().filter(Expression.class::isInstance).map(Expression.class::cast);
    }

    private static Predicate<? super ExpressionTerm> isValueExistsInsideExpression() {
        return term -> term instanceof Expression && LangStringFilterOptimization.iterateSubExpression((Expression)term).anyMatch(exp -> exp.getTerms().stream().anyMatch(LangStringFilterOptimization.isValueExists()));
    }

    private static Predicate<? super ExpressionTerm> isValueExists() {
        return term -> term instanceof Node && ((Node)term).getPropertyShape().getName().equals("value") && ((Node)term).isExistsCheck();
    }
}

