/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.models.query.All;
import com.ontotext.models.query.AllExists;
import com.ontotext.models.query.And;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionsFactory;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.TraversalControl;
import java.util.Iterator;
import java.util.List;

public class ExpandAllExpression
extends AbstractFilterOptimization {
    public TraversalControl visit(Exists target, OptimizationContext context) {
        block5: {
            List terms;
            block4: {
                terms = target.getTerms();
                if (terms.isEmpty()) {
                    context.removeCurrent();
                    return TraversalControl.CONTINUE;
                }
                if (this.isAndWithSupportedExpression(terms)) break block4;
                if (terms.stream().allMatch(All.class::isInstance)) break block4;
                if (!terms.stream().allMatch(AllExists.class::isInstance)) break block5;
            }
            context.replaceCurrentWith((ExpressionValue)terms.get(0));
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(All target, OptimizationContext context) {
        Expression expanded = this.expandAll((Expression)target);
        context.replaceCurrentWith((ExpressionValue)expanded);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(AllExists target, OptimizationContext context) {
        AllExists copy = target.deepCopy();
        this.removeAllAfterLastNode((Expression)copy);
        Expression expression = ExpressionsFactory.and().addTerm((ExpressionTerm)this.expandAll((Expression)target)).addTerm((ExpressionTerm)this.wrapInExists((Expression)copy));
        context.replaceCurrentWith((ExpressionValue)expression);
        return TraversalControl.CONTINUE;
    }

    private void removeAllAfterLastNode(Expression expression) {
        Iterator it = expression.getTerms().iterator();
        while (it.hasNext()) {
            ExpressionTerm term = (ExpressionTerm)it.next();
            if (term instanceof Node) {
                Node node = (Node)term;
                if (node.getName().equals("id")) {
                    it.remove();
                    continue;
                }
                if (node.getPropertyShape().isScalarType()) {
                    node.setValue((Object)new ExpressionCollection());
                    continue;
                }
                this.removeAllAfterLastNode((Expression)node.getValue());
                continue;
            }
            if (!(term instanceof Expression)) continue;
            this.removeAllAfterLastNode((Expression)term);
        }
    }

    private Expression expandAll(Expression target) {
        Expression not = this.wrapTermsInNotExists(target);
        this.wrapNodeTermInNotExists(target);
        return not;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAndWithSupportedExpression(List<ExpressionTerm> terms) {
        if (!terms.stream().allMatch(And.class::isInstance)) return false;
        if (!terms.stream().map(Expression.class::cast).flatMap(term -> term.getTerms().stream()).allMatch(term -> term instanceof All || term instanceof AllExists)) return false;
        return true;
    }

    private Expression wrapTermsInNotExists(Expression target) {
        return ExpressionsFactory.not().addTerm((ExpressionTerm)this.wrapInExists(target));
    }

    private Expression wrapInExists(Expression target) {
        Object exists = target.getTerms().size() > 1 ? ExpressionsFactory.exists() : Exists.withoutAndContainer();
        target.getTerms().forEach(arg_0 -> ((Expression)exists).addTerm(arg_0));
        return exists;
    }

    private void wrapNodeTermInNotExists(Expression target) {
        for (ExpressionTerm term : target.getTerms()) {
            if (term instanceof Node) {
                Node node = (Node)term;
                Expression expression = (Expression)node.getValue();
                Expression not = ExpressionsFactory.not();
                if (expression instanceof ExpressionCollection) {
                    expression.getTerms().forEach(arg_0 -> ((Expression)not).addTerm(arg_0));
                } else {
                    not.addTerm((ExpressionTerm)expression);
                }
                node.setValue((Object)new ExpressionCollection().addTerm((ExpressionTerm)not));
                continue;
            }
            if (!(term instanceof Expression)) continue;
            this.wrapNodeTermInNotExists((Expression)term);
        }
    }
}

