/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentParser;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.argument.DefaultArgumentConverter;
import com.ontotext.graphql.parser.argument.ExpressionPreProcessor;
import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.FilterExpressionOptimization;
import com.ontotext.graphql.parser.argument.optimization.FilterExpressionOptimizer;
import com.ontotext.graphql.parser.argument.optimization.LiteralValueAndLangOptimization;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.OperationType;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionsFactory;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.Node;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.plugin.PluginsManager;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhereArgumentParser
implements ArgumentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Pattern CLOSING_BRACKET = Pattern.compile("([}\\]])([\\w_])");
    public static final String NAME = "where";
    public static final String EXPRESSION_TYPE_OVERRIDE = "%typeOverride%";
    private static final Map<String, Function<PropertyShape, ScalarType>> TERM_TO_TYPE_MAPPING = new HashMap<String, Function<PropertyShape, ScalarType>>();
    private final InputValueConverter valueConverter;
    private final FilterExpressionOptimizer expressionOptimizer;
    private final List<ExpressionPreProcessor> expressionPreProcessors = this.loadPreProcessors();

    public WhereArgumentParser(InputValueConverter valueConverter) {
        this.expressionOptimizer = new FilterExpressionOptimizer();
        this.loadOptimizations();
        this.valueConverter = valueConverter;
        this.addOptimization(new LiteralValueAndLangOptimization(valueConverter));
    }

    private void loadOptimizations() {
        PluginsManager.loadPlugins(AbstractFilterOptimization.class).forEach(this::addOptimization);
    }

    private List<ExpressionPreProcessor> loadPreProcessors() {
        return PluginsManager.loadPlugins(ExpressionPreProcessor.class);
    }

    public void addOptimization(FilterExpressionOptimization optimization) {
        this.expressionOptimizer.addOptimization(optimization);
    }

    @Override
    public Object parseArgument(Object value, ArgumentParserContext parserContext) {
        if (value instanceof Map) {
            Map whereMap = (Map)value;
            if (whereMap.isEmpty()) {
                throw new IllegalArgumentException(String.format("Argument '%s' should have at least one condition", NAME));
            }
            Shape shape = parserContext.getPropertyType().orElseGet(parserContext::getContainingType);
            if (parserContext.getPropertyShape().filter(PropertyShape::isLiteral).isPresent()) {
                shape = (Shape)shape.getContainedIn().get((Object)"Literal");
            }
            if (parserContext.getOperationType() == OperationType.SUBSCRIPTION) {
                String subscriptionId = shape.getId();
                Shapes shapes = parserContext.getContainingType().getContainedIn();
                Prefixes prefixes = shapes.getContainedIn().getPrefixes();
                shape = (Shape)shapes.get((Object)prefixes.toModelShortIri(subscriptionId.substring(0, subscriptionId.lastIndexOf("_Subscription"))));
            }
            String fieldName = parserContext.getFieldName();
            try {
                Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
                Optional property = shape.getProperty(prefixes.nameToShortIri(fieldName));
                if (property.isPresent() && this.isPropertyExpression(whereMap)) {
                    return this.handlePropertyExpression(parserContext, whereMap, fieldName, (PropertyShape)property.get());
                }
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Failed to process property expression on {}.{}. Checking if it's regular expression", (Object)shape.getId(), (Object)fieldName);
            }
            if (whereMap.keySet().stream().allMatch(ExpressionsFactory::isExpression) && whereMap.size() == 1) {
                Map.Entry entry = whereMap.entrySet().iterator().next();
                return this.expressionOptimizer.optimize((ExpressionValue)this.onExpression((String)entry.getKey(), entry.getValue(), shape, null), parserContext.getOperationType(), parserContext.getEndpoint());
            }
            return this.expressionOptimizer.optimize((ExpressionValue)this.processExpressionSubTree(whereMap, (Expression)new ExpressionCollection(), shape, null), parserContext.getOperationType(), parserContext.getEndpoint());
        }
        return null;
    }

    private Object handlePropertyExpression(ArgumentParserContext parserContext, Map<String, Object> whereMap, String fieldName, PropertyShape property) {
        if (whereMap.keySet().stream().allMatch(ExpressionsFactory::isExpression) && whereMap.size() == 1) {
            Map.Entry<String, Object> entry = whereMap.entrySet().iterator().next();
            return this.expressionOptimizer.optimize((ExpressionValue)this.onExpression(entry.getKey(), entry.getValue(), property, fieldName), parserContext.getOperationType(), parserContext.getEndpoint());
        }
        return this.expressionOptimizer.optimize((ExpressionValue)this.processExpressionSubTree(whereMap, (Expression)new ExpressionCollection(), property, fieldName), parserContext.getOperationType(), parserContext.getEndpoint());
    }

    private boolean isPropertyExpression(Map<String, Object> whereMap) {
        if (whereMap.keySet().stream().allMatch(ExpressionsFactory::isExpression) && whereMap.size() == 1) {
            Map.Entry<String, Object> entry = whereMap.entrySet().iterator().next();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                return ((Collection)value).stream().filter(Map.class::isInstance).flatMap(map -> ((Map)map).keySet().stream()).allMatch(ExpressionsFactory::isTerm);
            }
            if (value instanceof Map) {
                whereMap = (Map)value;
            }
        }
        return whereMap.keySet().stream().allMatch(ExpressionsFactory::isTerm);
    }

    @Override
    public void register(ArgumentConverter argumentConverter) {
        argumentConverter.registerArgumentParser(NAME, this);
    }

    public ExpressionValue<Object> parseFromString(String filter, Shape shape) throws JSONException, InvalidSchemaException {
        Map filterMap = new JSONObject(WhereArgumentParser.normalizeToJson(filter)).toMap();
        Arguments arguments = new Arguments();
        ArgumentParserContext ctx = new ArgumentParserContext(shape.getId(), OperationType.QUERY, shape, arguments, new DefaultArgumentConverter(), null);
        return (ExpressionValue)this.parseArgument(filterMap, ctx);
    }

    public static String normalizeToJson(String input) {
        input = WHITESPACE.matcher(input).replaceAll("");
        input = CLOSING_BRACKET.matcher(input).replaceAll("$1,$2");
        return input;
    }

    private Expression processExpressionSubTree(Map<String, Object> subCause, Expression parentExpression, Object parentType, String nodeName) {
        if (!subCause.isEmpty() || nodeName == null) {
            this.callPreProcessors(subCause, parentType);
            Object customType = subCause.remove(EXPRESSION_TYPE_OVERRIDE);
            Object type = ObjectsUtil.getOrDefault((Object)customType, (Object)parentType);
            for (Map.Entry<String, Object> entry : subCause.entrySet()) {
                ExpressionTerm<?> term;
                if (ExpressionsFactory.isTerm((String)entry.getKey()) && type instanceof PropertyShape) {
                    term = this.onTerm(entry.getKey(), entry.getValue(), (PropertyShape)type);
                } else if (ExpressionsFactory.isExpression((String)entry.getKey())) {
                    term = this.onExpression(entry.getKey(), entry.getValue(), type, nodeName);
                } else if (entry.getValue() instanceof Map && type instanceof Shape) {
                    term = this.onNode(entry.getKey(), (Map)entry.getValue(), (Shape)type);
                } else if (entry.getKey().equals("ID") && type instanceof Shape) {
                    Map<String, Object> value = Collections.singletonMap("IN", entry.getValue());
                    term = this.onNode("id", value, (Shape)type);
                } else {
                    throw new IllegalArgumentException(String.format("Expression '%s: %s' is not supported", entry.getKey(), entry.getValue()));
                }
                parentExpression.addTerm((ExpressionTerm)term);
            }
        }
        return parentExpression;
    }

    private void callPreProcessors(Map<String, Object> subCause, Object parentType) {
        for (ExpressionPreProcessor preProcessor : this.expressionPreProcessors) {
            if (parentType instanceof Shape) {
                preProcessor.preProcess(subCause, (Shape)parentType);
                continue;
            }
            if (!(parentType instanceof PropertyShape)) continue;
            preProcessor.preProcess(subCause, (PropertyShape)parentType);
        }
    }

    private ExpressionTerm<?> onTerm(String termName, Object value, PropertyShape parentType) {
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("Term '" + termName + "' with empty value is not allowed");
        }
        ScalarType scalarType = TERM_TO_TYPE_MAPPING.getOrDefault(termName, PropertyShape::getScalarType).apply(parentType);
        return ExpressionsFactory.term((String)termName, (Object)this.convertValue(value, scalarType));
    }

    private Object convertValue(Object value, ScalarType scalarType) {
        return this.valueConverter.convert(value, scalarType);
    }

    private Expression onExpression(String expressionName, Object value, Object parentType, String nodeName) {
        Expression expression = ExpressionsFactory.expression((String)expressionName);
        if (value instanceof Map) {
            this.processExpressionSubTree((Map)value, expression, parentType, nodeName);
        } else if (value instanceof Collection) {
            for (Object expressionEntry : (Collection)value) {
                if (expressionEntry instanceof Map) {
                    this.processExpressionSubTree((Map)expressionEntry, expression, parentType, nodeName);
                    continue;
                }
                this.throwNotAllowedExpression(expressionName, expressionEntry);
            }
        }
        expression.validate();
        return expression;
    }

    private void throwNotAllowedExpression(String expressionName, Object value) {
        throw new IllegalArgumentException(String.format("Expression '%s' as not allowed value '%s'", expressionName, value));
    }

    private ExpressionTerm<?> onNode(String nodeName, Map<String, Object> value, Shape parentType) {
        Node node;
        PropertyShape propertyShape;
        SomlSchema schema = parentType.getContainedIn().getContainedIn();
        Prefixes prefixes = schema.getPrefixes();
        Object subType = propertyShape = parentType.getPropertyOrFail(prefixes.nameToShortIri(nodeName));
        if (!propertyShape.isScalarType()) {
            String range = propertyShape.getRange();
            subType = schema.getObjects().get((Object)range);
            node = ExpressionsFactory.subNode((String)nodeName, (Shape)parentType, (PropertyShape)propertyShape);
        } else if (propertyShape.isLiteral()) {
            subType = schema.getObjects().get((Object)"Literal");
            node = ExpressionsFactory.subNode((String)nodeName, (Shape)parentType, (PropertyShape)propertyShape);
        } else {
            node = ExpressionsFactory.node((String)nodeName, (Shape)parentType, (PropertyShape)propertyShape);
        }
        this.processExpressionSubTree(value, (Expression)node.getValue(), subType, nodeName);
        return node;
    }

    static {
        Function<PropertyShape, ScalarType> stringTypeResolver = shape -> (ScalarType)shape.getContainedIn().getContainedIn().getContainedIn().getContainedIn().getTypes().get((Object)"string");
        TERM_TO_TYPE_MAPPING.put("IRE", stringTypeResolver);
        TERM_TO_TYPE_MAPPING.put("NIRE", stringTypeResolver);
        TERM_TO_TYPE_MAPPING.put("RE", stringTypeResolver);
        TERM_TO_TYPE_MAPPING.put("NRE", stringTypeResolver);
    }
}

