/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.soaas.common.StringManipulation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

class TypeFilterUtil {
    static final String TYPE_FILTER = "_if";

    private TypeFilterUtil() {
    }

    static void mergeChanges(Map<String, Object> target, List<Object> toMerge) {
        if (target.containsKey("OR")) {
            LinkedHashMap<String, Object> currentOr = new LinkedHashMap<String, Object>();
            currentOr.put("OR", target.remove("OR"));
            ArrayList<Object> andValues = new ArrayList<Object>(2);
            andValues.add(currentOr);
            if (toMerge.size() == 1) {
                andValues.add(toMerge.get(0));
            } else {
                LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>(2);
                map.put("OR", toMerge);
                andValues.add(map);
            }
            target.put("AND", andValues);
        } else if (toMerge.size() == 1) {
            Map subFilter = (Map)toMerge.get(0);
            subFilter.forEach((key, value) -> target.merge((String)key, value, TypeFilterUtil.mergeValues()));
        } else {
            target.put("OR", toMerge);
        }
    }

    private static BiFunction<Object, Object, Object> mergeValues() {
        return (currentValue, newValue) -> {
            if (currentValue instanceof Map && newValue instanceof Map) {
                ((Map)newValue).forEach((key, value) -> ((Map)currentValue).merge(key, value, TypeFilterUtil.mergeValues()));
            } else if (currentValue instanceof Collection) {
                if (newValue instanceof Collection) {
                    ((Collection)currentValue).addAll((Collection)newValue);
                } else {
                    ((Collection)currentValue).add(newValue);
                }
            } else {
                if (newValue instanceof Collection) {
                    ((Collection)newValue).add(currentValue);
                    return newValue;
                }
                ArrayList<Object> objects = new ArrayList<Object>();
                objects.add(currentValue);
                objects.add(newValue);
                return objects;
            }
            return currentValue;
        };
    }

    static boolean isIfType(String key) {
        return key.startsWith(TYPE_FILTER);
    }

    static String toIfType(String key) {
        return TYPE_FILTER + StringManipulation.toGraphQlModelName((String)key);
    }
}

