/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentParser;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.argument.CreateMutationArgumentParser;
import com.ontotext.graphql.parser.argument.DeleteMutationArgumentParser;
import com.ontotext.graphql.parser.argument.UpdateMutationArgumentParser;
import com.ontotext.models.OperationType;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.query.InputValueConverter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class MutationArgumentParser
implements ArgumentParser {
    private final InputValueConverter valueConverter;

    public MutationArgumentParser(InputValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    @Override
    public Object parseArgument(Object argValues, ArgumentParserContext parserContext) {
        List<Change> resultChanges;
        List<Map<String, Object>> mutationProps = this.convertArgumentToList(argValues);
        List<Map<String, Object>> metadata = this.convertMetadata(parserContext.getMetadata(), mutationProps.size());
        OperationType operationType = parserContext.getOperationType();
        if (operationType == OperationType.UPDATE) {
            UpdateMutationArgumentParser updateParser = new UpdateMutationArgumentParser(this.valueConverter, parserContext);
            resultChanges = updateParser.readMutationUpdate(mutationProps, metadata);
        } else if (operationType == OperationType.CREATE) {
            CreateMutationArgumentParser createParser = new CreateMutationArgumentParser(this.valueConverter, parserContext);
            resultChanges = createParser.readMutationCreate(mutationProps, metadata);
        } else {
            DeleteMutationArgumentParser deleteParser = new DeleteMutationArgumentParser(this.valueConverter, parserContext);
            resultChanges = deleteParser.readMutationDelete(mutationProps, metadata);
        }
        resultChanges.forEach(change -> change.transformChanges(MutationArgumentParser.removeDuplicateChanges()));
        return resultChanges;
    }

    private List<Map<String, Object>> convertArgumentToList(Object argValues) {
        List<Map> mutationProps;
        if (argValues instanceof List && !((List)argValues).isEmpty()) {
            mutationProps = (List<Map>)argValues;
        } else if (argValues instanceof Map && !((Map)argValues).isEmpty()) {
            mutationProps = Collections.singletonList((Map)argValues);
        } else {
            throw new IllegalArgumentException("Invalid mutation. A mutation must contain at least one change.");
        }
        return mutationProps;
    }

    private static UnaryOperator<PropertyChange> removeDuplicateChanges() {
        HashSet uniqueChanges = new HashSet();
        return change -> {
            if (uniqueChanges.contains(change)) {
                return null;
            }
            uniqueChanges.add(change);
            return change;
        };
    }

    private List<Map<String, Object>> convertMetadata(Map<String, Object> metadata, int valuesSize) {
        if (metadata == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(metadata);
        copy.remove("sourceLocation");
        if (!copy.isEmpty()) {
            String next = (String)copy.keySet().iterator().next();
            try {
                Integer.valueOf(next);
            }
            catch (NumberFormatException nfe) {
                return Collections.singletonList(metadata);
            }
        }
        if (copy.size() != valuesSize) {
            return Collections.emptyList();
        }
        return copy.values().stream().map(val -> (Map)val).collect(Collectors.toList());
    }

    @Override
    public void register(ArgumentConverter argumentConverter) {
        argumentConverter.registerArgumentParser("objects", this);
    }
}

