/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.argument.ErrorReporting;
import com.ontotext.models.OperationType;
import com.ontotext.models.Shape;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.SourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DeleteMutationArgumentParser {
    private final InputValueConverter valueConverter;
    private final ArgumentParserContext parserContext;

    public DeleteMutationArgumentParser(InputValueConverter valueConverter, ArgumentParserContext parserContext) {
        this.valueConverter = valueConverter;
        this.parserContext = parserContext;
        if (parserContext.getOperationType() != OperationType.DELETE) {
            throw new IllegalArgumentException("Passed none DELETE operation. Cannot process " + String.valueOf(parserContext.getOperationType()) + " operations.");
        }
    }

    List<Change> readMutationDelete(List<Map<String, Object>> mutationProps, List<Map<String, Object>> metadata) {
        Shape type = this.parserContext.getContainingType();
        List idList = this.parserContext.getArguments().resolveId();
        ErrorReporting reporter = new ErrorReporting();
        LinkedHashMap changes = new LinkedHashMap();
        for (int i = 0; i < mutationProps.size(); ++i) {
            Map<String, Object> objectMetadata = metadata.isEmpty() ? Collections.emptyMap() : metadata.get(i);
            ErrorReporting errorReporting = reporter.newRootReporter(objectMetadata);
            idList.forEach(deleteId -> changes.computeIfAbsent(deleteId, this.createChange(type, errorReporting.getLocation())));
        }
        reporter.report();
        return new ArrayList<Change>(changes.values());
    }

    private Function<String, Change> createChange(Shape type, SourceLocation location) {
        return changeId -> new Change(changeId, OperationType.DELETE, type, location, this.valueConverter);
    }
}

