/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentConverterFactory;
import com.ontotext.graphql.parser.argument.DefaultArgumentConverter;
import com.ontotext.graphql.parser.argument.WhereArgumentParser;
import com.ontotext.graphql.parser.argument.optimization.AddMinus;
import com.ontotext.graphql.parser.argument.optimization.AddSelectDistinct;
import com.ontotext.graphql.parser.argument.optimization.AddSelectDistinctPreprocess;
import com.ontotext.graphql.parser.argument.optimization.StatisticsCollectorManager;
import com.ontotext.models.OperationType;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.Collections;

public class DefaultArgumentConverterFactory
implements ArgumentConverterFactory {
    private InputValueConverter inputValueConverter;
    private StatisticsCollectorManager statisticsCollector;

    public DefaultArgumentConverterFactory(InputValueConverter inputValueConverter, StatisticsCollectorManager statisticsCollector) {
        this.inputValueConverter = inputValueConverter;
        this.statisticsCollector = statisticsCollector;
    }

    @Override
    public ArgumentConverter getConverter() {
        DefaultArgumentConverter argumentConverter = new DefaultArgumentConverter(this.inputValueConverter);
        if (this.statisticsCollector.isEnabled()) {
            WhereArgumentParser whereArgumentParser = new WhereArgumentParser(this.inputValueConverter);
            whereArgumentParser.addOptimization(new AddSelectDistinctPreprocess(Collections.singletonList(OperationType.UPDATE)));
            whereArgumentParser.addOptimization(new AddSelectDistinct(this.statisticsCollector, Collections.singletonList(OperationType.UPDATE)));
            whereArgumentParser.addOptimization(new AddMinus(this.statisticsCollector));
            whereArgumentParser.register(argumentConverter);
        }
        PluginsManager.addConfig((Object)argumentConverter);
        return argumentConverter;
    }
}

