/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.NodePathCollector;
import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.SelectionBuilder;
import com.ontotext.models.Operation;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.FilteredSelection;
import com.ontotext.rbac.SecurityContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;

@Order(value=780)
public class WhereFilterSelectionGenerator
implements OperationPostProcessor {
    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        SelectionBuilder selectionBuilder = new SelectionBuilder(operation.getSchema());
        this.createWhereSelection((Selectable)operation, selectionBuilder);
        if (operation instanceof Mutation) {
            this.createMutationWhereSelections((Mutation)operation, selectionBuilder);
            ((Mutation)operation).getMutationQuerySelection().ifPresent(selection -> this.createWhereSelection((Selectable)selection, selectionBuilder));
        }
    }

    private void createWhereSelection(Selectable selectable, SelectionBuilder selectionBuilder) {
        Arguments arguments = selectable.getArguments();
        arguments.getWhere().ifPresent(this.collectAndProcess(selectable, selectionBuilder));
        selectable.getSelections().forEach(selectable1 -> this.createWhereSelection((Selectable)selectable1, selectionBuilder));
    }

    private Consumer<ExpressionValue<?>> collectAndProcess(Selectable selectable, SelectionBuilder selectionBuilder) {
        return expression -> ((Collection)expression.accept((ExpressionVisitor)new NodePathCollector(), (ExpressionVisitorContext)new NodePathCollector.Context())).forEach(this.processWherePath(selectable, selectionBuilder));
    }

    private Consumer<List<Pair<String, String>>> processWherePath(Selectable selectable, SelectionBuilder selectionBuilder) {
        return wherePath -> {
            Selectable current = selectable;
            for (Pair step : wherePath) {
                Selectable parent = current;
                String type = (String)step.getKey();
                String property = (String)step.getValue();
                current = (Selectable)current.getWhereSelections().stream().filter(Selectable.byNameAndParentType((String)property, (String)type)).findFirst().orElseGet(selectionBuilder.addWhereSelection(property, type, parent));
                ((Selection)current).setService(parent.getService());
            }
        };
    }

    private void createMutationWhereSelections(Mutation operation, SelectionBuilder selectionBuilder) {
        List changes = operation.getArguments().getChanges().orElse(Collections.emptyList());
        for (Change change : changes) {
            if (change.hasPreconditions() && change.getPreconditions().getPrecondition() != null) {
                if (change.getPreconditions().getIncomingRelation() != null) {
                    Selection selection = WhereFilterSelectionGenerator.createDummySelection(change.getShape(), change.getPreconditions().getIncomingRelation());
                    this.collectAndProcess((Selectable)selection, selectionBuilder).accept(change.getPreconditions().getPrecondition());
                    change.getPreconditions().getPreconditionSelection().setSelection((Selectable)selection);
                } else {
                    change.getPreconditions().getPreconditionSelection().setSelection((Selectable)operation.toQuery());
                }
            }
            change.getChanges().stream().filter(propertyChange -> propertyChange.getWhere() != null).forEach(propertyChange -> {
                Selection selection = WhereFilterSelectionGenerator.createDummySelection(change.getShape(), change.getPropertyChangeShape(propertyChange.getName()));
                this.collectAndProcess((Selectable)selection, selectionBuilder).accept(propertyChange.getWhere());
                propertyChange.getWhereSelection().setSelection((Selectable)selection);
            });
            change.getAllFilteredObjects().forEach((property, filters) -> {
                for (FilteredSelection filter : filters) {
                    Selection selection = WhereFilterSelectionGenerator.createDummySelection(change.getShape(), change.getPropertyChangeShape(property));
                    this.collectAndProcess((Selectable)selection, selectionBuilder).accept(filter.getExpression());
                    filter.setSelection((Selectable)selection);
                }
            });
        }
    }

    private static Selection createDummySelection(Shape shape, PropertyShape property) {
        Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
        Selection tempSelection = new Selection();
        tempSelection.setName(property.getName());
        tempSelection.setDefinedInType(shape);
        if (property.isScalarType()) {
            tempSelection.setType(property.getScalarType().getGraphql());
        } else {
            tempSelection.setType(prefixes.toName(property.getRange()));
        }
        tempSelection.setDefinedIn(shape.getId());
        tempSelection.setSelections(new LinkedList());
        return tempSelection;
    }
}

