/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.SourceLocation;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SelectionBuilder {
    private final SomlSchema somlSchema;

    public SelectionBuilder(SomlSchema somlSchema) {
        this.somlSchema = somlSchema;
    }

    public Supplier<Selection> addSelection(String name, String type, Selectable parent) {
        return () -> this.pathToSelectable(name, type, parent, parent.getSelections()::add);
    }

    public Supplier<Selection> addWhereSelection(String name, String type, Selectable parent) {
        return () -> this.pathToSelectable(name, type, parent, parent.getWhereSelections()::add);
    }

    Selection pathToSelectable(String nodeName, String parentType, Selectable parent, Consumer<Selection> consumer) {
        String currentParentType = parentType;
        if ("Literal".equals(currentParentType)) {
            currentParentType = parent.getType();
            if (currentParentType.endsWith("_Mutation_Response")) {
                currentParentType = currentParentType.replace("_Mutation_Response", "");
            }
            if (currentParentType.endsWith("_Subscription")) {
                currentParentType = currentParentType.replace("_Subscription", "");
            }
        }
        Selection tempSelection = new Selection();
        tempSelection.setSelections(new LinkedList());
        Prefixes prefixes = this.somlSchema.getPrefixes();
        String name = nodeName;
        if (!name.startsWith("__")) {
            name = prefixes.toName(nodeName);
        }
        tempSelection.setName(name);
        String parentTypeIri = prefixes.nameToShortIri(currentParentType);
        Shape definedInType = (Shape)this.somlSchema.getObjects().get((Object)parentTypeIri);
        tempSelection.setDefinedInType(definedInType);
        tempSelection.setDefinedIn(currentParentType);
        tempSelection.setParent(parent);
        tempSelection.setNonNullable(false);
        tempSelection.setRequestedByUser(false);
        tempSelection.setService(parent.getService());
        PropertyShape propertyShape = tempSelection.getProperty().orElse(null);
        if (propertyShape != null) {
            tempSelection.setCollection(propertyShape.isMultivalued());
            if (propertyShape.isLiteral()) {
                tempSelection.setType("Literal");
            } else {
                tempSelection.setType(propertyShape.getRange());
            }
            if (null != propertyShape.getRangeCheck()) {
                tempSelection.setRangeCheck(propertyShape.getRangeCheck().booleanValue());
            }
        } else {
            tempSelection.setType("string");
            tempSelection.setRangeCheck(false);
        }
        SourceLocation sourceLocation = parent.getSelections().stream().filter(Selectable.byName((String)name)).map(Selectable::getLocation).filter(Objects::nonNull).findFirst().orElseGet(() -> ((Selectable)parent).getLocation());
        tempSelection.setLocation(sourceLocation);
        consumer.accept(tempSelection);
        return tempSelection;
    }

    public SomlSchema getSchema() {
        return this.somlSchema;
    }
}

