/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.SelectionBuilder;
import com.ontotext.models.Operation;
import com.ontotext.models.Selectable;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.plugin.Order;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

@Order(value=700)
public class OrderSelectionGenerator
implements OperationPostProcessor {
    private SelectionBuilder selectionBuilder;

    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        this.createOrderSelections((Selectable)operation, new SelectionBuilder(operation.getSchema()));
    }

    private void createOrderSelections(Selectable selectable, SelectionBuilder selectionBuilder) {
        selectable.getArguments().getOrder().ifPresent(orderList -> orderList.forEach(this.processOrderProperty(selectable, selectionBuilder)));
        selectable.getSelections().forEach(selectable1 -> this.createOrderSelections((Selectable)selectable1, selectionBuilder));
    }

    private Consumer<com.ontotext.models.query.Order> processOrderProperty(Selectable selectable, SelectionBuilder selectionBuilder) {
        return order -> {
            Selectable current = selectable;
            List orderPath = order.getOrderPathWithTypes();
            for (int i = 0; i < orderPath.size(); ++i) {
                String step = (String)orderPath.get(i);
                Selectable parent = current;
                String type = parent.getType();
                boolean requiresValueTypeCheck = step.startsWith("_if");
                if (requiresValueTypeCheck) {
                    type = step.substring(3);
                    step = (String)orderPath.get(++i);
                }
                current = (Selectable)current.getSelections().stream().filter(Selectable.byNameOrAlias((String)step)).filter(sel -> !sel.isCountSelection()).filter(this.selectionNotInFragment().or(sel -> requiresValueTypeCheck)).findFirst().orElseGet(selectionBuilder.addSelection(step, type, parent));
                if (!requiresValueTypeCheck) continue;
                current.getArguments().setAsInheritedOrderBy();
            }
            Selectable parent = current.getParent();
            if (parent.getSelections().stream().noneMatch(Selectable.byName((String)current.getName()).and(selection -> selection.getArguments().containsKey((Object)"dir")))) {
                current.getArguments().setOrderDirection((Object)order.isAscending());
            }
        };
    }

    private Predicate<? super Selectable> selectionNotInFragment() {
        return selectable -> !selectable.isInFragment();
    }
}

