/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.SelectionBuilder;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentConverterAware;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.LangConfig;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.LangFilter;
import com.ontotext.rbac.SecurityContext;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Order(value=600)
public class LangStringOrderPostProcessor
implements OperationPostProcessor,
ArgumentConverterAware {
    private static final String UNKNOWN_LANG = "other";
    private ArgumentConverter argumentConverter;

    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        this.createOrderSelections((Selectable)operation, errors, new SelectionBuilder(operation.getSchema()));
        if (!errors.isEmpty()) {
            throw new InvalidOperationException("Failed to parse language filter used for literal ordering", errors);
        }
    }

    private void createOrderSelections(Selectable selectable, List<GraphQLError> errors, SelectionBuilder selectionBuilder) {
        if (selectable.getArguments().getOrder().isPresent()) {
            try {
                this.processSelection(selectable, selectionBuilder);
            }
            catch (InvalidOperationException ioe) {
                errors.addAll(ioe.getErrors());
            }
        }
        selectable.getSelections().forEach(subSelection -> this.createOrderSelections((Selectable)subSelection, errors, selectionBuilder));
    }

    private void processSelection(Selectable selectable, SelectionBuilder selectionBuilder) {
        block1: {
            String node;
            com.ontotext.models.query.Order literalOrderBy = this.normalizeLiteralOrderBy(selectable, selectionBuilder.getSchema());
            if (literalOrderBy == null) break block1;
            Selectable currentParentSelection = selectable;
            Iterator iterator = literalOrderBy.getObjectReferenceChain().iterator();
            while (iterator.hasNext() && (currentParentSelection = this.handleReferenceNode(literalOrderBy, currentParentSelection, node = (String)iterator.next(), selectionBuilder)) != null) {
            }
        }
    }

    private Selectable handleReferenceNode(com.ontotext.models.query.Order literalOrderBy, Selectable parentSelection, String node, SelectionBuilder selectionBuilder) {
        Optional<PropertyShape> property = this.getProperty(parentSelection.getDefinedInType(), node, selectionBuilder.getSchema());
        if (property.isEmpty()) {
            return null;
        }
        PropertyShape propertyShape = property.get();
        if (propertyShape.isScalarType()) {
            if (propertyShape.getScalarType().isLangStringSupported()) {
                this.addLiteralSpecificOrderSelections(literalOrderBy, parentSelection, node, selectionBuilder);
            }
        } else {
            return (Selectable)parentSelection.getSelections().stream().filter(Selectable.byName((String)node)).filter(selection -> !selection.isInFragment()).findFirst().orElseGet(selectionBuilder.addSelection(node, propertyShape.getRange(), parentSelection));
        }
        return parentSelection;
    }

    private void addLiteralSpecificOrderSelections(com.ontotext.models.query.Order literalOrderBy, Selectable currentParentSelection, String node, SelectionBuilder selectionBuilder) {
        Selection selection = selectionBuilder.addSelection(node, currentParentSelection.getType(), currentParentSelection).get();
        SomlSchema somlSchema = selectionBuilder.getSchema();
        LangFilter filter = this.parseLangFilter(literalOrderBy.getRawValue(), (Selectable)selection, somlSchema);
        Selection valueSelection = selectionBuilder.addSelection("value", "Literal", (Selectable)selection).get();
        List<LangFilter> filterLanguages = this.splitPerLang(filter, (Selectable)selection, somlSchema);
        if (filterLanguages.isEmpty()) {
            filterLanguages = Collections.singletonList(LangFilter.parseForOrderByLiteral((String)"en~"));
        }
        Iterator<LangFilter> it = filterLanguages.iterator();
        while (it.hasNext()) {
            LangFilter langFilter = it.next();
            String langSuffix = LangStringOrderPostProcessor.getLangSuffix(langFilter.getTokens());
            selection.getArguments().setLangFilter(langFilter);
            selection.setAlias(selection.getName() + "_" + langSuffix);
            valueSelection.setAlias("value_" + langSuffix);
            valueSelection.getArguments().setOrderDirection((Object)literalOrderBy.isAscending());
            it.remove();
            if (!it.hasNext()) continue;
            selection = selectionBuilder.addSelection(node, currentParentSelection.getType(), currentParentSelection).get();
            valueSelection = selectionBuilder.addSelection("value", "Literal", (Selectable)selection).get();
        }
    }

    private static String getLangSuffix(Collection<LangFilter.Token> tokens) {
        return tokens.stream().map(LangFilter.Token::getLanguage).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(UNKNOWN_LANG).replace("-", "_");
    }

    private List<LangFilter> splitPerLang(LangFilter filter, Selectable parent, SomlSchema somlSchema) {
        if (filter == null) {
            return Collections.emptyList();
        }
        Map<String, List<LangFilter.Token>> groupByLang = filter.getTokens().stream().collect(Collectors.groupingBy(token -> token.getLanguage().orElse(UNKNOWN_LANG)));
        return filter.getTokens().stream().filter(LangFilter.Token::isInclusion).map(token -> (List)groupByLang.remove(token.getLanguage().orElse(UNKNOWN_LANG))).filter(Objects::nonNull).map(tokens -> {
            String subToken = LangFilter.Token.toString((List)tokens);
            if (tokens.stream().allMatch(LangFilter.Token::isExclusion)) {
                throw new IllegalArgumentException(ErrorMessages.get((String)"query.langString.positiveMatchIsRequired", (Object[])new Object[]{subToken}));
            }
            return this.parseLangFilter(subToken, parent, somlSchema);
        }).filter(Objects::nonNull).limit(1L).collect(Collectors.toList());
    }

    private LangFilter parseLangFilter(String filterValue, Selectable selectable, SomlSchema somlSchema) {
        Shape literalShape = (Shape)somlSchema.getObjects().get((Object)"Literal");
        ArgumentParserContext parserContext = new ArgumentParserContext(selectable.getName(), OperationType.UPDATE, literalShape, selectable.getArguments(), this.argumentConverter, selectable.getVariables());
        String updatedFilter = (String)LangFilter.prepareForLanguageOrdering((String)filterValue, (String)selectable.getVariables().getAcceptLanguage()).orElseThrow(RuntimeException::new);
        LangFilter langFilter = LangStringOrderPostProcessor.validateAndParseLanguageFilter(updatedFilter, LangFilter::parseForOrderByLiteral, selectable);
        if (langFilter == null) {
            return null;
        }
        LinkedHashMap<String, LangFilter> map = new LinkedHashMap<String, LangFilter>();
        map.put("lang", langFilter);
        ExpressionValue expression = (ExpressionValue)this.argumentConverter.convert("where", map, parserContext);
        langFilter.setExpression(expression);
        return langFilter;
    }

    private com.ontotext.models.query.Order normalizeLiteralOrderBy(Selectable selectable, SomlSchema somlSchema) {
        com.ontotext.models.query.Order updatedLiteralOrder;
        List<com.ontotext.models.query.Order> orders = selectable.getArguments().getOrder().orElse(Collections.emptyList());
        if (orders.isEmpty()) {
            return null;
        }
        com.ontotext.models.query.Order literalOrder = this.findLiteralPropertyOrder(selectable, orders, somlSchema);
        if (literalOrder == null) {
            return null;
        }
        List literalOrderPath = literalOrder.getOrderPath();
        Function<String, LangFilter> langParser = literalOrderPath.isEmpty() ? LangFilter::parse : LangFilter::parseForOrderByLiteral;
        Optional<com.ontotext.models.query.Order> direction = orders.stream().filter(order -> "dir".equals(order.getProperty())).findFirst();
        boolean isAscending = direction.map(com.ontotext.models.query.Order::isAscending).orElseGet(() -> ((com.ontotext.models.query.Order)literalOrder).isAscending());
        String preferenceLang = this.getLangPreference(selectable, literalOrder, somlSchema).orElse("");
        LangStringOrderPostProcessor.validateAndParseLanguageFilter(preferenceLang, langParser, selectable);
        int literalOrderIndex = orders.indexOf(literalOrder);
        if (direction.isPresent()) {
            com.ontotext.models.query.Order dir = direction.get();
            updatedLiteralOrder = new com.ontotext.models.query.Order(literalOrder.getObjectReferenceChain(), "value", isAscending, preferenceLang);
            orders.addAll(literalOrderIndex, LangStringOrderPostProcessor.splitOrder(updatedLiteralOrder, langParser, selectable));
            orders.remove(dir);
        } else {
            List<String> propertyPath = this.resolveParentReferenceChain(selectable, literalOrder, somlSchema);
            updatedLiteralOrder = new com.ontotext.models.query.Order(propertyPath, "value", isAscending, preferenceLang);
            orders.addAll(literalOrderIndex, LangStringOrderPostProcessor.splitOrder(updatedLiteralOrder, langParser, selectable));
        }
        orders.remove(literalOrder);
        return updatedLiteralOrder;
    }

    private List<String> resolveParentReferenceChain(Selectable selectable, com.ontotext.models.query.Order literalOrder, SomlSchema somlSchema) {
        List literalOrderPath = literalOrder.getOrderPath();
        String propertyName = literalOrderPath.isEmpty() ? selectable.getName() : (String)literalOrderPath.stream().filter(Predicate.isEqual("lang").negate()).reduce((prev, next) -> next).orElseThrow(IllegalArgumentException::new);
        boolean multiValueProperty = false;
        if (!"name".equals(propertyName)) {
            multiValueProperty = this.getProperty(selectable.getDefinedInType(), propertyName, somlSchema).map(PropertyShape::isMultivalued).orElseThrow(IllegalArgumentException::new);
        }
        return multiValueProperty ? literalOrder.getObjectReferenceChain() : literalOrderPath;
    }

    private static LangFilter validateAndParseLanguageFilter(String preferenceLang, Function<String, LangFilter> langParser, Selectable selectable) {
        if (preferenceLang != null) {
            if (!preferenceLang.isEmpty()) {
                return LangStringOrderPostProcessor.parserLangFilter(preferenceLang, langParser, selectable.getLocation());
            }
            if (!LangStringOrderPostProcessor.isLiteralOrder(selectable)) {
                throw LangStringOrderPostProcessor.createValidationError(ErrorMessages.get((String)"query.langString.atLeastOneLangRequired", (Object[])new Object[]{selectable.getName()}), selectable.getLocation());
            }
        }
        return null;
    }

    private static boolean isLiteralOrder(Selectable selectable) {
        return selectable.getArguments().getOrder().filter(orders -> orders.stream().anyMatch(order -> order.getProperty() == null)).isPresent();
    }

    private static Collection<com.ontotext.models.query.Order> splitOrder(com.ontotext.models.query.Order order, Function<String, LangFilter> langParser, Selectable selectable) {
        String rawValue = order.getRawValue();
        if (order.getOrderPath().stream().allMatch(Predicate.isEqual("value"))) {
            return Collections.singletonList(order);
        }
        LangFilter filter = LangStringOrderPostProcessor.parserLangFilter(rawValue, langParser, selectable.getLocation());
        Map<String, List<LangFilter.Token>> groupByLang = filter.getTokens().stream().collect(Collectors.groupingBy(token -> token.getLanguage().orElse(UNKNOWN_LANG)));
        return filter.getTokens().stream().filter(LangFilter.Token::isInclusion).map(token -> (List)groupByLang.remove(token.getLanguage().orElse(UNKNOWN_LANG))).filter(Objects::nonNull).map(tokens -> {
            String subToken = LangFilter.Token.toString((List)tokens);
            String langSuffix = LangStringOrderPostProcessor.getLangSuffix(tokens);
            return new com.ontotext.models.query.Order(LangStringOrderPostProcessor.appendLangToLastElement(order, langSuffix), order.getProperty() + "_" + langSuffix, order.isAscending(), subToken);
        }).limit(1L).collect(Collectors.toList());
    }

    private static LangFilter parserLangFilter(String rawValue, Function<String, LangFilter> langParser, com.ontotext.models.query.SourceLocation location) {
        try {
            return langParser.apply(rawValue);
        }
        catch (IllegalArgumentException iae) {
            throw LangStringOrderPostProcessor.createValidationError(iae.getMessage(), location);
        }
    }

    private static InvalidOperationException createValidationError(String message, com.ontotext.models.query.SourceLocation location) {
        SourceLocation sourceLocation = null;
        if (location != null) {
            sourceLocation = new SourceLocation(location.getLine(), location.getColumn());
        }
        return new InvalidOperationException("", Collections.singletonList(new SimpleGraphQlError(message, sourceLocation == null ? null : Collections.singletonList(sourceLocation), (ErrorClassification)ErrorType.ValidationError)));
    }

    private static List<String> appendLangToLastElement(com.ontotext.models.query.Order order, String lang) {
        List referenceChain = order.getObjectReferenceChain();
        if (referenceChain.isEmpty()) {
            return referenceChain;
        }
        String lastNode = (String)referenceChain.get(referenceChain.size() - 1);
        LinkedList<String> references = new LinkedList<String>(referenceChain.subList(0, referenceChain.size() - 1));
        references.add(lastNode + "_" + lang);
        return references;
    }

    private Optional<String> getLangPreference(Selectable selectable, com.ontotext.models.query.Order literalOrder, SomlSchema somlSchema) {
        String preferenceLang = "lang".equals(literalOrder.getProperty()) ? literalOrder.getRawValue() : LangStringOrderPostProcessor.sanitizeOrderLang(LangStringOrderPostProcessor.resolveLangPreferenceFilter(selectable).orElseGet(() -> this.getSchemaLangPreference(selectable, somlSchema)));
        return LangFilter.prepareForLanguageOrdering((String)preferenceLang, (String)selectable.getVariables().getAcceptLanguage());
    }

    private static String sanitizeOrderLang(String preferenceLang) {
        if (preferenceLang == null) {
            return null;
        }
        LangFilter filter = LangFilter.parse((String)preferenceLang);
        List tokens = filter.getTokens().stream().filter(token -> token.getType() != LangFilter.TokenType.ANY).collect(Collectors.toList());
        return LangFilter.Token.toString(tokens);
    }

    private String getSchemaLangPreference(Selectable selectable, SomlSchema somlSchema) {
        if (selectable instanceof Operation) {
            Optional orders = selectable.getArguments().getOrder();
            if (orders.isEmpty()) {
                return null;
            }
            com.ontotext.models.query.Order propertyOrder = this.findLiteralPropertyOrder(selectable, (List)orders.get(), somlSchema);
            assert (propertyOrder != null) : "The literal property order should not be null as we already resolve it";
            Shape current = selectable.getDefinedInType();
            for (String property : propertyOrder.getOrderPath()) {
                String defaultPattern = LangStringOrderPostProcessor.getDefaultPatternForProperty(property);
                PropertyShape propertyShape = this.getProperty(current, property, somlSchema).orElseThrow(IllegalStateException::new);
                if (!propertyShape.isScalarType()) {
                    current = (Shape)somlSchema.getObjects().get((Object)propertyShape.getRange());
                    continue;
                }
                if (!propertyShape.isLiteral() || !propertyShape.getScalarType().isLangStringSupported()) continue;
                if (propertyShape.getLangConfig() != null) {
                    return Objects.toString(StringUtils.trimToNull((String)propertyShape.getLangConfig().getFetch()), defaultPattern);
                }
                return defaultPattern;
            }
        }
        return selectable.getProperty().map(PropertyShape::getLangConfig).map(LangConfig::getFetch).orElse(null);
    }

    private static String getDefaultPatternForProperty(String property) {
        return "name".equals(property) ? "en~,NONE,~" : "~,NONE";
    }

    private com.ontotext.models.query.Order findLiteralPropertyOrder(Selectable selectable, List<com.ontotext.models.query.Order> orders, SomlSchema somlSchema) {
        List literalOrders = orders.stream().filter(this.isLiteralOrderProperty(selectable, somlSchema)).collect(Collectors.toList());
        if (literalOrders.isEmpty()) {
            return null;
        }
        Optional<com.ontotext.models.query.Order> orderedLiteralProperty = literalOrders.stream().filter(order -> order.getOrderPath().isEmpty()).findFirst();
        if (orderedLiteralProperty.isPresent()) {
            return orderedLiteralProperty.get();
        }
        Optional<com.ontotext.models.query.Order> lang = literalOrders.stream().filter(order -> "lang".equals(order.getProperty())).findFirst();
        if (lang.isPresent()) {
            return lang.get();
        }
        Optional<com.ontotext.models.query.Order> direction = literalOrders.stream().filter(order -> "dir".equals(order.getProperty())).findFirst();
        if (direction.isPresent()) {
            com.ontotext.models.query.Order dirOrder = direction.get();
            if (literalOrders.size() == 1) {
                ArrayList referenceChain = new ArrayList(dirOrder.getObjectReferenceChain());
                com.ontotext.models.query.Order newLiteralOrder = new com.ontotext.models.query.Order(referenceChain, null, dirOrder.isAscending(), null);
                orders.add(orders.indexOf(dirOrder), newLiteralOrder);
                return newLiteralOrder;
            }
            literalOrders.remove(dirOrder);
        }
        return (com.ontotext.models.query.Order)literalOrders.get(0);
    }

    private Predicate<com.ontotext.models.query.Order> isLiteralOrderProperty(Selectable selectable, SomlSchema somlSchema) {
        if (LangStringOrderPostProcessor.isLiteralProperty(selectable)) {
            return order -> order.getOrderPath().isEmpty();
        }
        return order -> this.isOrderPathPointingToLiteralProperty((com.ontotext.models.query.Order)order, selectable.getDefinedInType(), somlSchema);
    }

    private boolean isOrderPathPointingToLiteralProperty(com.ontotext.models.query.Order order, Shape containedIn, SomlSchema somlSchema) {
        String pathNode;
        Optional<PropertyShape> propertyShape;
        Iterator iterator = order.getOrderPath().iterator();
        while (iterator.hasNext() && !(propertyShape = this.getProperty(containedIn, pathNode = (String)iterator.next(), somlSchema)).isEmpty()) {
            PropertyShape property = propertyShape.get();
            if (property.isScalarType()) {
                if (!property.getScalarType().isLangStringSupported()) break;
                return true;
            }
            containedIn = (Shape)somlSchema.getObjects().get((Object)property.getRange());
        }
        return false;
    }

    private Optional<PropertyShape> getProperty(Shape currentType, String propertyName, SomlSchema somlSchema) {
        if ("name".equals(propertyName) && currentType.getName() != null) {
            return currentType.getProperty(currentType.getName());
        }
        return currentType.getProperty(somlSchema.getPrefixes().nameToShortIri(propertyName));
    }

    private static Optional<String> resolveLangPreferenceFilter(Selectable selectable) {
        Object langFilterPreference = selectable.getArguments().get((Object)"lang");
        if (langFilterPreference != null) {
            return Optional.of(langFilterPreference.toString());
        }
        if (selectable.getParent() != null) {
            return LangStringOrderPostProcessor.resolveLangPreferenceFilter(selectable.getParent());
        }
        return Optional.empty();
    }

    private static boolean isLiteralProperty(Selectable current) {
        return current.getProperty().filter(PropertyShape::isScalarType).filter(propertyShape -> propertyShape.getScalarType().isLangStringSupported()).isPresent();
    }

    @Override
    public void setArgumentConverter(ArgumentConverter argumentConverter) {
        this.argumentConverter = argumentConverter;
    }
}

