/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.SelectionBuilder;
import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.rbac.SecurityContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

@Order(value=750)
public class FragmentGeneratorPostProcessor
implements OperationPostProcessor {
    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        SomlSchema somlSchema = operation.getSchema();
        SelectionBuilder selectionBuilder = new SelectionBuilder(somlSchema);
        if (!somlSchema.getObjects().containsKey((Object)operation.getType())) {
            return;
        }
        this.processSelectionsTree((Selectable)operation, selectionBuilder);
    }

    private void processSelectionsTree(Selectable selectable, SelectionBuilder selectionBuilder) {
        this.generateFragmentsIfNeeded(selectable, selectionBuilder);
        if (selectable.isComplexType() && selectable.isQueryable()) {
            for (Selectable selection : new ArrayList(selectable.getSelections())) {
                this.processSelectionsTree(selection, selectionBuilder);
            }
        }
    }

    private void generateFragmentsIfNeeded(Selectable selectable, SelectionBuilder selectionBuilder) {
        if (selectable instanceof Operation) {
            return;
        }
        PropertyShape property = selectable.getProperty().orElse(null);
        if (property == null) {
            return;
        }
        Shape shape = selectable.getDefinedInType();
        if (!shape.isAbstract()) {
            return;
        }
        Map customSubProperties = shape.getPropertyRepresentationInSubTypes(property.getName());
        Set<String> subTypesInDifferentService = this.getSubTypesWithDifferentServiceForSelection(selectable, shape);
        if (customSubProperties.isEmpty() && subTypesInDifferentService.isEmpty()) {
            return;
        }
        HashSet<Object> totalSubClassesToBeFragmented = new HashSet<Object>();
        totalSubClassesToBeFragmented.addAll(customSubProperties.keySet());
        totalSubClassesToBeFragmented.addAll(subTypesInDifferentService);
        Collection subTypes = shape.getConcreteSubTypes().stream().filter(child -> !child.isSystem() && child.isSynthetic() == false).collect(Collectors.toCollection(LinkedHashSet::new));
        if (subTypes.size() == totalSubClassesToBeFragmented.size()) {
            ((Selection)selectable).setTreeAsNoneQueryable();
        } else if (selectable instanceof Selection) {
            ((Selection)selectable).setDomainConstraints((Collection)subTypes.stream().filter(subType -> !totalSubClassesToBeFragmented.contains(subType.getId())).collect(Collectors.toList()));
        }
        Map groupByIri = customSubProperties.entrySet().stream().collect(Collectors.groupingBy(entry -> ((PropertyShape)entry.getValue()).getAsAbsoluteRdfProp(), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        groupByIri.values().removeIf(types -> types.size() == 1);
        List<List> groupsOfTypes = groupByIri.entrySet().stream().flatMap(entry -> this.asCommonService((String)entry.getKey(), (List)entry.getValue(), selectionBuilder)).map(Pair::getValue).collect(Collectors.toList());
        groupsOfTypes.removeIf(list -> list.size() == 1);
        groupsOfTypes.forEach(totalSubClassesToBeFragmented::removeAll);
        Map groupsOfTheSameService = totalSubClassesToBeFragmented.stream().map(arg_0 -> selectionBuilder.getSchema().getObjects().get(arg_0)).filter(type -> type.getServiceAddress() != null).filter(type -> !customSubProperties.containsKey(type.getId())).collect(Collectors.groupingBy(Shape::getServiceAddress, Collectors.mapping(Shape::getId, Collectors.toList())));
        groupsOfTheSameService.values().removeIf(list -> list.size() == 1);
        groupsOfTheSameService.values().forEach(totalSubClassesToBeFragmented::removeAll);
        groupsOfTypes.addAll(groupsOfTheSameService.values());
        for (String string : totalSubClassesToBeFragmented) {
            boolean exist;
            boolean bl = exist = selectable.getParent().getSelections().stream().anyMatch(Selectable.byNameAndParentType((String)selectable.getName(), (String)string)) && !subTypesInDifferentService.contains(string);
            if (exist) break;
            this.generateFragmentSelection(selectable, string, List.of(string), selectionBuilder);
        }
        for (List list2 : groupsOfTypes) {
            this.generateFragmentSelection(selectable, (String)list2.get(0), list2, selectionBuilder);
        }
    }

    private void generateFragmentSelection(Selectable selectable, String primaryType, List<String> domainConstraints, SelectionBuilder selectionBuilder) {
        Selection newSelection = selectionBuilder.addSelection(selectable.getName(), primaryType, selectable.getParent()).get();
        newSelection.setArguments(selectable.getArguments());
        newSelection.setRangeCheck(selectable.isRangeCheck());
        newSelection.setAlias(selectable.getAlias());
        newSelection.setDomainConstraints((Collection)domainConstraints.stream().map(arg_0 -> selectionBuilder.getSchema().getObjects().get(arg_0)).collect(Collectors.toList()));
        if (selectable.isComplexType()) {
            List subSelectionsCopy = selectable.getSelections().stream().map(Selection.class::cast).map(Selection::deepCopy).collect(Collectors.toList());
            newSelection.setSelections(subSelectionsCopy);
            if (newSelection.isQueryable()) {
                for (Selectable subSelection : new ArrayList(newSelection.getSelections())) {
                    this.processSelectionsTree(subSelection, selectionBuilder);
                }
            }
        }
    }

    private Stream<Pair<String, List<String>>> asCommonService(String key, List<String> value, SelectionBuilder selectionBuilder) {
        Map groupByService = value.stream().map(arg_0 -> selectionBuilder.getSchema().getObjects().get(arg_0)).collect(Collectors.groupingBy(type -> Objects.requireNonNullElse(type.getServiceAddress(), "NONE"), Collectors.mapping(Shape::getId, Collectors.toList())));
        return groupByService.values().stream().map(strings -> Pair.of((Object)key, (Object)strings));
    }

    private Set<String> getSubTypesWithDifferentServiceForSelection(Selectable selectable, Shape shape) {
        Set<String> subTypesInDifferentService = selectable.getName().equals("id") ? Collections.emptySet() : shape.getSubTypes().stream().filter(subType -> !Objects.equals(shape.getServiceAddress(), subType.getServiceAddress())).map(Shape::getId).collect(Collectors.toSet());
        return subTypesInDifferentService;
    }
}

