/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.GraphQlQueryParser;
import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentConverterFactory;
import com.ontotext.models.Operation;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.query.QueryParser;
import com.ontotext.models.query.QueryParserFactory;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ConfigurableGraphQlQueryParserFactory
implements QueryParserFactory {
    private final Supplier<SomlSchema> schemaSupplier;
    private final Supplier<GraphQLSchema> qlSchemaSupplier;
    private final ArgumentConverterFactory argumentConverterFactory;
    private Function<String, Mutation> mutationBuilder;
    private List<OperationPostProcessor> postProcessors = new CopyOnWriteArrayList<OperationPostProcessor>();
    private BiPredicate<OperationPostProcessor, Operation> postProcessorFilter;

    public ConfigurableGraphQlQueryParserFactory(Supplier<SomlSchema> schemaSupplier, Supplier<GraphQLSchema> qlSchemaSupplier, ArgumentConverterFactory argumentConverterFactory) {
        this.schemaSupplier = schemaSupplier;
        this.qlSchemaSupplier = qlSchemaSupplier;
        this.argumentConverterFactory = argumentConverterFactory;
    }

    public QueryParser createParser() {
        SomlSchema somlSchema = this.schemaSupplier.get();
        GraphQLSchema graphQlSchema = this.qlSchemaSupplier.get();
        ArgumentConverter argumentConverter = this.argumentConverterFactory.getConverter();
        GraphQlQueryParser queryParser = new GraphQlQueryParser(graphQlSchema, somlSchema, argumentConverter);
        queryParser.setMutationBuilder(this.getMutationBuilder());
        queryParser.addOperationPostProcessor(this.getPostProcessors());
        queryParser.setOperationPostProcessorFilter(this.getPostProcessorFilter());
        return queryParser;
    }

    public ConfigurableGraphQlQueryParserFactory addOperationPostProcessor(OperationPostProcessor postProcessor) {
        if (postProcessor != null) {
            this.postProcessors.add(postProcessor);
        }
        return this;
    }

    public List<OperationPostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public ConfigurableGraphQlQueryParserFactory setOperationPostProcessorFilter(BiPredicate<OperationPostProcessor, Operation> postProcessorFilter) {
        this.postProcessorFilter = postProcessorFilter;
        return this;
    }

    public BiPredicate<OperationPostProcessor, Operation> getPostProcessorFilter() {
        return this.postProcessorFilter;
    }

    public void setMutationBuilder(@Nullable Function<String, Mutation> mutationBuilder) {
        this.mutationBuilder = mutationBuilder;
    }

    @Nullable
    public Function<String, Mutation> getMutationBuilder() {
        return this.mutationBuilder;
    }
}

