/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.models.query.SourceLocation;
import graphql.language.AbstractNode;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.Node;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class ArgumentCollector
extends NodeVisitorStub {
    public static final String SOURCE_LOCATION = "sourceLocation";
    private Object value;
    private Map<String, Object> metadata;
    private final Map<String, Object> variables;
    private final Function<Object, Object> valueDecorator;

    public ArgumentCollector(Map<String, Object> variables) {
        this(variables, null);
    }

    public ArgumentCollector(Map<String, Object> variables, Function<Object, Object> valueDecorator) {
        this.variables = variables;
        this.valueDecorator = valueDecorator == null ? Function.identity() : valueDecorator;
    }

    public Object getValue() {
        return this.value;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    private void setValue(Object value) {
        this.value = this.valueDecorator.apply(value);
    }

    private void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public TraversalControl visitEnumValue(EnumValue node, TraverserContext<Node> context) {
        this.setValue(node.getName());
        this.generateMetadata((AbstractNode)node);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitStringValue(StringValue node, TraverserContext<Node> context) {
        this.setValue(node.getValue());
        this.generateMetadata((AbstractNode)node);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitArrayValue(ArrayValue node, TraverserContext<Node> context) {
        ArgumentCollector collector = new ArgumentCollector(this.variables, this.valueDecorator);
        ArrayList<Object> values = new ArrayList<Object>(node.getValues().size());
        this.generateMetadata((AbstractNode)node);
        int idx = 0;
        for (Value val : node.getValues()) {
            val.accept(null, (NodeVisitor)collector);
            values.add(collector.getValue());
            this.metadata.put(String.valueOf(idx++), collector.getMetadata());
        }
        this.setValue(values);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitBooleanValue(BooleanValue node, TraverserContext<Node> context) {
        this.setValue(node.isValue());
        this.generateMetadata((AbstractNode)node);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitFloatValue(FloatValue node, TraverserContext<Node> context) {
        this.setValue(node.getValue());
        this.generateMetadata((AbstractNode)node);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitIntValue(IntValue node, TraverserContext<Node> context) {
        this.setValue(node.getValue());
        this.generateMetadata((AbstractNode)node);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitNullValue(NullValue node, TraverserContext<Node> context) {
        this.setValue(null);
        this.generateMetadata((AbstractNode)node);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitObjectValue(ObjectValue node, TraverserContext<Node> context) {
        ArgumentCollector collector = new ArgumentCollector(this.variables, this.valueDecorator);
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        this.generateMetadata((AbstractNode)node);
        for (ObjectField objectField : node.getObjectFields()) {
            objectField.getValue().accept(null, (NodeVisitor)collector);
            values.put(objectField.getName(), collector.getValue());
            Map<String, Object> fieldMetadata = collector.getMetadata();
            fieldMetadata.computeIfAbsent(SOURCE_LOCATION, key -> this.metadata.get(SOURCE_LOCATION));
            this.metadata.put(objectField.getName(), fieldMetadata);
        }
        this.setValue(values);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitVariableReference(VariableReference node, TraverserContext<Node> context) {
        this.setValue(this.variables.get(node.getName()));
        this.generateMetadata((AbstractNode)node);
        return TraversalControl.CONTINUE;
    }

    private void generateMetadata(AbstractNode node) {
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>(4);
        if (node.getSourceLocation() != null) {
            SourceLocation loc = new SourceLocation(node.getSourceLocation().getLine(), node.getSourceLocation().getColumn());
            meta.put(SOURCE_LOCATION, loc);
        }
        this.setMetadata(meta);
    }
}

