/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.ObjectIndexedContainer;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectArrays {
    public static final Object[] EMPTY = new Object[0];
    private static final int BLANK_ARRAY_SIZE_IN_BIT_SHIFT = 10;
    private static final int BLANK_ARRAY_SIZE = 1024;
    private static final Object[] BLANKING_OBJECT_ARRAY = new Object[1024];

    private ObjectArrays() {
    }

    public static <KType> void rotate(KType[] table, int from, int mid, int to) {
        ObjectArrays.reverse(table, from, mid);
        ObjectArrays.reverse(table, mid, to);
        ObjectArrays.reverse(table, from, to);
    }

    public static <KType> void rotate(ObjectIndexedContainer<KType> table, int from, int mid, int to) {
        ObjectArrays.reverse(table, from, mid);
        ObjectArrays.reverse(table, mid, to);
        ObjectArrays.reverse(table, from, to);
    }

    public static <KType> void reverse(KType[] table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            KType tmpValue = table[i + from];
            table[i + from] = table[to - i - 1];
            table[to - i - 1] = tmpValue;
        }
    }

    public static <KType> void reverse(ObjectIndexedContainer<KType> table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            KType tmpValue = table.get(i + from);
            table.set(i + from, table.get(to - i - 1));
            table.set(to - i - 1, tmpValue);
        }
    }

    public static <KType> void blankArray(KType[] objectArray, int startIndex, int endIndex) {
        assert (startIndex <= endIndex);
        int size = endIndex - startIndex;
        int nbChunks = size >> 10;
        int rem = size & 0x3FF;
        for (int i = 0; i < nbChunks; ++i) {
            System.arraycopy(BLANKING_OBJECT_ARRAY, 0, objectArray, startIndex + (i << 10), 1024);
        }
        if (rem > 0) {
            Arrays.fill(objectArray, startIndex + (nbChunks << 10), startIndex + (nbChunks << 10) + rem, null);
        }
    }
}

