/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.generator.jsonld;

import com.ontotext.metamodel.generator.jsonld.JsonLdContextGenerator;
import com.ontotext.metamodel.generator.jsonld.JsonLdFrameOptions;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Query;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonLdFrameGenerator {
    private Set<String> forbiddenFrameSelections;
    private final SomlSchema somlSchema;
    private JsonLdFrameOptions frameOptions;
    private Map<String, Object> context;

    public JsonLdFrameGenerator(SomlSchema somlSchema) {
        this(somlSchema, new JsonLdFrameOptions());
    }

    public JsonLdFrameGenerator(SomlSchema somlSchema, JsonLdFrameOptions frameOptions) {
        this.somlSchema = somlSchema;
        this.setFrameOptions(frameOptions);
    }

    public Map<String, Object> getFrame(Query query) {
        Objects.requireNonNull(query, "Query is mandatory argument");
        Map<String, Object> frame = JsonLdFrameGenerator.newMap();
        frame.put("@context", new LinkedHashMap<String, Object>(this.getContext()));
        query.getArguments().getId().map(ids -> ids.stream().map(arg_0 -> ((Prefixes)this.somlSchema.getPrefixes()).toIri(arg_0)).collect(Collectors.toList())).ifPresent(ids -> {
            if (ids.size() == 1) {
                frame.put("@id", ids.get(0));
            } else {
                frame.put("@id", ids);
            }
        });
        Map<String, Object> topSelection = this.readSelections(query.getSelections(), query.getReturnType(), true);
        frame.putAll(topSelection);
        return frame;
    }

    public Map<String, Object> getContext() {
        if (this.context == null) {
            this.context = new JsonLdContextGenerator(this.somlSchema, this.frameOptions.getContextOptions()).generateContext();
        }
        return this.context;
    }

    private Map<String, Object> readSelections(List<Selection> selections, String returnType, boolean complexType) {
        Map<String, Object> builder = JsonLdFrameGenerator.newMap();
        if (selections == null || selections.isEmpty()) {
            return builder;
        }
        if (complexType && this.isTypeRequested(selections)) {
            builder.putAll(this.computeTypeSelector(returnType));
        }
        for (Selection selection : selections) {
            this.readSingleSelection(selection, builder);
        }
        return builder;
    }

    private boolean isTypeRequested(List<Selection> selections) {
        if (this.frameOptions.getTypeAlias() == null) {
            return true;
        }
        return selections.stream().anyMatch(selection -> this.frameOptions.getTypeAlias().equals(selection.getName()) || "__typename".equals(selection.getName()));
    }

    private void readSingleSelection(Selection selection, Map<String, Object> builder) {
        if (this.forbiddenFrameSelections.contains(selection.getName())) {
            return;
        }
        Map<String, Object> readSelectionSet = this.readSelections(selection.getSelections(), selection.getType(), selection.isComplexType());
        if (this.frameOptions.isAddDefaults()) {
            readSelectionSet.put("@default", this.computeDefault(selection));
        }
        builder.put(selection.getName(), readSelectionSet);
    }

    private Object computeDefault(Selection selection) {
        Map<String, Object> defaultSelection = selection.getSelections() == null || selection.getSelections().isEmpty() ? this.getPrimitiveDefault(selection.getType()) : this.createDefaultSelection(selection.getSelections());
        if (selection.isCollection()) {
            return Collections.singletonList(defaultSelection);
        }
        return defaultSelection;
    }

    private Map<String, Object> createDefaultSelection(List<Selection> selections) {
        if (selections == null || selections.isEmpty()) {
            throw new IllegalArgumentException("Can't generate defaults for non complex Type");
        }
        LinkedHashMap<String, Object> builder = new LinkedHashMap<String, Object>();
        for (Selection selection : selections) {
            if (selection.isCollection()) {
                builder.put(selection.getName(), Collections.emptyList());
                continue;
            }
            builder.put(selection.getName(), this.getPrimitiveDefault(selection.getType()));
        }
        return builder;
    }

    private Object getPrimitiveDefault(String type) {
        String typeLower = type.toLowerCase();
        if (typeLower.contains("int") || type.contains("long")) {
            return 0;
        }
        if (type.contains("float") || typeLower.contains("decimal")) {
            return 0.0;
        }
        if (type.contains("bool")) {
            return false;
        }
        return "";
    }

    private Map<String, Object> computeTypeSelector(String type) {
        Shapes shapes = this.somlSchema.getObjects();
        Shape referencedType = (Shape)shapes.get((Object)type);
        if (this.isTypeDefinedByRdfType(referencedType)) {
            Object rdfType = this.computeRelationRdfType(type);
            if (rdfType != null) {
                return Collections.singletonMap("@type", rdfType);
            }
            throw new InvalidSchemaException("Could not find defined rdf:type in type '" + type + "' hierarchy!");
        }
        if (referencedType.getType() == null || referencedType.getTypeAsList().isEmpty()) {
            throw new InvalidSchemaException(String.format("Expected at least one type value defined for %s.%s but found none!", type, referencedType.getTypeProp()));
        }
        return Collections.emptyMap();
    }

    private boolean isTypeDefinedByRdfType(Shape referencedType) {
        return "http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(this.somlSchema.getPrefixes().toIri(referencedType.getTypeProp()));
    }

    private Object computeRelationRdfType(String type) {
        Shapes shapes = this.somlSchema.getObjects();
        Shape referencedType = (Shape)shapes.get((Object)type);
        List subTypes = Stream.concat(Stream.of(referencedType), shapes.getConcreteSubTypes(type).stream()).filter(shape -> shape.getTypeAsList() != null).filter(this::isTypeDefinedByRdfType).flatMap(shape -> shape.getTypeAsList().stream()).distinct().collect(Collectors.toList());
        if (subTypes.isEmpty()) {
            return null;
        }
        if (subTypes.size() == 1) {
            return subTypes.get(0);
        }
        return subTypes;
    }

    private static Map<String, Object> newMap() {
        return new LinkedHashMap<String, Object>();
    }

    public JsonLdFrameOptions getFrameOptions() {
        return this.frameOptions.copy();
    }

    public void setFrameOptions(JsonLdFrameOptions frameOptions) {
        this.frameOptions = Objects.requireNonNull(frameOptions, "frame options cannot be null").copy();
        this.forbiddenFrameSelections = Stream.of(frameOptions.getIdAlias(), frameOptions.getTypeAlias()).filter(Objects::nonNull).collect(Collectors.toSet());
        this.context = null;
    }
}

