/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.generator.jsonld;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonLdContextOptions {
    private String idAlias = "id";
    private String typeAlias = "type";
    private String langAlias = "lang";
    private String valueAlias = "value";
    private String boNameAlias = "name";
    private String boTypeAlias = "__typename";
    private boolean useXsdString = false;
    private Set<String> ignoredPrefixes = Stream.of("xsd", "res").collect(Collectors.toSet());
    private Set<String> ignoredTypes = Stream.of("Object", "Literal").collect(Collectors.toSet());

    public String getIdAlias() {
        return this.idAlias;
    }

    public void setIdAlias(String idAlias) {
        this.idAlias = idAlias;
    }

    public String getTypeAlias() {
        return this.typeAlias;
    }

    public void setTypeAlias(String typeAlias) {
        this.typeAlias = typeAlias;
    }

    public String getLangAlias() {
        return this.langAlias;
    }

    public void setLangAlias(String langAlias) {
        this.langAlias = langAlias;
    }

    public String getValueAlias() {
        return this.valueAlias;
    }

    public void setValueAlias(String valueAlias) {
        this.valueAlias = valueAlias;
    }

    public boolean isUseXsdString() {
        return this.useXsdString;
    }

    public void setUseXsdString(boolean useXsdString) {
        this.useXsdString = useXsdString;
    }

    public String getBoNameAlias() {
        return this.boNameAlias;
    }

    public void setBoNameAlias(String boNameAlias) {
        this.boNameAlias = boNameAlias;
    }

    public String getBoTypeAlias() {
        return this.boTypeAlias;
    }

    public void setBoTypeAlias(String boTypeAlias) {
        this.boTypeAlias = boTypeAlias;
    }

    public JsonLdContextOptions addIgnoreType(String ignoreType) {
        this.ignoredTypes.add(ignoreType);
        return this;
    }

    public JsonLdContextOptions removeIgnoreType(String ignoreType) {
        this.ignoredTypes.remove(ignoreType);
        return this;
    }

    public Set<String> getIgnoredTypes() {
        return Collections.unmodifiableSet(this.ignoredTypes);
    }

    public Set<String> getIgnoredPrefixes() {
        return this.ignoredPrefixes;
    }

    public JsonLdContextOptions addIgnoredPrefix(String ignorePrefix) {
        this.ignoredPrefixes.add(ignorePrefix);
        return this;
    }

    public JsonLdContextOptions removeIgnoredPrefix(String ignorePrefix) {
        this.ignoredPrefixes.remove(ignorePrefix);
        return this;
    }

    JsonLdContextOptions copy() {
        JsonLdContextOptions copy = new JsonLdContextOptions();
        copy.idAlias = this.idAlias;
        copy.typeAlias = this.typeAlias;
        copy.boNameAlias = this.boNameAlias;
        copy.boTypeAlias = this.boTypeAlias;
        copy.langAlias = this.langAlias;
        copy.valueAlias = this.valueAlias;
        copy.useXsdString = this.useXsdString;
        copy.ignoredPrefixes = new LinkedHashSet<String>(this.ignoredPrefixes);
        copy.ignoredTypes = new LinkedHashSet<String>(this.ignoredTypes);
        return copy;
    }
}

