/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.iterators.master.entity;

import com.ontotext.trree.plugin.externalsync.api.DocumentsResult;
import com.ontotext.trree.plugin.externalsync.api.SnippetResult;
import com.ontotext.trree.plugin.externalsync.iterators.master.AbstractResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.NeedsMasterResult;
import com.ontotext.trree.plugin.externalsync.iterators.master.ObjectMayBeBound;
import com.ontotext.trree.plugin.externalsync.iterators.master.RegisteredIterator;
import com.ontotext.trree.sdk.Entities;
import java.util.Collection;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityResultIterator
extends AbstractResultIterator
implements NeedsMasterResult,
ObjectMayBeBound,
RegisteredIterator {
    private Logger LOGGER = LoggerFactory.getLogger(EntityResultIterator.class);
    private MasterResultIterator mri;
    private DocumentsResult docResult;

    @Override
    public void setMasterResultIterator(MasterResultIterator mri) {
        this.mri = mri;
        mri.setEntitySubjectFilter(this.object);
    }

    private boolean nextInternal() {
        if (this.docResult == null) {
            this.mri.state.doSearch();
            this.docResult = this.mri.state.getDocumentsResult();
        }
        return this.docResult.next();
    }

    public boolean next() {
        if (this.closed) {
            return false;
        }
        if (this.nextInternal()) {
            this.object = this.createIRIorBNodeId(this.docResult.getCurrentSubject());
            return true;
        }
        this.unregisterIterator();
        return false;
    }

    public final double getCurrentScore() {
        return this.docResult.getCurrentScore();
    }

    public final Collection<SnippetResult> getSnippetsForCurrentResult() {
        return this.docResult.getCurrentSnippets();
    }

    public final DocumentsResult getCurrentResult() {
        return this.docResult;
    }

    @Override
    public void unregisterIterator() {
        this.mri.unregisterIterator(this);
    }

    public void unregisterIterator(RegisteredIterator iterator) {
        this.mri.unregisterIterator(iterator);
    }

    private long createIRIorBNodeId(String iriOrBnode) {
        Object value = iriOrBnode.startsWith("_:") ? SimpleValueFactory.getInstance().createBNode(iriOrBnode.substring(2)) : SimpleValueFactory.getInstance().createIRI(iriOrBnode);
        return this.entities.put((Value)value, Entities.Scope.REQUEST);
    }
}

