/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.api;

import com.ontotext.trree.plugin.externalsync.filter.AbstractValueIterator;
import com.ontotext.trree.plugin.externalsync.filter.Expression;
import com.ontotext.trree.plugin.externalsync.filter.Operand;
import com.ontotext.trree.plugin.externalsync.filter.ValueIterator;
import com.ontotext.trree.plugin.externalsync.filter.ValueProvider;
import com.ontotext.trree.plugin.externalsync.impl.FieldName;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.Statements;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;

public class SyncDocument<T>
implements ValueProvider {
    private static final String LEVEL_SEPARATOR = "^";
    private static final TLongArrayList EMPTY_LONG_ARRAY = new TLongArrayList(0);
    private final long id;
    private final long contextId;
    protected SyncDocument<T> parentDocument;
    public final T nativeDocument;
    protected boolean nested;
    public final Set<Long> dependees;
    private final Map<String, TLongArrayList> values;
    private final Map<String, List<SyncDocument<T>>> nestedValues;
    private final Map<String, TLongArrayList> contexts;
    private final Map<String, TLongArrayList> predicateValues;
    private final Entities entities;
    private final Statements statements;
    private final Expression filterExpression;

    public SyncDocument(int size, long id, long contextId, T nativeDocument, boolean hasGraphInFilter, boolean hasPredicateTransform, Entities entities, Statements statements, Expression filterExpression, Set<Long> dependees) {
        this.id = id;
        this.contextId = contextId;
        this.nativeDocument = nativeDocument;
        this.statements = statements;
        this.entities = entities;
        this.filterExpression = filterExpression;
        this.dependees = dependees;
        this.values = new HashMap<String, TLongArrayList>(size);
        this.nestedValues = new HashMap<String, List<SyncDocument<T>>>(size);
        this.contexts = hasGraphInFilter ? new HashMap(size) : null;
        this.predicateValues = hasPredicateTransform ? new HashMap(size) : null;
    }

    public void addValue(FieldName fieldName, long predicate, long value, long context, int level) {
        if (fieldName.ignored) {
            return;
        }
        this.addValue(fieldName.fieldNameWithoutSuffix, predicate, value, context, level);
        if (fieldName.fieldNameSuffix != null) {
            this.addValue(fieldName.fieldNameWithSuffix, predicate, value, context, level);
        }
    }

    private void addValue(String field, long predicate, long value, long context, int level) {
        TLongArrayList list;
        assert (predicate != 0L) : "Predicate must not be zero";
        assert (value != 0L) : "Value must not be zero";
        assert (context != 0L) : "Context must not be zero";
        if (level > 0) {
            field = (String)field + LEVEL_SEPARATOR + level;
        }
        if ((list = this.values.get(field)) == null) {
            list = new TLongArrayList(2);
            this.values.put((String)field, list);
        }
        list.add(value);
        if (this.predicateValues != null) {
            TLongArrayList listPredicates = this.predicateValues.get(field);
            if (listPredicates == null) {
                listPredicates = new TLongArrayList(2);
                this.predicateValues.put((String)field, listPredicates);
            }
            listPredicates.add(predicate);
        }
        if (this.contexts != null) {
            TLongArrayList listContexts = this.contexts.get(field);
            if (listContexts == null) {
                listContexts = new TLongArrayList(2);
                this.contexts.put((String)field, listContexts);
            }
            listContexts.add(context);
        }
    }

    public SyncDocument<T> createdNested(int size, long id, long contextId, T nativeDocument, Expression documentFilterExpression) {
        SyncDocument<T> nestedDoc = new SyncDocument<T>(size, id, contextId, nativeDocument, this.contexts != null, this.predicateValues != null, this.entities, this.statements, documentFilterExpression, this.dependees);
        nestedDoc.parentDocument = this;
        nestedDoc.nested = true;
        return nestedDoc;
    }

    public void addNested(FieldName fieldName, SyncDocument<T> nestedDoc) {
        if (fieldName.ignored) {
            return;
        }
        this.addNested(fieldName.fieldNameWithoutSuffix, nestedDoc);
        if (fieldName.fieldNameSuffix != null) {
            this.addNested(fieldName.fieldNameWithSuffix, nestedDoc);
        }
    }

    private void addNested(String fieldName, SyncDocument<T> nestedDoc) {
        List docs = this.nestedValues.computeIfAbsent(fieldName, k -> new ArrayList(2));
        docs.add(nestedDoc);
    }

    public boolean passesDocumentFilter() {
        return this.filterExpression.evaluate(this);
    }

    public TLongArrayList getValues(String fieldName, boolean isContext) {
        TLongArrayList valueList;
        if (isContext) {
            if (this.contexts == null) {
                throw new IllegalStateException("Context value requested when contexts aren't tracked");
            }
            valueList = this.contexts.get(fieldName);
        } else {
            valueList = this.values.get(fieldName);
        }
        if (valueList == null) {
            return EMPTY_LONG_ARRAY;
        }
        return valueList;
    }

    public TLongArrayList getPredicateValues(String fieldName) {
        TLongArrayList valueList = this.predicateValues.get(fieldName);
        if (valueList == null) {
            return EMPTY_LONG_ARRAY;
        }
        return valueList;
    }

    private TLongArrayList getValuesWithNesting(String fieldName, boolean isContext) {
        int dotPos = fieldName.indexOf(46);
        if (dotPos > 0) {
            TLongArrayList result = new TLongArrayList();
            for (SyncDocument<T> nestedDoc : this.getNestedValues(fieldName.substring(0, dotPos))) {
                TLongArrayList nestedValues = nestedDoc.getValuesWithNesting(fieldName.substring(dotPos + 1), isContext);
                for (int i = 0; i < nestedValues.size(); ++i) {
                    result.add(nestedValues.getQuick(i));
                }
            }
            return result;
        }
        return this.getValues(fieldName, isContext);
    }

    public List<SyncDocument<T>> getNestedValues(String fieldName) {
        List<SyncDocument<T>> docs = this.nestedValues.get(fieldName);
        if (docs == null) {
            return Collections.emptyList();
        }
        return docs;
    }

    public boolean isNested() {
        return this.nested;
    }

    public String getFieldName(Property property, TLongArrayList values, int valueIndex) {
        return property.getFieldNameTransform().apply(property, this, values, valueIndex);
    }

    @Override
    public ValueIterator getOperandValues(final Operand operand) {
        return new AbstractValueIterator(operand, this, false){
            final TLongArrayList values;
            int index;
            {
                super(operand3, valueProvider, terminal);
                this.values = SyncDocument.this.getOperandValues(operand, operand.outerCount);
                this.index = -1;
            }

            @Override
            public boolean next() {
                if (this.index + 1 < this.values.size()) {
                    ++this.index;
                    long value = this.values.getQuick(this.index);
                    this.setNextValue(value, value);
                    return true;
                }
                return false;
            }
        };
    }

    private TLongArrayList getOperandValues(Operand operand, int outerLevel) {
        if (outerLevel > 0) {
            return this.parentDocument.getOperandValues(operand, outerLevel - 1);
        }
        String fname = operand.parentCount == 0 ? operand.fieldName : operand.fieldName + LEVEL_SEPARATOR + operand.parentCount;
        return this.getValuesWithNesting(fname, operand.isGraph && operand.nexthopId == 0L);
    }

    @Override
    public ValueIterator getValuesForNextHop(final long thisHopValue, final Operand operand) {
        return new AbstractValueIterator(operand, this, true){
            final StatementIterator sit;
            {
                super(operand3, valueProvider, terminal);
                this.sit = SyncDocument.this.statements.get(thisHopValue, operand.nexthopId, 0L);
            }

            @Override
            public boolean next() {
                boolean hasNext = this.sit.next();
                if (hasNext) {
                    this.setNextValue(this.sit.object, this.sit.context);
                }
                return hasNext;
            }

            @Override
            public void close() {
                this.sit.close();
            }
        };
    }

    @Override
    public Entities.Type getValueType(long value) {
        return this.entities.getType(value);
    }

    @Override
    public Value resolveIdToLanguage(long literalId) {
        return EntitiesUtil.literalToLanguage(this.entities, literalId);
    }

    @Override
    public long resolveValue(Value value) {
        return this.entities.resolve(value);
    }

    @Override
    public Value resolveId(long entityId) {
        return this.entities.get(entityId);
    }

    @Override
    public long getDocumentId() {
        return this.id;
    }

    @Override
    public long getDocumentContextId() {
        return this.contextId;
    }

    public SyncDocument<T> getNthParentDocument(long numberOfParents) {
        assert (numberOfParents >= 0L);
        if (numberOfParents == 0L) {
            return this;
        }
        if (numberOfParents == 1L) {
            return this.parentDocument;
        }
        return this.parentDocument.getNthParentDocument(numberOfParents - 1L);
    }
}

