/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class TransactionFingerprintTracker {
    private static final long MAGIC_PRIME = 103L;
    private long baseFingerprint;
    private long transactionFingerprint;
    private long lastTransactionCompletedFingerprint;
    private long lastCompletedTransaction;
    private File fingerprintFileDir;
    public static final String FINGERPRINT_FILENAME = "fingerprint";
    private static final int LONG_BYTE_SIZE = 8;

    public TransactionFingerprintTracker(long fingerprint, File fingerprintFileDir) {
        this.fingerprintFileDir = fingerprintFileDir;
        this.baseFingerprint = fingerprint;
        this.transactionFingerprint = 0L;
        this.lastTransactionCompletedFingerprint = 0L;
    }

    public void transactionStarted(long transaction) {
        this.lastCompletedTransaction = -1L;
        this.transactionFingerprint = 0L;
        this.lastTransactionCompletedFingerprint = 0L;
    }

    public void transactionCompleted(long transaction) throws IOException {
        assert (this.lastCompletedTransaction == -1L) : "transactionStarted() called before transactionCompleted()";
        this.lastCompletedTransaction = transaction;
        this.baseFingerprint = this.combine(this.baseFingerprint, this.transactionFingerprint);
        this.write();
        this.lastTransactionCompletedFingerprint = this.transactionFingerprint;
        this.transactionFingerprint = 0L;
    }

    public void transactionAborted(long transaction) throws IOException {
        if (this.lastCompletedTransaction == transaction) {
            this.rollbackCommitted();
        } else {
            assert (this.lastCompletedTransaction == -1L) : "transactionStarted() called before transactionAborted()";
            this.transactionFingerprint = 0L;
            this.lastTransactionCompletedFingerprint = 0L;
        }
    }

    public void rollbackCommitted() throws IOException {
        assert (this.lastCompletedTransaction >= 0L) : "rollbackCommitted() called before transactionCompleted()";
        this.baseFingerprint = this.combine(this.baseFingerprint, this.lastTransactionCompletedFingerprint);
        this.write();
        this.transactionFingerprint = 0L;
        this.lastTransactionCompletedFingerprint = 0L;
    }

    public void rollback() {
        this.transactionFingerprint = 0L;
        this.lastTransactionCompletedFingerprint = 0L;
    }

    public void updateEntity(long subject) {
        assert (this.lastCompletedTransaction == -1L) : "transactionStarted() called before updateEntity()";
        this.transactionFingerprint *= 103L;
        this.transactionFingerprint += subject;
    }

    private long combine(long base, long trans) {
        return base ^ trans;
    }

    public long getFingerprint() {
        return this.combine(this.baseFingerprint, this.transactionFingerprint);
    }

    public void write() throws IOException {
        this.write(new File(this.fingerprintFileDir, FINGERPRINT_FILENAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        try {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putLong(this.baseFingerprint);
            fos.write(bb.array());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionFingerprintTracker loadFromDir(File dir) throws IOException {
        FileInputStream fis = new FileInputStream(new File(dir, FINGERPRINT_FILENAME));
        try {
            ByteBuffer bb = ByteBuffer.allocate(8);
            int r = fis.read(bb.array());
            if (r != 8) {
                throw new IOException("Fingerprint file seems truncated");
            }
            TransactionFingerprintTracker transactionFingerprintTracker = new TransactionFingerprintTracker(bb.getLong(), dir);
            return transactionFingerprintTracker;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    public static TransactionFingerprintTracker initAndWrite(long initialFingerprint, File dir) throws IOException {
        TransactionFingerprintTracker ttt = new TransactionFingerprintTracker(initialFingerprint, dir);
        ttt.write();
        return ttt;
    }

    public static TransactionFingerprintTracker createOrLoadExisting(long initialFingerprint, File dataDir, String name) {
        try {
            File storeDir = new File(dataDir, name);
            if (!new File(storeDir, FINGERPRINT_FILENAME).exists()) {
                FileUtils.forceMkdir((File)storeDir);
                if (initialFingerprint == 0L) {
                    initialFingerprint = name.hashCode();
                }
                return TransactionFingerprintTracker.initAndWrite(initialFingerprint, storeDir);
            }
            return TransactionFingerprintTracker.loadFromDir(storeDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't load fingerprint tracker", e);
        }
    }
}

