/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class SearchOptions {
    private static final Pattern LIST_SEPARATOR_PATTERN = Pattern.compile("[\\s,]+");
    private static final String ORDER_BY_SCORE_SPECIAL = "score";
    public int offset;
    public int limit;
    public int snippetSize;
    public String snippetPre;
    public String snippetPost;
    public List<String> facets;
    public int facetLimit;
    public List<OrderPredicate> orderBy;
    public String extraOptions;
    private static final String REVERSE_ORDER_PREFIX = "-";

    public SearchOptions() {
        this(0, 0, 250, "<em>", "</em>", new ArrayList<String>(), Integer.MAX_VALUE, new ArrayList<OrderPredicate>());
    }

    private SearchOptions(int offset, int limit, int snippetSize, String snippetPre, String snippetPost, List<String> facets, int facetLimit, List<OrderPredicate> orderBy) {
        this.offset = offset;
        this.limit = limit;
        this.snippetSize = snippetSize;
        this.snippetPre = snippetPre;
        this.snippetPost = snippetPost;
        this.facets = facets;
        this.facetLimit = facetLimit;
        this.orderBy = orderBy;
    }

    public void setOffset(String strOffset) {
        this.offset = Integer.parseInt(strOffset);
        if (this.offset < 0) {
            throw new IllegalArgumentException("Offset must be non-negative, but is " + this.offset);
        }
    }

    public void setLimit(String strLimit) {
        this.limit = Integer.parseInt(strLimit);
        if (this.limit < 0) {
            throw new IllegalArgumentException("Limit must be non-negative, but is " + this.limit);
        }
    }

    public void setSnippetSize(String strSnippetSize) {
        this.snippetSize = Integer.parseInt(strSnippetSize);
        if (this.snippetSize < 0) {
            throw new IllegalArgumentException("Snippet size must be non-negative, but is " + this.snippetSize);
        }
    }

    public void setFacetFields(String strFacetFields) {
        this.facets = this.splitStringToList(strFacetFields);
    }

    public void setFacetLimit(String strFacetLimit) {
        this.facetLimit = Integer.parseInt(strFacetLimit);
        if (this.facetLimit < 0) {
            throw new IllegalArgumentException("Facet limit must be non-negative, but is " + this.limit);
        }
    }

    public void setOrderBy(String strOrderBy) {
        List<String> orderByStr = this.splitStringToList(strOrderBy);
        this.orderBy = new ArrayList<OrderPredicate>(orderByStr.size());
        for (String obs : orderByStr) {
            this.orderBy.add(new OrderPredicate(obs));
        }
    }

    public void setSnippetPre(String strSnippetPre) {
        this.snippetPre = strSnippetPre;
    }

    public void setSnippetPost(String strSnippetPost) {
        this.snippetPost = strSnippetPost;
    }

    public void setExtraOptions(String strExtraOptions) {
        this.extraOptions = strExtraOptions;
    }

    private List<String> splitStringToList(String str) {
        String[] values = LIST_SEPARATOR_PATTERN.split(str);
        ArrayList<String> result = new ArrayList<String>(values.length);
        Collections.addAll(result, values);
        return result;
    }

    public static final class OrderPredicate {
        public final String predicate;
        public final boolean reverse;

        public OrderPredicate(String pred) {
            if (pred.startsWith(SearchOptions.REVERSE_ORDER_PREFIX)) {
                this.predicate = pred.substring(SearchOptions.REVERSE_ORDER_PREFIX.length());
                this.reverse = true;
            } else {
                this.predicate = pred;
                this.reverse = false;
            }
        }

        public boolean isScoreSpecial() {
            return SearchOptions.ORDER_BY_SCORE_SPECIAL.equals(this.predicate);
        }
    }
}

