/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.entitychange;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.api.ConnectorException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.ExternalStoreStatus;
import com.ontotext.trree.plugin.externalsync.api.SyncDocument;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.AbstractExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangePersistence;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangePlugin;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangeRetrieve;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.Statements;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

public class EntityChangeStore
extends AbstractExternalStore<Map<String, Object>> {
    static final String GEO_POINT_TYPE = "geo_point";
    static final String GEO_POINT_LAT = "lat";
    static final String GEO_POINT_LON = "lon";
    private EntityChangePersistence persistence;
    private boolean indexPreviousData;

    private EntityChangeStore(String storeName, Options storeOptions, boolean wasJustCreated, long initialFingerprint, EntityChangePlugin entityChangePlugin, PluginConnection pluginConnection, Entities entities) {
        super(storeName, storeOptions, wasJustCreated, initialFingerprint, (ExternalSyncPlugin)entityChangePlugin, pluginConnection, entities);
        Boolean indexPrevious = (Boolean)this.options.getValue(EntityChangePlugin.INDEX_PREVIOUS_DATA);
        assert (indexPrevious != null);
        this.indexPreviousData = indexPrevious;
    }

    static ExternalStore open(String storeName, Options storeOptions, EntityChangePlugin entityChangePlugin, PluginConnection pluginConnection) {
        return new EntityChangeStore(storeName, storeOptions, false, 0L, entityChangePlugin, pluginConnection, pluginConnection.getEntities());
    }

    public static ExternalStore create(String storeName, Options options, EntityChangePlugin entityChangePlugin, PluginConnection pluginConnection, Entities entitiesForCreation) {
        EntityChangeStore entityChangeStore = new EntityChangeStore(storeName, options, true, 0L, entityChangePlugin, pluginConnection, entitiesForCreation);
        entityChangeStore.createIndex(true);
        return entityChangeStore;
    }

    protected void createIndex(boolean cleanupAfterFailure) {
        try {
            this.init();
            this.persistence.createStore();
        }
        catch (Exception e) {
            if (cleanupAfterFailure) {
                try {
                    this.remove(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (e instanceof ConnectorException) {
                throw e;
            }
            throw new ConnectorServerException("Unable to create connector: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void deleteEntity(long subject, Value subjectValue) {
        this.persistence.delete(subjectValue);
    }

    protected Map<String, Object> newNativeDocument() {
        return null;
    }

    protected boolean syncEntity(long subject, long predicate, long context, SyncDocument<Map<String, Object>> syncDoc, List<Property> propertiesToSync, Entities entities, Statements statements, boolean skip) {
        ExternalStoreStatus status = this.getStatus();
        if (this.wasJustCreated && !status.repair && status.status == ExternalStoreStatus.Status.BUILDING && !this.indexPreviousData) {
            return false;
        }
        boolean anyProperty = this.syncEntityToDocument(syncDoc, subject, predicate, context, propertiesToSync, entities, statements);
        if (anyProperty) {
            if (!skip) {
                this.persistence.index(entities.get(subject), this.wasJustCreated);
            }
            return true;
        }
        return false;
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        super.transactionStarted(pluginConnection);
        if (this.isTestingTransaction() && this.persistence != null) {
            this.persistence.transactionStarted();
        }
    }

    protected boolean writePropertyValueToNativeDocument(Map<String, Object> doc, Property property, String fieldName, Value value) {
        throw new UnsupportedOperationException();
    }

    protected boolean isValidFieldNameImplementation(String fieldName, boolean isTopField) {
        return !isTopField || !"id".equals(fieldName);
    }

    public void drop(boolean force) throws Exception {
        block6: {
            block5: {
                try {
                    this.init();
                }
                catch (Exception e) {
                    if (force) break block5;
                    throw e;
                }
            }
            if (this.persistence != null) {
                try {
                    this.persistence.dropStore();
                }
                catch (Exception e) {
                    if (force) break block6;
                    throw e;
                }
            }
        }
        super.drop(force);
    }

    public ExternalRetrieve createRetrieve(MasterResultIterator mri, ExternalSyncRequestContext requestContext) {
        this.init();
        return new EntityChangeRetrieve(this.logger, this, mri, requestContext, this.persistence);
    }

    public void rollbackCurrent(PluginConnection pluginConnection) throws IOException {
        super.rollbackCurrent(pluginConnection);
        if (this.initialised.get()) {
            this.persistence.rollback();
        }
    }

    public void rollbackLastCommitted(PluginConnection pluginConnection) throws IOException {
        super.rollbackLastCommitted(pluginConnection);
        if (this.initialised.get()) {
            this.persistence.rollbackCommitted();
        }
    }

    public boolean transactionCompleted(PluginConnection pluginConnection) {
        if (this.initialised.get()) {
            this.persistence.commit();
        }
        return super.transactionCompleted(pluginConnection);
    }

    @Nonnull
    public List<String> getSyncedFields() {
        return Collections.emptyList();
    }

    protected void closeNetworkResources() {
        try {
            if (this.persistence != null) {
                this.persistence.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[{}] Error closing EC connector persistence.", (Object)this.name, (Object)e);
        }
    }

    protected String getNativeTypeFromDatatype(IRI datatype, boolean multivalued) {
        return "object";
    }

    public void removeAllEntities() {
        this.init();
        this.persistence.deleteAll();
        super.removeAllEntities();
    }

    protected void validateProperties() {
        Boolean[] result = new Boolean[]{false, false};
        this.checkDotsAndNestedProperties(null, this.getProperties(), result);
        if (result[0].booleanValue() && result[1].booleanValue()) {
            throw new ClientErrorException("Field names with dots and nested objects may not be used together.");
        }
    }

    protected void initImpl() {
        this.persistence = EntityChangePersistence.from(this.logger, this.name);
        this.persistence.initialize((ExternalStore)this, this.plugin);
        if (this.wasJustCreated()) {
            this.persistence.transactionStarted();
        }
    }

    private void checkDotsAndNestedProperties(@Nullable Property parent, List<Property> properties, Boolean[] result) {
        for (Property p : properties) {
            boolean hasNested = !p.getObject().isEmpty();
            Boolean[] booleanArray = result;
            Boolean.valueOf(booleanArray[0] | p.getFieldNameWithSuffix().contains("."));
            booleanArray = result;
            Boolean.valueOf(booleanArray[1] | hasNested);
            if (hasNested) {
                String type = p.getNativeType();
                if (!(type == null || type.equals("nested") || type.equals(GEO_POINT_TYPE) || type.equals("object"))) {
                    throw new ClientErrorException("Fields with nested objects must be defined with datatype = object, datatype = nested or datatype = geo_point (object is the default).");
                }
                if (GEO_POINT_TYPE.equals(type)) {
                    List nestedFields = p.getObject();
                    if (!nestedFields.isEmpty() && nestedFields.size() != 2) {
                        throw new ClientErrorException("Fields of type geo_point must have exactly two object fields named 'lat' and 'lon'.");
                    }
                    if (nestedFields.size() == 2) {
                        Property of1 = (Property)nestedFields.get(0);
                        Property of2 = (Property)nestedFields.get(1);
                        if (!of1.getFieldNameWithoutSuffix().equals(GEO_POINT_LAT) || !of2.getFieldNameWithoutSuffix().equals(GEO_POINT_LON)) {
                            throw new ClientErrorException("Fields of type geo_point must have exactly two object fields named 'lat' and 'lon'.");
                        }
                    }
                }
            }
            String fieldName = p.getFieldNameWithoutSuffix();
            if (parent != null && !this.isValidFieldName(fieldName, false)) {
                throw new ClientErrorException(String.format("Nested field name '%s' with parent '%s' may not be used.", fieldName, parent.getFieldNameWithoutSuffix()));
            }
            this.checkDotsAndNestedProperties(p, p.getObject(), result);
        }
    }

    public HealthResult runHealthCheckInternal() {
        return this.persistence.runHealthCheck();
    }

    protected void applyUpdatedOptions() {
    }
}

