/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.entitychange;

import java.util.Date;
import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;

public class EntityChangeInternalStore {
    private static final IRI INDEX_TYPE = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/Index");
    private static final IRI CREATED = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/created");
    private static final IRI TX_COUNTER = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/txCounter");
    private static final Literal INITIAL_TX = SimpleValueFactory.getInstance().createLiteral(0L);
    private Repository repository;
    private ValueFactory valueFactory;

    public EntityChangeInternalStore(Repository repository) {
        this.repository = Objects.requireNonNull(repository, "Repository is required");
        this.valueFactory = repository.getValueFactory();
    }

    void registerStore(String storeName) {
        IRI context = this.createContext(storeName);
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.begin();
            connection.add((Resource)context, RDF.TYPE, (Value)INDEX_TYPE, new Resource[0]);
            connection.add((Resource)context, CREATED, (Value)this.getNow(), new Resource[0]);
            connection.add((Resource)context, TX_COUNTER, (Value)INITIAL_TX, new Resource[0]);
            connection.commit();
        }
    }

    private Literal getNow() {
        return this.valueFactory.createLiteral(new Date());
    }

    public void dropStore(String storeName) {
        IRI context = this.createContext(storeName);
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.begin();
            connection.remove((Resource)context, null, null, new Resource[0]);
            connection.clear(new Resource[]{context});
            connection.commit();
        }
    }

    public boolean isInitialized() {
        return this.repository.isInitialized();
    }

    public void reInitialize() {
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized!");
        }
        this.repository.init();
    }

    public void deleteAll(String storeName) {
        IRI context = this.createContext(storeName);
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.begin();
            connection.clear(new Resource[]{context});
            connection.remove((Resource)context, TX_COUNTER, null, new Resource[0]);
            connection.add((Resource)context, TX_COUNTER, (Value)INITIAL_TX, new Resource[0]);
            connection.commit();
        }
    }

    private IRI createContext(String storeName) {
        return this.valueFactory.createIRI("http://www.ontotext.com/connectors/entity-change/" + storeName);
    }

    public RepositoryConnection getConnection() {
        return this.repository.getConnection();
    }

    public void close() {
    }

    public void shutDown() {
        try {
            this.close();
        }
        finally {
            this.repository.shutDown();
        }
    }

    ValueFactory getValueFactory() {
        return this.repository.getValueFactory();
    }

    DataWriter getDataWriter(String storeName, boolean writeChanges) {
        if (!writeChanges) {
            return DataWriter.NO_OP;
        }
        IRI context = this.createContext(storeName);
        return new DataWriterImpl(this.repository.getConnection(), context);
    }

    static interface DataWriter
    extends AutoCloseable {
        public static final DataWriter NO_OP = new DataWriter(){};

        default public void add(Statement statement) {
        }

        default public void remove(Statement statement) {
        }

        @Override
        default public void close() {
        }

        default public long getCurrentTx() {
            return -1L;
        }

        default public long incrementTx() {
            return -1L;
        }

        default public long decrementTx() {
            return -1L;
        }
    }

    private static class DataWriterImpl
    implements DataWriter {
        private final RepositoryConnection connection;
        private final IRI context;

        DataWriterImpl(RepositoryConnection connection, IRI context) {
            this.connection = connection;
            this.context = context;
            connection.begin();
        }

        @Override
        public void add(Statement statement) {
            this.connection.add(statement, new Resource[]{this.context});
        }

        @Override
        public void remove(Statement statement) {
            this.connection.remove(statement, new Resource[]{this.context});
        }

        @Override
        public void close() {
            try (RepositoryConnection repositoryConnection = this.connection;){
                repositoryConnection.commit();
            }
        }

        @Override
        public long getCurrentTx() {
            try (RepositoryResult statements = this.connection.getStatements((Resource)this.context, TX_COUNTER, null, new Resource[0]);){
                long l = statements.stream().map(Statement::getObject).map(Literal.class::cast).mapToLong(Literal::longValue).findFirst().orElse(0L);
                return l;
            }
        }

        @Override
        public long incrementTx() {
            long txId = this.getCurrentTx();
            this.connection.remove((Resource)this.context, TX_COUNTER, (Value)this.connection.getValueFactory().createLiteral(txId), new Resource[0]);
            this.connection.add((Resource)this.context, TX_COUNTER, (Value)this.connection.getValueFactory().createLiteral(txId + 1L), new Resource[0]);
            return txId + 1L;
        }

        @Override
        public long decrementTx() {
            long txId = this.getCurrentTx();
            ValueFactory valueFactory = this.connection.getValueFactory();
            this.connection.remove((Resource)this.context, TX_COUNTER, (Value)valueFactory.createLiteral(txId), new Resource[0]);
            this.connection.add((Resource)this.context, TX_COUNTER, (Value)valueFactory.createLiteral(txId - 1L), new Resource[0]);
            return txId - 1L;
        }
    }
}

