/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllSettings;
import it.unibz.inf.ontop.injection.OntopMappingSQLSettings;
import it.unibz.inf.ontop.injection.impl.FactsSupplier;
import it.unibz.inf.ontop.injection.impl.OntologySupplier;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLAllSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLConfigurationImpl;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.Graph;

public class OntopMappingSQLAllConfigurationImpl
extends OntopMappingSQLConfigurationImpl
implements OntopMappingSQLAllConfiguration {
    private final OntopMappingSQLAllSettings settings;
    private final OntopMappingSQLAllOptions options;

    OntopMappingSQLAllConfigurationImpl(OntopMappingSQLAllSettings settings, OntopMappingSQLAllOptions options) {
        super((OntopMappingSQLSettings)settings, options.mappingSQLOptions);
        this.settings = settings;
        this.options = options;
    }

    OntopMappingSQLAllConfigurationImpl(OntopMappingSQLAllSettings settings, OntopMappingSQLAllOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopMappingSQLSettings)settings, options.mappingSQLOptions, injectorSupplier);
        this.settings = settings;
        this.options = options;
    }

    @Override
    public OntopMappingSQLAllSettings getSettings() {
        return this.settings;
    }

    protected OBDASpecification loadOBDASpecification() throws OBDASpecificationException {
        return this.loadSpecification(Optional::empty, Optional::empty);
    }

    OBDASpecification loadSpecification(OntologySupplier ontologySupplier, FactsSupplier factsSupplier) throws OBDASpecificationException {
        return this.loadSpecification(ontologySupplier, factsSupplier, () -> this.options.mappingFile, () -> this.options.mappingReader, () -> this.options.mappingGraph, () -> this.options.constraintFile, () -> this.options.dbMetadataFile, () -> this.options.dbMetadataReader, () -> this.options.lensesFile, () -> this.options.lensesReader);
    }

    public Optional<SQLPPMapping> loadPPMapping() throws MappingIOException, InvalidMappingException {
        return this.loadPPMapping(() -> this.options.mappingFile, () -> this.options.mappingReader, () -> this.options.mappingGraph);
    }

    boolean isInputMappingDefined() {
        return super.isInputMappingDefined() || this.options.mappingFile.isPresent() || this.options.mappingGraph.isPresent() || this.options.mappingReader.isPresent();
    }

    public static class BuilderImpl
    extends OntopMappingSQLAllBuilderMixin<BuilderImpl> {
        @Override
        public OntopMappingSQLAllConfiguration build() {
            OntopMappingSQLAllSettingsImpl settings = new OntopMappingSQLAllSettingsImpl(this.generateProperties(), this.isR2rml());
            OntopMappingSQLAllOptions options = this.generateMappingSQLAllOptions();
            return new OntopMappingSQLAllConfigurationImpl(settings, options);
        }

        protected BuilderImpl self() {
            return this;
        }
    }

    protected static abstract class OntopMappingSQLAllBuilderMixin<B extends OntopMappingSQLAllConfiguration.Builder<B>>
    extends OntopMappingSQLConfigurationImpl.OntopMappingSQLBuilderMixin<B>
    implements OntopMappingSQLAllConfiguration.Builder<B> {
        private final StandardMappingSQLAllBuilderFragment<B> localFragmentBuilder = new StandardMappingSQLAllBuilderFragment<B>(){

            @Override
            protected B self() {
                return (OntopMappingSQLAllConfiguration.Builder)this.self();
            }

            @Override
            protected void declareMappingDefined() {
                this.declareMappingDefined();
            }

            @Override
            protected void declareImplicitConstraintSetDefined() {
                this.declareImplicitConstraintSetDefined();
            }

            @Override
            protected void declareDBMetadataDefined() {
                this.declareDBMetadataDefined();
            }

            @Override
            protected void declareLensesDefined() {
                this.declareLensesDefined();
            }
        };
        private boolean isImplicitConstraintSetDefined = false;

        OntopMappingSQLAllBuilderMixin() {
        }

        @Override
        public B nativeOntopMappingFile(@Nonnull File mappingFile) {
            return this.localFragmentBuilder.nativeOntopMappingFile(mappingFile);
        }

        @Override
        public B nativeOntopMappingFile(@Nonnull String mappingFilename) {
            return this.localFragmentBuilder.nativeOntopMappingFile(mappingFilename);
        }

        @Override
        public B nativeOntopMappingReader(@Nonnull Reader mappingReader) {
            return this.localFragmentBuilder.nativeOntopMappingReader(mappingReader);
        }

        @Override
        public B r2rmlMappingFile(@Nonnull File mappingFile) {
            return this.localFragmentBuilder.r2rmlMappingFile(mappingFile);
        }

        @Override
        public B r2rmlMappingFile(@Nonnull String mappingFilename) {
            return this.localFragmentBuilder.r2rmlMappingFile(mappingFilename);
        }

        @Override
        public B r2rmlMappingReader(@Nonnull Reader mappingReader) {
            return this.localFragmentBuilder.r2rmlMappingReader(mappingReader);
        }

        @Override
        public B r2rmlMappingGraph(@Nonnull Graph rdfGraph) {
            return this.localFragmentBuilder.r2rmlMappingGraph(rdfGraph);
        }

        @Override
        public B basicImplicitConstraintFile(@Nonnull File constraintFile) {
            return this.localFragmentBuilder.basicImplicitConstraintFile(constraintFile);
        }

        @Override
        public B basicImplicitConstraintFile(@Nonnull String constraintFilename) {
            return this.localFragmentBuilder.basicImplicitConstraintFile(constraintFilename);
        }

        @Override
        public B dbMetadataFile(@Nonnull File dbmetadataFile) {
            return this.localFragmentBuilder.dbMetadataFile(dbmetadataFile);
        }

        @Override
        public B dbMetadataFile(@Nonnull String dbmetadataFilename) {
            return this.localFragmentBuilder.dbMetadataFile(dbmetadataFilename);
        }

        @Override
        public B dbMetadataReader(@Nonnull Reader dbMetadataReader) {
            return this.localFragmentBuilder.dbMetadataReader(dbMetadataReader);
        }

        @Override
        public B lensesFile(@Nonnull File ontopViewFile) {
            return this.localFragmentBuilder.lensesFile(ontopViewFile);
        }

        @Override
        public B lensesFile(@Nonnull String lensesFilename) {
            return this.localFragmentBuilder.lensesFile(lensesFilename);
        }

        @Override
        public B lensesReader(@Nonnull Reader lensesReader) {
            return this.localFragmentBuilder.lensesReader(lensesReader);
        }

        protected final OntopMappingSQLAllOptions generateMappingSQLAllOptions() {
            OntopMappingSQLConfigurationImpl.OntopMappingSQLOptions sqlMappingOptions = this.generateMappingSQLOptions();
            return this.localFragmentBuilder.generateMappingSQLAllOptions(sqlMappingOptions);
        }

        protected Properties generateProperties() {
            Properties p = super.generateProperties();
            p.putAll((Map<?, ?>)this.localFragmentBuilder.generateProperties());
            return p;
        }

        protected final boolean isR2rml() {
            return this.localFragmentBuilder.isR2rml();
        }

        protected final void declareImplicitConstraintSetDefined() {
            if (this.isImplicitConstraintSetDefined) {
                throw new InvalidOntopConfigurationException("The implicit constraint file is already defined");
            }
            this.isImplicitConstraintSetDefined = true;
        }
    }

    static abstract class StandardMappingSQLAllBuilderFragment<B extends OntopMappingSQLAllConfiguration.Builder<B>>
    implements OntopMappingSQLAllConfiguration.OntopMappingSQLAllBuilderFragment<B> {
        private Optional<File> mappingFile = Optional.empty();
        private Optional<Reader> mappingReader = Optional.empty();
        private Optional<Graph> mappingGraph = Optional.empty();
        private Optional<File> constraintFile = Optional.empty();
        private Optional<File> dbMetadataFile = Optional.empty();
        private Optional<Reader> dbMetadataReader = Optional.empty();
        private Optional<File> lensesFile = Optional.empty();
        private Optional<Reader> lensesReader = Optional.empty();
        private boolean useR2rml = false;

        StandardMappingSQLAllBuilderFragment() {
        }

        protected abstract B self();

        protected abstract void declareMappingDefined();

        protected abstract void declareImplicitConstraintSetDefined();

        protected abstract void declareDBMetadataDefined();

        protected abstract void declareLensesDefined();

        @Override
        public B nativeOntopMappingFile(@Nonnull File mappingFile) {
            this.declareMappingDefined();
            this.mappingFile = Optional.of(mappingFile);
            return this.self();
        }

        @Override
        public B nativeOntopMappingFile(@Nonnull String mappingFilename) {
            this.setMappingFile(mappingFilename);
            return this.self();
        }

        @Override
        public B nativeOntopMappingReader(@Nonnull Reader mappingReader) {
            this.declareMappingDefined();
            this.mappingReader = Optional.of(mappingReader);
            return this.self();
        }

        @Override
        public B r2rmlMappingFile(@Nonnull File mappingFile) {
            this.declareMappingDefined();
            this.useR2rml = true;
            this.mappingFile = Optional.of(mappingFile);
            return this.self();
        }

        @Override
        public B r2rmlMappingFile(@Nonnull String mappingFilename) {
            this.declareMappingDefined();
            this.useR2rml = true;
            try {
                URI fileURI = new URI(mappingFilename);
                String scheme = fileURI.getScheme();
                if (scheme == null) {
                    this.mappingFile = Optional.of(new File(fileURI.getPath()));
                } else if (scheme.equals("file")) {
                    this.mappingFile = Optional.of(new File(fileURI));
                } else {
                    throw new InvalidOntopConfigurationException("Currently only local files are supportedas R2RML mapping files");
                }
                return this.self();
            }
            catch (URISyntaxException e) {
                throw new InvalidOntopConfigurationException("Invalid mapping file path: " + e.getMessage());
            }
        }

        @Override
        public B r2rmlMappingReader(@Nonnull Reader mappingReader) {
            this.declareMappingDefined();
            this.useR2rml = true;
            this.mappingReader = Optional.of(mappingReader);
            return this.self();
        }

        @Override
        public B r2rmlMappingGraph(@Nonnull Graph rdfGraph) {
            this.declareMappingDefined();
            this.useR2rml = true;
            this.mappingGraph = Optional.of(rdfGraph);
            return this.self();
        }

        @Override
        public B basicImplicitConstraintFile(@Nonnull File constraintFile) {
            this.declareImplicitConstraintSetDefined();
            this.constraintFile = Optional.of(constraintFile);
            return this.self();
        }

        @Override
        public B basicImplicitConstraintFile(@Nonnull String constraintFilename) {
            this.declareImplicitConstraintSetDefined();
            try {
                URI fileURI = new URI(constraintFilename);
                String scheme = fileURI.getScheme();
                if (scheme == null) {
                    this.constraintFile = Optional.of(new File(fileURI.getPath()));
                } else if (scheme.equals("file")) {
                    this.constraintFile = Optional.of(new File(fileURI));
                } else {
                    throw new InvalidOntopConfigurationException("Currently only local files are supportedas implicit constraint files");
                }
                return this.self();
            }
            catch (URISyntaxException e) {
                throw new InvalidOntopConfigurationException("Invalid implicit constraint file path: " + e.getMessage());
            }
        }

        @Override
        public B dbMetadataFile(@Nonnull File dbMetadataFile) {
            this.declareDBMetadataDefined();
            this.dbMetadataFile = Optional.of(dbMetadataFile);
            return this.self();
        }

        @Override
        public B dbMetadataFile(@Nonnull String dbMetadataFilename) {
            this.declareDBMetadataDefined();
            try {
                URI fileURI = new URI(dbMetadataFilename);
                String scheme = fileURI.getScheme();
                if (scheme == null) {
                    this.dbMetadataFile = Optional.of(new File(fileURI.getPath()));
                } else if (scheme.equals("file")) {
                    this.dbMetadataFile = Optional.of(new File(fileURI));
                } else {
                    throw new InvalidOntopConfigurationException("Currently only local files are supportedas db-metadata files");
                }
                return this.self();
            }
            catch (URISyntaxException e) {
                throw new InvalidOntopConfigurationException("Invalid db-metadata file path: " + e.getMessage());
            }
        }

        @Override
        public B dbMetadataReader(@Nonnull Reader dbMetadataReader) {
            this.declareDBMetadataDefined();
            this.dbMetadataReader = Optional.of(dbMetadataReader);
            return this.self();
        }

        @Override
        public B lensesFile(@Nonnull File lensesFile) {
            this.declareLensesDefined();
            this.lensesFile = Optional.of(lensesFile);
            return this.self();
        }

        @Override
        public B lensesFile(@Nonnull String lensesFilename) {
            this.declareLensesDefined();
            try {
                URI fileURI = new URI(lensesFilename);
                String scheme = fileURI.getScheme();
                if (scheme == null) {
                    this.lensesFile = Optional.of(new File(fileURI.getPath()));
                } else if (scheme.equals("file")) {
                    this.lensesFile = Optional.of(new File(fileURI));
                } else {
                    throw new InvalidOntopConfigurationException("Currently only local files are supportedas lerses files");
                }
                return this.self();
            }
            catch (URISyntaxException e) {
                throw new InvalidOntopConfigurationException("Invalid lenses file path: " + e.getMessage());
            }
        }

        @Override
        public B lensesReader(@Nonnull Reader lensesReader) {
            this.declareLensesDefined();
            this.lensesReader = Optional.of(lensesReader);
            return this.self();
        }

        protected Properties generateProperties() {
            Properties p = new Properties();
            return p;
        }

        boolean isR2rml() {
            return this.useR2rml;
        }

        protected final void setMappingFile(String mappingFilename) {
            block4: {
                this.declareMappingDefined();
                try {
                    URI fileURI = new URI(mappingFilename);
                    String scheme = fileURI.getScheme();
                    if (scheme == null) {
                        this.mappingFile = Optional.of(new File(fileURI.getPath()));
                        break block4;
                    }
                    if (scheme.equals("file")) {
                        this.mappingFile = Optional.of(new File(fileURI));
                        break block4;
                    }
                    throw new InvalidOntopConfigurationException("Currently only local files are supportedas mapping files");
                }
                catch (URISyntaxException e) {
                    throw new InvalidOntopConfigurationException("Invalid mapping file path: " + e.getMessage());
                }
            }
        }

        final OntopMappingSQLAllOptions generateMappingSQLAllOptions(OntopMappingSQLConfigurationImpl.OntopMappingSQLOptions mappingOptions) {
            return new OntopMappingSQLAllOptions(this.mappingFile, this.mappingReader, this.mappingGraph, this.constraintFile, this.dbMetadataFile, this.dbMetadataReader, this.lensesFile, this.lensesReader, mappingOptions);
        }
    }

    static class OntopMappingSQLAllOptions {
        private final Optional<File> mappingFile;
        private final Optional<Reader> mappingReader;
        private final Optional<Graph> mappingGraph;
        private final Optional<File> constraintFile;
        private final Optional<File> dbMetadataFile;
        private final Optional<Reader> dbMetadataReader;
        private final Optional<File> lensesFile;
        private final Optional<Reader> lensesReader;
        final OntopMappingSQLConfigurationImpl.OntopMappingSQLOptions mappingSQLOptions;

        OntopMappingSQLAllOptions(Optional<File> mappingFile, Optional<Reader> mappingReader, Optional<Graph> mappingGraph, Optional<File> constraintFile, Optional<File> dbMetadataFile, Optional<Reader> dbMetadataReader, Optional<File> lensesFile, Optional<Reader> lensesReader, OntopMappingSQLConfigurationImpl.OntopMappingSQLOptions mappingSQLOptions) {
            this.mappingFile = mappingFile;
            this.mappingReader = mappingReader;
            this.mappingGraph = mappingGraph;
            this.constraintFile = constraintFile;
            this.dbMetadataFile = dbMetadataFile;
            this.dbMetadataReader = dbMetadataReader;
            this.lensesFile = lensesFile;
            this.lensesReader = lensesReader;
            this.mappingSQLOptions = mappingSQLOptions;
        }
    }
}

