/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.filter;

import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.filter.AbstractValueIterator;
import com.ontotext.trree.plugin.externalsync.filter.ConnectorFilterExpressionVisitor;
import com.ontotext.trree.plugin.externalsync.filter.ConnectorFilterLexer;
import com.ontotext.trree.plugin.externalsync.filter.ConnectorFilterParser;
import com.ontotext.trree.plugin.externalsync.filter.ConstantOperand;
import com.ontotext.trree.plugin.externalsync.filter.Expression;
import com.ontotext.trree.plugin.externalsync.filter.FilterErrorListener;
import com.ontotext.trree.plugin.externalsync.filter.FilterType;
import com.ontotext.trree.plugin.externalsync.filter.Operand;
import com.ontotext.trree.plugin.externalsync.filter.ParsedFilter;
import com.ontotext.trree.plugin.externalsync.filter.ValueIterator;
import com.ontotext.trree.plugin.externalsync.filter.ValueProvider;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.TypeAndPropertyKeeper;
import com.ontotext.trree.sdk.Entities;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.rdf4j.model.Value;

public class FilterUtil {
    public static ParsedFilter parseFilter(String filter, Entities entities, TypeAndPropertyKeeper typeAndPropertyKeeper, FilterType filterType) {
        return FilterUtil.parseFilter(filter, entities, typeAndPropertyKeeper, filterType, null);
    }

    public static ParsedFilter parseFilter(String filter, Entities entities, TypeAndPropertyKeeper typeAndPropertyKeeper, FilterType filterType, Property contextProperty) {
        if (filterType == FilterType.VALUE && contextProperty != null) {
            throw new IllegalArgumentException("Top-level value filter must not use context");
        }
        if (filterType == FilterType.PER_FIELD_VALUE && contextProperty == null) {
            throw new IllegalArgumentException("Per-field value filter must use context");
        }
        if (filterType == FilterType.DOCUMENT && contextProperty != null) {
            throw new IllegalArgumentException("Top-level document filter must not use context");
        }
        if (filterType == FilterType.NESTED_DOCUMENT && contextProperty == null) {
            throw new IllegalArgumentException("Nested document filter must use context");
        }
        CodePointCharStream input = CharStreams.fromString((String)filter);
        FilterErrorListener errorListener = FilterErrorListener.getFreshInstance();
        ConnectorFilterLexer lexer = new ConnectorFilterLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ConnectorFilterParser parser = new ConnectorFilterParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        ConnectorFilterParser.EntryContext entry = parser.entry();
        if (parser.getNumberOfSyntaxErrors() > 0) {
            throw new ConnectorUserException(errorListener.getErrorMessage());
        }
        ConnectorFilterExpressionVisitor cfev = new ConnectorFilterExpressionVisitor(contextProperty, entities, typeAndPropertyKeeper, filterType);
        return new ParsedFilter((Expression)cfev.visit((ParseTree)entry.expression()), cfev.getOperands(), cfev.getFilterDependencies(), cfev.needsToCollectGraph());
    }

    public static ValueIterator getOperandValues(Operand operand, ValueProvider valueProvider) {
        if (operand instanceof ConstantOperand) {
            return FilterUtil.constantOperandIterator((ConstantOperand)operand, valueProvider);
        }
        if (operand.isThis) {
            return FilterUtil.getOperandValuesSingleValue(operand, valueProvider, valueProvider.getDocumentId(), valueProvider.getDocumentContextId());
        }
        ValueIterator iterator = valueProvider.getOperandValues(operand);
        if (operand.nexthopId != 0L) {
            iterator = FilterUtil.nextHopValueIterator(iterator, operand, valueProvider);
        }
        return iterator;
    }

    public static ValueIterator getOperandValuesSingleValue(Operand operand, ValueProvider valueProvider, final long value, final long context) {
        ValueIterator iterator = new AbstractValueIterator(operand, valueProvider, false){
            boolean hasNexted;
            {
                super(operand, valueProvider, terminal);
                this.setNextValue(value, context);
            }

            @Override
            public boolean next() {
                if (!this.hasNexted) {
                    this.hasNexted = true;
                    return true;
                }
                return false;
            }
        };
        if (operand.nexthopId != 0L) {
            iterator = FilterUtil.nextHopValueIterator(iterator, operand, valueProvider);
        }
        return iterator;
    }

    private static ValueIterator constantOperandIterator(final ConstantOperand operand, final ValueProvider valueProvider) {
        return new ValueIterator(){
            boolean hasNexted;

            @Override
            public boolean next() {
                if (!this.hasNexted) {
                    this.hasNexted = true;
                    return true;
                }
                return false;
            }

            @Override
            public long id() {
                return valueProvider.resolveValue(operand.value);
            }

            @Override
            public Value value() {
                return operand.value;
            }
        };
    }

    private static ValueIterator nextHopValueIterator(final ValueIterator thisHopIterator, final Operand operand, final ValueProvider valueProvider) {
        return new ValueIterator(){
            ValueIterator nhvit;

            @Override
            public boolean next() {
                if (this.nhvit != null && this.nhvit.next()) {
                    return true;
                }
                while (thisHopIterator.next()) {
                    if (this.nhvit != null) {
                        this.nhvit.close();
                    }
                    this.nhvit = valueProvider.getValuesForNextHop(thisHopIterator.id(), operand);
                    if (!this.nhvit.next()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public long id() {
                return this.nhvit.id();
            }

            @Override
            public Value value() {
                return this.nhvit.value();
            }

            @Override
            public void close() {
                if (this.nhvit != null) {
                    this.nhvit.close();
                }
            }
        };
    }
}

