/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import com.google.inject.Injector;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.exception.OntologyException;
import it.unibz.inf.ontop.injection.OntopMappingOntologyConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.OntopOntologyOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.impl.FactsException;
import it.unibz.inf.ontop.injection.impl.OntopMappingConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopMappingOntologyBuilders;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.spec.ontology.impl.RDFFactImpl;
import it.unibz.inf.ontop.spec.ontology.owlapi.OWLAPITranslatorOWL2QL;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.rdf.simple.SimpleRDF;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.protege.xmlcatalog.owlapi.XMLCatalogIRIMapper;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OntopMappingOntologyConfigurationImpl
extends OntopMappingConfigurationImpl
implements OntopMappingOntologyConfiguration,
OntopOntologyOWLAPIConfiguration {
    private final OntopMappingOntologyBuilders.OntopMappingOntologyOptions options;
    private Optional<OWLOntology> owlOntology;
    private Optional<ImmutableSet<RDFFact>> factsFile;

    protected OntopMappingOntologyConfigurationImpl(OntopMappingSettings settings, OntopMappingOntologyBuilders.OntopMappingOntologyOptions options) {
        super(settings, options.mappingOptions);
        this.options = options;
        this.owlOntology = Optional.empty();
        this.factsFile = Optional.empty();
    }

    protected OntopMappingOntologyConfigurationImpl(OntopMappingSettings settings, OntopMappingOntologyBuilders.OntopMappingOntologyOptions options, Supplier<Injector> injectorSupplier) {
        super(settings, options.mappingOptions, injectorSupplier);
        this.options = options;
        this.owlOntology = Optional.empty();
        this.factsFile = Optional.empty();
    }

    public Optional<ImmutableSet<RDFFact>> loadInputFacts() throws OBDASpecificationException {
        if (this.factsFile.isPresent()) {
            return this.factsFile;
        }
        return this.loadFactsFromFile();
    }

    public Optional<OWLOntology> loadInputOntology() throws OWLOntologyCreationException {
        if (this.owlOntology.isPresent()) {
            return this.owlOntology;
        }
        return this.loadOntologyFromFile();
    }

    private Optional<OWLOntology> loadOntologyFromFile() throws OWLOntologyCreationException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        if (this.options.xmlCatalogFile.isPresent()) {
            XMLCatalogIRIMapper iriMapper;
            try {
                iriMapper = new XMLCatalogIRIMapper(new File(this.options.xmlCatalogFile.get()));
            }
            catch (IOException e) {
                throw new OWLOntologyCreationException(e.getMessage());
            }
            manager.setIRIMappers((Set)ImmutableSet.of((Object)iriMapper));
        }
        if (this.options.ontologyFile.isPresent()) {
            this.owlOntology = Optional.of(manager.loadOntologyFromOntologyDocument(this.options.ontologyFile.get()));
        } else if (this.options.ontologyReader.isPresent()) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(CharStreams.toString((Readable)this.options.ontologyReader.get()).getBytes(Charsets.UTF_8));
                this.owlOntology = Optional.of(manager.loadOntologyFromOntologyDocument((InputStream)inputStream));
            }
            catch (IOException e) {
                throw new OWLOntologyCreationException(e.getMessage());
            }
        }
        Optional<URL> optionalURL = this.options.ontologyURL;
        if (optionalURL.isPresent()) {
            try (InputStream is = optionalURL.get().openStream();){
                this.owlOntology = Optional.of(manager.loadOntologyFromOntologyDocument(is));
            }
            catch (MalformedURLException e) {
                throw new OWLOntologyCreationException("Invalid URI: " + e.getMessage());
            }
            catch (IOException e) {
                throw new OWLOntologyCreationException(e.getMessage());
            }
        }
        return this.owlOntology;
    }

    private RDFFormat toRDFFormat(String format) {
        Optional guessedFormat = Rio.getParserFormatForFileName((String)format);
        return guessedFormat.orElse(RDFFormat.TURTLE);
    }

    private Optional<ImmutableSet<RDFFact>> loadFactsFromFile() throws FactsException {
        Optional<RDFFormat> format = this.options.factFormat.map(this::toRDFFormat).or(() -> this.options.factsFile.map(f -> Rio.getParserFormatForFileName((String)f.getName())).orElse(Optional.empty()));
        if (this.options.factsFile.isEmpty() && this.options.factsURL.isEmpty() && this.options.factsReader.isEmpty()) {
            return this.factsFile;
        }
        if (format.isEmpty()) {
            throw new FactsException("No valid fact file format was provided, and a format could not be inferred from the file name.");
        }
        try {
            if (this.options.factsFile.isPresent()) {
                this.factsFile = Optional.of(this.loadFactsWithReader(new FileReader(this.options.factsFile.get()), format.get()));
            } else if (this.options.factsReader.isPresent()) {
                this.factsFile = Optional.of(this.loadFactsWithReader(this.options.factsReader.get(), format.get()));
            } else if (this.options.factsURL.isPresent()) {
                this.factsFile = Optional.of(this.loadFactsWithReader(new InputStreamReader(this.options.factsURL.get().openStream()), format.get()));
            }
        }
        catch (IOException e) {
            throw new FactsException((Exception)e);
        }
        catch (IllegalArgumentException | RDFHandlerException | RDFParseException e) {
            throw new FactsException("An error occured while parsing the facts file: " + e.getMessage(), (Exception)e);
        }
        return this.factsFile;
    }

    private ImmutableSet<RDFFact> loadFactsWithReader(Reader reader, RDFFormat format) throws FactsException {
        RDFParser parser = Rio.createParser((RDFFormat)format);
        LinkedHashModel model = new LinkedHashModel();
        parser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        try {
            parser.parse(reader, this.options.factsBaseIRI.orElseGet(() -> String.format("http://%s.example.org/data/", UUID.randomUUID())));
        }
        catch (IOException e) {
            throw new FactsException((Exception)e);
        }
        return (ImmutableSet)model.stream().map(this::statementToFact).collect(ImmutableCollectors.toSet());
    }

    private RDFFact statementToFact(Statement statement) {
        Resource sub = statement.getSubject();
        BNode factSubject = sub.isBNode() ? this.getTermFactory().getConstantBNode(sub.stringValue()) : this.getTermFactory().getConstantIRI(sub.stringValue());
        IRI pred = statement.getPredicate();
        IRIConstant factPredicate = this.getTermFactory().getConstantIRI(pred.stringValue());
        Value obj = statement.getObject();
        BNode factObject = obj.isBNode() ? this.getTermFactory().getConstantBNode(obj.stringValue()) : (obj.isIRI() ? this.getTermFactory().getConstantIRI(obj.stringValue()) : (((Literal)obj).getLanguage().isPresent() ? this.getTermFactory().getRDFLiteralConstant(((Literal)obj).getLabel(), (String)((Literal)obj).getLanguage().get()) : this.getTermFactory().getRDFLiteralConstant(((Literal)obj).getLabel(), new SimpleRDF().createIRI(((Literal)obj).getDatatype().stringValue()))));
        Optional<Resource> ctxt = Optional.ofNullable(statement.getContext());
        Optional<ObjectConstant> factContext = ctxt.map(c -> c.isBNode() ? this.getTermFactory().getConstantBNode(c.stringValue()) : this.getTermFactory().getConstantIRI(c.stringValue()));
        return factContext.map(arg_0 -> OntopMappingOntologyConfigurationImpl.lambda$statementToFact$4((ObjectConstant)factSubject, factPredicate, (RDFConstant)factObject, arg_0)).orElseGet(() -> OntopMappingOntologyConfigurationImpl.lambda$statementToFact$5((ObjectConstant)factSubject, factPredicate, (RDFConstant)factObject));
    }

    Optional<Ontology> loadOntology() throws OntologyException {
        OWLAPITranslatorOWL2QL translator = (OWLAPITranslatorOWL2QL)this.getInjector().getInstance(OWLAPITranslatorOWL2QL.class);
        try {
            return this.loadInputOntology().map(arg_0 -> ((OWLAPITranslatorOWL2QL)translator).translateAndClassify(arg_0));
        }
        catch (OWLOntologyCreationException e) {
            throw new OntologyException(e.getMessage());
        }
    }

    private static /* synthetic */ RDFFact lambda$statementToFact$5(ObjectConstant factSubject, IRIConstant factPredicate, RDFConstant factObject) {
        return RDFFactImpl.createTripleFact((ObjectConstant)factSubject, (IRIConstant)factPredicate, (RDFConstant)factObject);
    }

    private static /* synthetic */ RDFFact lambda$statementToFact$4(ObjectConstant factSubject, IRIConstant factPredicate, RDFConstant factObject, ObjectConstant objectConstant) {
        return RDFFactImpl.createQuadFact((ObjectConstant)factSubject, (IRIConstant)factPredicate, (RDFConstant)factObject, (ObjectConstant)objectConstant);
    }
}

