/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.specialpredicates;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.SpecialPredicate;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.specialpredicates.LiteralType;
import com.ontotext.graphql.compiler.specialpredicates.RdfType;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import java.util.function.UnaryOperator;

public class TypeProxy
implements SpecialPredicate {
    private static final LiteralType LITERAL_TYPE = new LiteralType();
    private static final RdfType RDF_TYPE = new RdfType();

    @Override
    public String getPredicate() {
        return "type";
    }

    @Override
    public String getRdfProperty(Shape wrappingType) {
        if ("Literal".equals(wrappingType.getId())) {
            return LITERAL_TYPE.getRdfProperty(wrappingType);
        }
        return RDF_TYPE.getRdfProperty(wrappingType);
    }

    @Override
    public SparqlNode generateSparql(Selectable selection, Var object, ConstraintGenerator constraintGenerator, UnaryOperator<Var> varProcessor) {
        if (TypeProxy.isLiteralType(selection)) {
            return LITERAL_TYPE.generateSparql(selection, object, constraintGenerator, varProcessor);
        }
        return RDF_TYPE.generateSparql(selection, object, constraintGenerator, varProcessor);
    }

    @Override
    public Var createPredicateVariable(Selectable selectable, Var subject) {
        if (TypeProxy.isLiteralType(selectable)) {
            return LITERAL_TYPE.createPredicateVariable(selectable, subject);
        }
        return RDF_TYPE.createPredicateVariable(selectable, subject);
    }

    private static boolean isLiteralType(Selectable selection) {
        return selection.getParent() != null && "Literal".equals(selection.getParent().getType());
    }
}

