/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.queryoptimizations;

import com.ontotext.graphql.compiler.QueryOptimization;
import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.SelectQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Union;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class OptionalsToUnions
implements QueryOptimization {
    @Override
    public void optimize(SelectQuery query) {
        TriplePatternBlock optimized = this.optimize(query.getWhereBlock(), null, new LinkedList<SparqlNode>());
        query.setWhereBlock(optimized);
    }

    private TriplePatternBlock optimize(TriplePatternBlock block, TriplePatternBlock parentBlock, List<SparqlNode> constraints) {
        LinkedList<TriplePatternBlock> optionals = new LinkedList<TriplePatternBlock>();
        LinkedList<SparqlNode> parentConstr = new LinkedList<SparqlNode>();
        parentConstr.addAll(constraints);
        LinkedList<SparqlNode> lvlConstr = new LinkedList<SparqlNode>();
        lvlConstr.addAll(parentConstr);
        LinkedList<SparqlNode> mandatory = new LinkedList<SparqlNode>();
        for (SparqlNode pattern : new ArrayList<SparqlNode>(block.getPatterns())) {
            if (this.addConstraintsFromCurrentLevel(pattern, lvlConstr)) continue;
            if (this.isPatternOptionalSubField(pattern)) {
                optionals.add(this.optimize(((Optional)pattern).getNode(), block, parentConstr));
                continue;
            }
            mandatory.add(pattern);
        }
        if (optionals.isEmpty()) {
            if (parentBlock != null) {
                block.addAllFirst(parentConstr);
            }
            return block;
        }
        TriplePatternBlock optimized = new TriplePatternBlock();
        optimized.addAll(lvlConstr);
        Union union = new Union();
        if (!mandatory.isEmpty()) {
            union.addNode(new TriplePatternBlock(mandatory));
        }
        for (TriplePatternBlock optional : optionals) {
            union.addNode(optional);
        }
        optimized.addNode(union);
        return optimized;
    }

    private boolean isPatternOptionalSubField(SparqlNode pattern) {
        return pattern instanceof Optional && ((Optional)pattern).isMultivalued();
    }

    private boolean addConstraintsFromCurrentLevel(SparqlNode node, List<SparqlNode> currConstr) {
        if (node instanceof Empty) {
            return false;
        }
        if (node instanceof PatternNode && ((PatternNode)node).isRestrictive()) {
            currConstr.add(node);
            return true;
        }
        if (!(node instanceof Optional)) {
            currConstr.add(node);
            return true;
        }
        return false;
    }
}

