/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel.functions;

import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.soaas.common.SparqlUtil;
import java.util.stream.Stream;

public class GroupConcat
implements SparqlNode {
    private final SparqlNode variable;
    private final Var groupVar;
    private final String separator;

    public GroupConcat(SparqlNode variable, Var groupVar) {
        this.variable = variable;
        this.groupVar = groupVar;
        this.separator = null;
    }

    public GroupConcat(SparqlNode variable, String separator, Var groupVar) {
        this.variable = variable;
        this.separator = separator;
        this.groupVar = groupVar;
    }

    @Override
    public String toSparql() {
        Object separatorValue = "";
        if (this.separator != null) {
            separatorValue = ";separator=\"" + SparqlUtil.escape((String)this.separator) + "\"";
        }
        return "(GROUP_CONCAT(" + this.variable.toSparql() + (String)separatorValue + ") as " + this.groupVar.toSparql() + ")";
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.of(this.variable, this.groupVar);
    }
}

