/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Var
implements Value,
Comparable<Var> {
    private final Var parent;
    private final String localName;
    private final Boolean multiValued;

    @Override
    public String toSparql() {
        String name = this.getName();
        if (name.startsWith("?") || name.startsWith("$")) {
            return name;
        }
        return "?" + name;
    }

    public Var(String localName) {
        this(null, localName, null);
    }

    public Var(Var parent, String localName) {
        this(parent, localName, null);
    }

    public Var(Var parent, String localName, Boolean multiValued) {
        this.parent = parent;
        this.localName = localName;
        this.multiValued = multiValued;
    }

    @Override
    public String getName() {
        if (this.parent == null) {
            return this.localName;
        }
        if (this.localName.startsWith("?") || this.localName.startsWith("$")) {
            return this.parent.getName() + "_" + this.localName.substring(1);
        }
        return this.parent.getName() + "_" + this.localName;
    }

    public String getFullName() {
        return this.getName();
    }

    public String getLocalName() {
        return this.localName;
    }

    public Var getParent() {
        return this.parent;
    }

    public Boolean getMultiValued() {
        return this.multiValued;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Var var = (Var)obj;
        return Objects.equals(this.parent, var.parent) && Objects.equals(this.localName, var.localName);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.localName);
    }

    @Override
    public int compareTo(Var other) {
        String name = this.getName();
        String otherName = other.getName();
        if (otherName.startsWith(name)) {
            return -1;
        }
        if (name.startsWith(otherName)) {
            return 1;
        }
        int depthCompare = Integer.compare(this.getVarDepth(), other.getVarDepth());
        if (depthCompare == 0) {
            return name.compareTo(otherName);
        }
        return depthCompare;
    }

    public int getVarDepth() {
        int depth = 0;
        Var parentVar = this;
        while (parentVar.getParent() != null) {
            parentVar = parentVar.getParent();
            ++depth;
        }
        return depth;
    }

    public List<String> getVarPath() {
        LinkedList<String> path = new LinkedList<String>();
        path.add(this.getLocalName());
        Var parentVar = this;
        while (parentVar.getParent() != null) {
            parentVar = parentVar.getParent();
            path.addFirst(parentVar.getLocalName());
        }
        return path;
    }

    public String toString() {
        return this.toSparql();
    }

    public Var copy() {
        if (this.parent == null) {
            return new Var(null, this.getLocalName(), this.multiValued);
        }
        return new Var(this.getParent().copy(), this.getLocalName(), this.multiValued);
    }

    public static List<Var> sortVarsByDepth(List<Var> toSort) {
        Integer firstItem;
        if (toSort.size() < 2) {
            return toSort;
        }
        Map groupedByDepth = toSort.stream().sorted(Comparator.comparingInt(Var::getVarDepth)).collect(Collectors.groupingBy(Var::getVarDepth, LinkedHashMap::new, Collectors.toList()));
        List firstLevel = (List)groupedByDepth.get(firstItem = (Integer)groupedByDepth.keySet().iterator().next());
        if (firstLevel.size() == 1) {
            return new ArrayList<Var>(Var.collectSubVars((Var)firstLevel.get(0), groupedByDepth));
        }
        return toSort;
    }

    private static Set<Var> collectSubVars(Var current, Map<Integer, List<Var>> groupedByDepth) {
        List<Var> subVars = Var.getSubVars(current, groupedByDepth);
        if (subVars.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Var> result = new LinkedHashSet<Var>();
        result.add(current);
        Set simpleVars = subVars.stream().filter(Var.simpleVars(groupedByDepth)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        result.addAll(simpleVars);
        for (Var var : subVars) {
            if (simpleVars.contains(var)) continue;
            result.addAll(Var.collectSubVars(var, groupedByDepth));
        }
        return result;
    }

    private static List<Var> getSubVars(Var current, Map<Integer, List<Var>> groupedByDepth) {
        List varsAtNextDepth = groupedByDepth.getOrDefault(current.getVarDepth() + 1, Collections.emptyList());
        String varName = current.getName() + "_";
        return varsAtNextDepth.stream().filter(var -> var.getName().startsWith(varName)).sorted().collect(Collectors.toList());
    }

    private static Predicate<Var> simpleVars(Map<Integer, List<Var>> groupedByDepth) {
        return current -> Var.getSubVars(current, groupedByDepth).isEmpty();
    }
}

