/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class Values
implements SparqlNode {
    private final Var var;
    private final List<Value> valuesList;

    public Values(Var var) {
        this(var, Collections.emptyList());
    }

    public Values(Var var, List<? extends Value> values) {
        this.var = var;
        this.valuesList = values;
    }

    public Var getVar() {
        return this.var;
    }

    public List<Value> getValues() {
        return this.valuesList;
    }

    @Override
    public String toSparql() {
        StringBuilder builder = new StringBuilder();
        builder.append("VALUES ").append(this.var.toSparql()).append(" {");
        this.valuesList.stream().map(SparqlNode::toSparql).forEach(value -> builder.append(" ").append((String)value));
        builder.append(" }");
        return builder.toString();
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.concat(Stream.of(this.var), this.valuesList.stream().map(SparqlNode.class::cast));
    }
}

