/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class TriplePatternChain
implements SparqlNode {
    private final Value subject;
    private Set<Pair<Value, Value>> predicates = new LinkedHashSet<Pair<Value, Value>>();

    public TriplePatternChain(Value subject) {
        this.subject = subject;
    }

    @Override
    public String toSparql() {
        if (this.predicates.isEmpty()) {
            return "";
        }
        return this.subject.toSparql() + " " + this.predicates.stream().map(pair -> ((Value)pair.getLeft()).toSparql() + " " + ((Value)pair.getRight()).toSparql()).collect(Collectors.joining("; ", "", "."));
    }

    public TriplePatternChain add(Value predicate, Value object) {
        this.predicates.add((Pair<Value, Value>)Pair.of((Object)predicate, (Object)object));
        return this;
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.concat(Stream.of(this.subject), this.predicates.stream().flatMap(pair -> Stream.of((Value)pair.getLeft(), (Value)pair.getRight())));
    }

    public boolean isEmpty() {
        return this.predicates.isEmpty();
    }

    public Value getRoot() {
        return this.subject;
    }
}

