/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import java.util.Objects;
import java.util.stream.Stream;

public class TriplePattern
extends PatternNode {
    private Value predicate;

    @Override
    public String toSparql() {
        return this.getSubject().toSparql() + " " + this.predicate.toSparql() + " " + this.getObject().toSparql() + " .";
    }

    public TriplePattern(Value subject, Value predicate, Value object) {
        this(subject, predicate, object, false);
    }

    public TriplePattern(Value subject, Value predicate, Value object, boolean restrictive) {
        super(subject, object, restrictive);
        this.predicate = predicate;
    }

    public Value getPredicate() {
        return this.predicate;
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.of(this.getSubject(), this.predicate, this.getObject());
    }

    public String toString() {
        return this.toSparql();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TriplePattern)) {
            return false;
        }
        TriplePattern that = (TriplePattern)obj;
        return Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.getObject(), that.getObject());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.predicate);
    }
}

