/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.AbstractQuery;
import com.ontotext.graphql.compiler.querymodel.Base;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Order;
import com.ontotext.graphql.compiler.querymodel.Prefix;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Values;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SelectQuery
extends AbstractQuery
implements SparqlNode {
    protected Collection<SparqlNode> projectionSegment;
    protected Set<Iri> from;
    protected Set<Iri> fromNamed;
    protected TriplePatternBlock whereBlock;
    protected Long limit;
    protected Long offset;
    protected List<SparqlNode> groupBy;
    protected List<Order> orderBy;
    protected SparqlNode having;
    protected Values values;
    private boolean isSubSelect;
    protected Values iterateOver;

    @Override
    public String toSparql() {
        StringBuilder builder = new StringBuilder();
        this.handleIfSubSelect(builder);
        this.appendProjection(builder);
        if (this.from != null) {
            for (Iri iri : this.from) {
                builder.append(" FROM ").append(iri.toSparql());
            }
        }
        if (this.fromNamed != null) {
            for (Iri iri : this.fromNamed) {
                builder.append(" FROM NAMED ").append(iri.toSparql());
            }
        }
        if (this.whereBlock != null) {
            builder.append(" WHERE ");
            builder.append(this.whereBlock.toSparql());
        }
        if (this.groupBy != null && !this.groupBy.isEmpty()) {
            builder.append("GROUP BY ").append(this.groupBy.stream().map(SparqlNode::toSparql).collect(Collectors.joining(" "))).append(" ");
        }
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            builder.append("ORDER BY ").append(this.orderBy.stream().map(SparqlNode::toSparql).collect(Collectors.joining(" "))).append(" ");
        }
        SelectQuery.appendIfNotNull(builder, "HAVING ", this.having, this::outputHavingClauseValue);
        SelectQuery.appendIfNotNull(builder, "LIMIT ", this.limit, Function.identity());
        SelectQuery.appendIfNotNull(builder, "OFFSET ", this.offset, Function.identity());
        if (this.values != null) {
            builder.append(this.values.toSparql());
        }
        if (this.isSubSelect) {
            builder.append(" }");
        }
        return builder.toString();
    }

    private String outputHavingClauseValue(SparqlNode node) {
        String sparql = node.toSparql();
        return StringUtils.appendIfMissing((String)StringUtils.prependIfMissing((String)sparql, (CharSequence)"(", (CharSequence[])new CharSequence[0]), (CharSequence)")", (CharSequence[])new CharSequence[0]);
    }

    private void handleIfSubSelect(StringBuilder builder) {
        if (!this.isSubSelect) {
            if (this.base != null) {
                builder.append(this.base.toSparql()).append(" ");
            }
            if (this.prefixes != null) {
                builder.append(this.prefixes.stream().map(SparqlNode::toSparql).collect(Collectors.joining(" ", "", " ")));
            }
        } else {
            builder.append("{ ");
        }
    }

    private void appendProjection(StringBuilder builder) {
        if (this.projectionSegment != null) {
            String projections = this.projectionSegment.stream().map(SparqlNode::toSparql).collect(Collectors.joining(" "));
            builder.append("SELECT ").append(projections).append(" ");
        } else {
            builder.append("SELECT * ");
        }
    }

    private static <T> void appendIfNotNull(StringBuilder builder, String key, T value, Function<T, Object> transformer) {
        if (value != null) {
            builder.append(key).append(transformer.apply(value)).append(" ");
        }
    }

    public void convertToSubSelect() {
        this.isSubSelect = true;
    }

    @Override
    public Base getBase() {
        return this.base;
    }

    @Override
    public void setBase(Base base) {
        this.base = base;
    }

    @Override
    public List<Prefix> getPrefixes() {
        if (this.prefixes == null) {
            this.prefixes = new LinkedList();
        }
        return this.prefixes;
    }

    public void addFrom(Iri from) {
        if (from == null) {
            return;
        }
        if (this.from == null) {
            this.from = new LinkedHashSet<Iri>();
        }
        this.from.add(from);
    }

    public void addFromNamed(Iri from) {
        if (from == null) {
            return;
        }
        if (this.fromNamed == null) {
            this.fromNamed = new LinkedHashSet<Iri>();
        }
        this.fromNamed.add(from);
    }

    public TriplePatternBlock getWhereBlock() {
        if (this.whereBlock == null) {
            this.whereBlock = new TriplePatternBlock();
        }
        return this.whereBlock;
    }

    public void setWhereBlock(TriplePatternBlock whereBlock) {
        this.whereBlock = whereBlock;
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public void setValues(Values values) {
        this.values = values;
    }

    public SparqlNode getHaving() {
        return this.having;
    }

    public void setHaving(SparqlNode having) {
        this.having = having;
    }

    public Collection<SparqlNode> getProjectionSegment() {
        if (this.projectionSegment == null) {
            this.projectionSegment = new LinkedHashSet<SparqlNode>();
        }
        return this.projectionSegment;
    }

    public <S extends SparqlNode> void setProjectionSegment(Collection<S> projectionSegment) {
        this.projectionSegment = projectionSegment;
    }

    public List<SparqlNode> getGroupBy() {
        if (this.groupBy == null) {
            this.groupBy = new LinkedList<SparqlNode>();
        }
        return this.groupBy;
    }

    public List<Order> getOrderBy() {
        if (this.orderBy == null) {
            this.orderBy = new LinkedList<Order>();
        }
        return this.orderBy;
    }

    public Values getIterateOver() {
        return this.iterateOver;
    }

    public void setIterateOver(Values iterateOver) {
        this.iterateOver = iterateOver;
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        if (this.from == null && this.fromNamed == null) {
            return this.whereBlock.streamNodes();
        }
        Stream.Builder builder = Stream.builder();
        if (this.from != null) {
            this.from.forEach(builder);
        }
        if (this.fromNamed != null) {
            this.fromNamed.forEach(builder);
        }
        return Stream.concat(builder.build(), this.whereBlock.streamNodes());
    }
}

