/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.querymodel.FilterVar;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.UnionCollection;
import com.ontotext.graphql.compiler.querymodel.UnionNode;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.specialpredicates.BoType;
import com.ontotext.models.ActionFilter;
import com.ontotext.models.Constraint;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BoTypeFragment
implements SparqlNode {
    private final ConstraintGenerator constraintGenerator;
    private final Function<ActionFilter, java.util.Optional<SparqlNode>> filterGenerator;
    private final Set<Constraint> boTypes;
    private final Var subject;
    private final SparqlNode node;
    private final String boTypeAlias;
    private final Selectable selectable;
    private SparqlNode generatedNode;

    public BoTypeFragment(ConstraintGenerator constraintGenerator, Function<ActionFilter, java.util.Optional<SparqlNode>> filterGenerator, Set<Constraint> boTypes, SparqlNode node, Var subject, Selectable selectable) {
        this.constraintGenerator = constraintGenerator;
        this.filterGenerator = filterGenerator;
        this.boTypes = boTypes;
        this.subject = subject;
        this.node = node;
        this.boTypeAlias = BoType.getAlias(selectable);
        this.selectable = selectable;
    }

    @Override
    public String toSparql() {
        return this.getSparqlNode().toSparql();
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.of(this.getSparqlNode());
    }

    public SparqlNode getSparqlNode() {
        if (this.generatedNode == null) {
            LinkedList<SparqlNode> typeConstraints = new LinkedList<SparqlNode>();
            this.buildBoTypeConstraint(typeConstraints);
            typeConstraints.add(this.node);
            this.generatedNode = this.selectable.isRestrictive() ? new SparqlNodeSequence(typeConstraints) : new Optional(new TriplePatternBlock(typeConstraints), false);
        }
        return this.generatedNode;
    }

    private void buildBoTypeConstraint(List<SparqlNode> typeConstraints) {
        boolean requireNewTypeCheck = !this.selectable.isCountSelection();
        this.constraintGenerator.addBoTypeConstraint(this.boTypes, typeConstraints, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(this.subject).boTypeAlias(this.boTypeAlias).varProcessor(this.buildNewFilter()).filterGenerator(this.filterGenerator).service(this.getServiceForFragment(this.selectable)).soTypePresent(requireNewTypeCheck).exportSoType(requireNewTypeCheck).build());
    }

    private String getServiceForFragment(Selectable selection) {
        String service = selection.getDomainConstraints().isEmpty() ? selection.getDefinedInType().getServiceAddress() : ((Shape)selection.getDomainConstraints().get(0)).getServiceAddress();
        if (service != null && selection.getParent() != null && Objects.equals(service, selection.getParent().getService())) {
            return null;
        }
        return service;
    }

    private UnaryOperator<Var> buildNewFilter() {
        return var -> {
            if (var instanceof FilterVar) {
                return new FilterVar(var.getParent(), var.getLocalName(), ((FilterVar)var).idx + 1);
            }
            return var;
        };
    }

    public Set<Constraint> getBoTypes() {
        return this.boTypes;
    }

    public static java.util.Optional<BoTypeFragment> merge(List<BoTypeFragment> fragments) {
        if (fragments.size() < 2) {
            return java.util.Optional.empty();
        }
        BoTypeFragment firstFragment = fragments.get(0);
        ConstraintGenerator constraintGenerator = firstFragment.constraintGenerator;
        Function<ActionFilter, java.util.Optional<SparqlNode>> filterGenerator = firstFragment.filterGenerator;
        Set<Constraint> boType = firstFragment.boTypes;
        Var subject = firstFragment.subject;
        String boTypeAlias = firstFragment.boTypeAlias;
        for (int i = 1; i < fragments.size(); ++i) {
            if (constraintGenerator.equals(fragments.get((int)i).constraintGenerator) && boType.equals(fragments.get((int)i).boTypes) && subject.equals(fragments.get((int)i).subject) && boTypeAlias.equals(fragments.get((int)i).boTypeAlias)) continue;
            return java.util.Optional.empty();
        }
        SparqlNodeSequence combined = new SparqlNodeSequence(fragments.stream().map(node -> node.node).collect(Collectors.toList()));
        return java.util.Optional.of(new BoTypeFragment(constraintGenerator, filterGenerator, boType, combined, subject, firstFragment.selectable));
    }

    public static List<SparqlNode> mergeBoTypeFragmentsToOptionals(List<SparqlNode> nodes) {
        Map<Set, List<BoTypeFragment>> fragmentsByClass = nodes.stream().filter(BoTypeFragment.class::isInstance).map(BoTypeFragment.class::cast).collect(Collectors.groupingBy(BoTypeFragment::getBoTypes));
        for (Map.Entry<Set, List<BoTypeFragment>> entry : fragmentsByClass.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            BoTypeFragment.merge(entry.getValue()).ifPresent(merged -> {
                int position = 0;
                for (BoTypeFragment boTypeFragment : (List)entry.getValue()) {
                    position = nodes.indexOf(boTypeFragment);
                    nodes.remove(boTypeFragment);
                }
                nodes.add(position, (SparqlNode)merged);
            });
        }
        return nodes.stream().map(obj -> {
            if (obj instanceof BoTypeFragment) {
                return ((BoTypeFragment)obj).getSparqlNode();
            }
            return obj;
        }).collect(Collectors.toList());
    }

    public static void removeInlineFragmentsHelpers(TriplePatternBlock block) {
        Map<Set, List<BoTypeFragment>> fragmentsByClass = block.streamNodes().filter(BoTypeFragment.class::isInstance).map(BoTypeFragment.class::cast).collect(Collectors.groupingBy(BoTypeFragment::getBoTypes));
        for (Map.Entry<Set, List<BoTypeFragment>> entry : fragmentsByClass.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            BoTypeFragment.merge(entry.getValue()).ifPresent(merged -> {
                int position = 0;
                for (BoTypeFragment boTypeFragment : (List)entry.getValue()) {
                    position = block.removeNode(boTypeFragment);
                }
                block.addNode(position, (SparqlNode)merged);
            });
        }
        BoTypeFragment.removeInlineFragmentsHelpersInternal(block);
    }

    private static void removeInlineFragmentsHelpersInternal(TriplePatternBlock block) {
        Set<BoTypeFragment> toReplace = block.streamNodes().filter(BoTypeFragment.class::isInstance).map(BoTypeFragment.class::cast).collect(Collectors.toSet());
        toReplace.forEach(node -> block.addNode(block.removeNode((SparqlNode)node), node.getSparqlNode()));
    }

    public static List<UnionNode> mergeInUnionNodes(List<BoTypeFragment> boTypeFragments) {
        if (boTypeFragments.isEmpty()) {
            return new LinkedList<UnionNode>();
        }
        Map<Set, List<BoTypeFragment>> fragmentsByClass = boTypeFragments.stream().collect(Collectors.groupingBy(BoTypeFragment::getBoTypes));
        for (List<BoTypeFragment> value : fragmentsByClass.values()) {
            java.util.Optional<BoTypeFragment> merged = BoTypeFragment.merge(value);
            if (!merged.isPresent()) continue;
            value.clear();
            value.add(merged.get());
        }
        LinkedList<UnionNode> unionNodes = new LinkedList<UnionNode>();
        for (List<BoTypeFragment> value : fragmentsByClass.values()) {
            for (BoTypeFragment boTypeFragment : value) {
                unionNodes.add(boTypeFragment.toOptionalNode());
            }
        }
        return unionNodes;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnionNode toOptionalNode() {
        LinkedList<SparqlNode> typeConstraints = new LinkedList<SparqlNode>();
        this.buildBoTypeConstraint(typeConstraints);
        TriplePatternBlock innerSparqlNodes = new TriplePatternBlock(typeConstraints);
        if (this.node instanceof UnionNode) {
            innerSparqlNodes.addNode(new UnionCollection(Collections.singletonList((UnionNode)this.node)));
            return new UnionNode(innerSparqlNodes);
        }
        if (this.node instanceof SparqlNodeSequence) {
            if (this.node.streamNodes().anyMatch(UnionNode.class::isInstance)) {
                LinkedList<SparqlNode> notUnionNodes = new LinkedList<SparqlNode>();
                UnionCollection collection = new UnionCollection();
                this.node.streamNodes().forEach(subNode -> {
                    if (subNode instanceof UnionNode || subNode instanceof UnionCollection) {
                        collection.addNode((SparqlNode)subNode);
                    } else {
                        notUnionNodes.add((SparqlNode)subNode);
                    }
                });
                if (!notUnionNodes.isEmpty()) {
                    collection.addNode(new UnionNode(new SparqlNodeSequence(notUnionNodes)));
                }
                innerSparqlNodes.addNode(collection);
                return new UnionNode(innerSparqlNodes);
            }
        }
        innerSparqlNodes.addNode(this.node);
        return new UnionNode(innerSparqlNodes);
    }
}

