/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Base;
import com.ontotext.graphql.compiler.querymodel.Prefix;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractQuery
implements SparqlNode {
    protected Base base;
    protected List<Prefix> prefixes;

    @Override
    public String toSparql() {
        StringBuilder builder = new StringBuilder();
        if (this.base != null) {
            builder.append(this.base.toSparql()).append(" ");
        }
        if (this.prefixes != null && !this.prefixes.isEmpty()) {
            builder.append(this.prefixes.stream().map(SparqlNode::toSparql).collect(Collectors.joining(" ", "", " ")));
        }
        return builder.toString();
    }

    public Base getBase() {
        return this.base;
    }

    public void setBase(Base base) {
        this.base = base;
    }

    public List<Prefix> getPrefixes() {
        if (this.prefixes == null) {
            this.prefixes = new LinkedList<Prefix>();
        }
        return this.prefixes;
    }

    public void setPrefixes(List<Prefix> prefixes) {
        this.prefixes = prefixes;
    }
}

