/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.SpecialPredicate;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.RdfPropertyResolver;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;

public class SpecialPredicates {
    private static Map<String, SpecialPredicate> predicates;

    private SpecialPredicates() {
    }

    public static Optional<SparqlNode> handle(String predicate, Selectable selection, Var subject, ConstraintGenerator constraintGenerator) {
        return SpecialPredicates.handle(predicate, selection, subject, constraintGenerator, UnaryOperator.identity(), UnaryOperator.identity());
    }

    public static Optional<SparqlNode> handle(String predicate, Selectable selection, Var subject, ConstraintGenerator constraintGenerator, UnaryOperator<Var> varProcessor, UnaryOperator<SparqlNode> postProcessor) {
        return SpecialPredicates.get(predicate).map(pred -> pred.generateSparql(selection, subject, constraintGenerator, varProcessor)).map(postProcessor);
    }

    public static Optional<Var> getVar(String predicate, Selectable selection, Var subject) {
        return SpecialPredicates.get(predicate).map(pred -> pred.createPredicateVariable(selection, subject));
    }

    public static Optional<SpecialPredicate> get(String predicate) {
        if (predicates == null) {
            SpecialPredicates.loadPredicates();
        }
        return Optional.ofNullable(predicates.get(predicate));
    }

    private static void loadPredicates() {
        predicates = new HashMap<String, SpecialPredicate>();
        List specialPredicates = PluginsManager.loadPlugins(SpecialPredicate.class);
        for (SpecialPredicate predicate : specialPredicates) {
            predicates.put(predicate.getPredicate(), predicate);
        }
    }

    public static class SpecialPredicateRdfPropResolver
    implements RdfPropertyResolver {
        public String resolve(Shape shape, PropertyShape prop) {
            Optional<SpecialPredicate> sp = SpecialPredicates.get(prop.getName());
            if (sp.isPresent()) {
                return sp.get().getRdfProperty(shape);
            }
            return null;
        }
    }
}

