/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.EntityUpdateSparqlGenerator;
import com.ontotext.graphql.compiler.FilterBuildResult;
import com.ontotext.graphql.compiler.FilterBuilder;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.MutationSparqlGenerator;
import com.ontotext.graphql.compiler.OrderVariableBuilder;
import com.ontotext.graphql.compiler.PatternBuilder;
import com.ontotext.graphql.compiler.QueryOptimizer;
import com.ontotext.graphql.compiler.SparqlCompilationResult;
import com.ontotext.graphql.compiler.SparqlOperationBuilder;
import com.ontotext.graphql.compiler.SpecialPredicate;
import com.ontotext.graphql.compiler.SpecialPredicates;
import com.ontotext.graphql.compiler.querymodel.Base;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.BoTypeFragment;
import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.FederatedBlock;
import com.ontotext.graphql.compiler.querymodel.FilterVar;
import com.ontotext.graphql.compiler.querymodel.HelperVar;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.LateralJoinQuery;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.Order;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.Prefix;
import com.ontotext.graphql.compiler.querymodel.SelectQuery;
import com.ontotext.graphql.compiler.querymodel.SimpleValue;
import com.ontotext.graphql.compiler.querymodel.SparqlBuilderContext;
import com.ontotext.graphql.compiler.querymodel.SparqlFragment;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.SubscriptionNode;
import com.ontotext.graphql.compiler.querymodel.TempVar;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.UnionCollection;
import com.ontotext.graphql.compiler.querymodel.UnionExclusionSparqlNode;
import com.ontotext.graphql.compiler.querymodel.UnionNode;
import com.ontotext.graphql.compiler.querymodel.Values;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.querymodel.functions.Count;
import com.ontotext.graphql.compiler.specialpredicates.BoName;
import com.ontotext.graphql.compiler.specialpredicates.BoType;
import com.ontotext.models.ActionFilter;
import com.ontotext.models.Constraint;
import com.ontotext.models.Constraints;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationVisitor;
import com.ontotext.models.OperationVisitorContext;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.AbstractExpressionVisitor;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.IterateOverQuery;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Query;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.models.subscriptions.SubscriptionRequest;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.sparql.CompilationResult;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.soaas.common.sparql.PreviousExecution;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SparqlBuilder
implements SparqlOperationBuilder {
    private static final String LITERAL = "Literal";
    private static final String RES = "http://www.ontotext.com/semantic-object/result/";
    private static final Iri DISABLE_SAME_AS = new Iri("http://www.ontotext.com/disable-sameAs");
    private final QueryOptimizer queryOptimizer;
    private final SomlSchema schema;
    private final ConstraintGenerator constraintGenerator;
    private final FilterFactory filterFactory;
    private final SubSelectStrategy subSelectStrategy;
    private final OperationBuilderOptions options;
    private final PatternBuilder patternBuilder;
    private SelectQuery query;
    private FilterBuilder filterBuilder;
    private final List<SparqlBuilder> subQueries = new LinkedList<SparqlBuilder>();
    private Set<Var> bindings;
    private final Set<Var> usedInOrderOnly = new HashSet<Var>();
    private CompilationResult mutationQueries;
    private Function<Var, NamedGraphTriplePatternBlock> preconditionBuilder = id -> null;

    public SparqlBuilder(SomlSchema schema, QueryOptimizer queryOptimizer, FilterFactory filterFactory, SubSelectStrategy subSelectStrategy) {
        this(schema, queryOptimizer, filterFactory, subSelectStrategy, OperationBuilderOptions.DEFAULT);
    }

    public SparqlBuilder(SomlSchema schema, QueryOptimizer queryOptimizer, FilterFactory filterFactory, SubSelectStrategy subSelectStrategy, OperationBuilderOptions options) {
        this.schema = schema;
        this.queryOptimizer = queryOptimizer;
        this.filterFactory = filterFactory;
        this.constraintGenerator = new ConstraintGenerator(schema, options);
        this.subSelectStrategy = subSelectStrategy;
        this.options = options;
        this.patternBuilder = new PatternBuilder(() -> this.filterBuilder, this.constraintGenerator, options, filterFactory);
    }

    public SparqlNode visit(Query parsedQuery, SparqlBuilderContext sparqlContext) {
        sparqlContext = this.initContext(sparqlContext, parsedQuery);
        this.createRootQuery(parsedQuery, sparqlContext);
        TriplePatternBlock whereBlock = new TriplePatternBlock();
        Var subject = this.getSubject(parsedQuery, sparqlContext);
        this.addElasticFetch(whereBlock, parsedQuery, sparqlContext, subject);
        this.generateIdConstrain(whereBlock, (Selectable)parsedQuery, subject);
        this.addPrecondition(whereBlock, subject);
        this.generateBoTypeConstraints(whereBlock, (Selectable)parsedQuery, subject);
        this.generateFragmentConstraints(whereBlock, parsedQuery, subject);
        this.addFilter(subject, (Selectable)parsedQuery, whereBlock);
        this.handleSelections((Selectable)parsedQuery, subject, whereBlock);
        this.mergeWhereBlockWithLinkingBlock(parsedQuery, whereBlock);
        this.addOrder(subject, (Selectable)parsedQuery);
        this.addBase();
        this.addPrefixes();
        this.optimize();
        this.addProjections(parsedQuery);
        this.addLimitAndOffset(parsedQuery);
        this.removeTempVars();
        this.optimizeSubQueries();
        return Empty.INSTANCE;
    }

    public SparqlNode visit(Selection selection, SparqlBuilderContext sparqlContext) {
        throw new UnsupportedOperationException("Unimplemented method");
    }

    public SparqlNode visit(CreateMutation mutation, SparqlBuilderContext context) {
        return this.handleMutation((Mutation)mutation, context);
    }

    public SparqlNode visit(UpdateMutation mutation, SparqlBuilderContext context) {
        this.preconditionBuilder = var -> {
            NamedGraphTriplePatternBlock patternBlock = mutation.getChanges().stream().filter(Change::isRootChange).map(Change::getCollectChangesIn).findFirst().map(id -> EntityUpdateSparqlGenerator.createFetchPreviousResultsBlock(mutation, var, id)).orElse(null);
            mutation.getArguments().getFromNamed().ifPresent(fromList -> fromList.forEach(from -> this.query.addFromNamed(new Iri((String)from))));
            return patternBlock;
        };
        return this.handleMutation((Mutation)mutation, context);
    }

    public SparqlNode visit(DeleteMutation mutation, SparqlBuilderContext context) {
        return this.handleMutation((Mutation)mutation, context);
    }

    public SparqlNode visit(Subscription subscription, SparqlBuilderContext context) {
        subscription.markSubscriptionTypeAsPassThrough();
        return this.visit((Query)subscription, SparqlBuilderContext.of(new HelperVar(null, subscription.getName())));
    }

    @NotNull
    private SparqlBuilderContext initContext(SparqlBuilderContext sparqlContext, Query parsedQuery) {
        if (sparqlContext == null) {
            sparqlContext = new SparqlBuilderContext();
            if (parsedQuery instanceof IterateOverQuery) {
                IterateOverQuery iterateOverQuery = (IterateOverQuery)parsedQuery;
                SparqlBuilderContext.ExternalBinding externalBinding = new SparqlBuilderContext.ExternalBinding(null, new Var(iterateOverQuery.getVar()), iterateOverQuery.getValues());
                sparqlContext.setIterateOver(externalBinding);
            }
        }
        this.filterBuilder = sparqlContext.getFilterBuilder();
        if (this.filterBuilder == null) {
            this.filterBuilder = FilterFactory.getFilterBuilder(this.constraintGenerator, this.schema, this.options, this.filterFactory);
        }
        return sparqlContext;
    }

    private SparqlNode handleMutation(Mutation mutation, SparqlBuilderContext context) {
        this.mutationQueries = new MutationSparqlGenerator(this.schema, this.options.getMutationMode(), this.filterFactory, this.options).generate(mutation, this::createBuilderCopy);
        return (SparqlNode)mutation.toQuery().accept((OperationVisitor)this, (OperationVisitorContext)context);
    }

    /*
     * Unable to fully structure code
     */
    private void mergeWhereBlockWithLinkingBlock(Query parsedQuery, TriplePatternBlock whereBlock) {
        if (parsedQuery.getService() == null) ** GOTO lbl-1000
        if (!whereBlock.getPatterns().stream().allMatch((Predicate<SparqlNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lcom/ontotext/graphql/compiler/querymodel/SparqlNode;)Z)(SelectQuery.class))) {
            whereBlock = FederatedBlock.of(new Iri(parsedQuery.getService()), whereBlock);
            this.query.getWhereBlock().addNode(whereBlock);
        } else lbl-1000:
        // 2 sources

        {
            this.query.getWhereBlock().addAll(whereBlock.getPatterns());
        }
        this.mergeFederatedBlocks(this.query.getWhereBlock());
    }

    private void addElasticFetch(TriplePatternBlock whereBlock, Query parsedQuery, SparqlBuilderContext sparqlContext, Var subject) {
        if (!sparqlContext.isRootQuery()) {
            return;
        }
        SubscriptionRequest stream = (SubscriptionRequest)parsedQuery.getArguments().get((Object)"stream");
        if (stream != null) {
            whereBlock.addNode(new SubscriptionNode(stream, subject));
        }
    }

    private void addPrecondition(TriplePatternBlock whereBlock, Var subject) {
        NamedGraphTriplePatternBlock preconditions;
        if (this.preconditionBuilder != null && (preconditions = this.preconditionBuilder.apply(subject)) != null) {
            whereBlock.addNode(preconditions);
        }
    }

    private void handleSelections(Selectable parent, Var subject, TriplePatternBlock block) {
        if (parent.getShapeType().filter(Shape::isUnion).isPresent()) {
            this.handleUnionSelections(parent.getSelections(), subject, block);
        } else {
            this.handleSelections(parent.getSelections(), subject, block);
        }
    }

    private void handleSelections(Collection<? extends Selectable> selectables, Var subject, TriplePatternBlock block) {
        LinkedList<SparqlNode> allNodes = new LinkedList<SparqlNode>();
        LinkedList<SparqlNode> restrictive = new LinkedList<SparqlNode>();
        LinkedList<SparqlNode> singleValued = new LinkedList<SparqlNode>();
        for (Selectable selectable : selectables) {
            SparqlNode node = this.handleSelection(subject, (Selection)selectable);
            if (node == Empty.INSTANCE) continue;
            if (selectable.isRestrictive() || node instanceof UnionExclusionSparqlNode) {
                restrictive.add(node);
                continue;
            }
            allNodes.add(node);
            if (!this.isSelectionConsideredSingleValued(selectable) || selectable.isInFragment() && this.hasMultipleFragments(selectable.getParent()) || selectable.hasConstraints() || selectable.isCountSelection()) continue;
            singleValued.add(node);
        }
        this.addNodesToParentBlock(selectables, block, allNodes, restrictive, singleValued);
    }

    private boolean isSelectionConsideredSingleValued(Selectable selection) {
        if (!selection.isComplexType() || selection.getProperty().filter(PropertyShape::isLiteral).isPresent()) {
            return !selection.isCollection();
        }
        if (this.options.isDisableSinglePropertiesOptimization() || SparqlBuilder.hasRestrictiveTemplate(selection)) {
            return !selection.isCollection();
        }
        return selection.isSelectionConsideredSingleValued();
    }

    private boolean hasMultipleFragments(Selectable parent) {
        return parent.getSelections().stream().filter(Selectable::isInFragment).map(Selectable::getDefinedIn).distinct().count() > 1L;
    }

    private static boolean hasRestrictiveTemplate(Selectable selection) {
        while (selection.getParent() != null) {
            if (selection.getParent().getSelections().stream().anyMatch(SparqlBuilder::isRestrictiveTemplate)) {
                return true;
            }
            selection = selection.getParent();
        }
        return false;
    }

    private static boolean isRestrictiveTemplate(Selectable selection) {
        return selection.getProperty().filter(prop -> prop.isRestrictive() != false && prop.isSparqlTemplate()).isPresent();
    }

    private void addNodesToParentBlock(Collection<? extends Selectable> selectables, TriplePatternBlock block, List<SparqlNode> allNodes, List<SparqlNode> restrictive, List<SparqlNode> singleValued) {
        List<UnionNode> unionNodes = this.extractAllMatchingClass(allNodes, UnionNode.class);
        List<BoTypeFragment> boTypeFragments = this.extractAllMatchingClass(allNodes, BoTypeFragment.class);
        List<Optional> optionals = this.extractAllMatchingClass(allNodes, Optional.class);
        boTypeFragments.removeAll(singleValued);
        unionNodes.removeAll(singleValued);
        optionals.removeAll(singleValued);
        LinkedList<SparqlNode> nonUnionNodes = new LinkedList<SparqlNode>(allNodes);
        nonUnionNodes.removeAll(unionNodes);
        nonUnionNodes.removeAll(boTypeFragments);
        nonUnionNodes.removeAll(optionals);
        nonUnionNodes.removeAll(singleValued);
        optionals.stream().filter(Optional::isMultivalued).map(opt -> new UnionNode(opt.getNode())).forEach(unionNodes::add);
        optionals.removeIf(Optional::isMultivalued);
        block.addAll(restrictive);
        block.addAll(optionals);
        List<UnionNode> boTypeNodes = BoTypeFragment.mergeInUnionNodes(boTypeFragments);
        List<SparqlNode> convertedSingleValuedProperties = this.unionNodesToOptionals(BoTypeFragment.mergeBoTypeFragmentsToOptionals(singleValued));
        if (unionNodes.isEmpty() && boTypeFragments.isEmpty()) {
            block.addAll(nonUnionNodes);
            block.addAll(convertedSingleValuedProperties);
        } else if (this.containsLimitOrOffset(selectables.stream().findFirst().orElseThrow().getParent())) {
            block.addAll(nonUnionNodes);
            block.addAll(convertedSingleValuedProperties);
            this.addToBlockAsOptionalNonUnion(block, unionNodes);
            this.addToBlockAsOptionalNonUnion(block, boTypeNodes);
        } else {
            UnionCollection unionCollection = new UnionCollection();
            unionCollection.addNode(new UnionNode(new TriplePatternBlock(convertedSingleValuedProperties)));
            if (!nonUnionNodes.isEmpty()) {
                unionCollection.addNode(new UnionNode(new TriplePatternBlock(nonUnionNodes)));
            }
            unionNodes.forEach(unionCollection::addNode);
            boTypeNodes.forEach(unionCollection::addNode);
            block.addNode(unionCollection);
        }
    }

    private List<SparqlNode> unionNodesToOptionals(List<SparqlNode> singleValued) {
        return singleValued.stream().flatMap(node -> {
            if (node instanceof UnionNode) {
                if (UnionNode.isEmptyNode(node)) {
                    return Stream.empty();
                }
                return node.streamNodes().map(nestedNode -> {
                    if (!this.nodeInOptional((SparqlNode)nestedNode)) {
                        nestedNode = new Optional((SparqlNode)nestedNode);
                    }
                    return nestedNode;
                });
            }
            return Stream.of(node);
        }).collect(Collectors.toList());
    }

    private void addToBlockAsOptionalNonUnion(TriplePatternBlock block, List<UnionNode> unionNodes) {
        unionNodes.stream().flatMap(UnionNode::streamNodes).map(node -> {
            if (!this.nodeInOptional((SparqlNode)node)) {
                node = new Optional((SparqlNode)node);
            }
            return node;
        }).forEach(block::addNode);
    }

    private void handleUnionSelections(List<? extends Selectable> selections, Var subject, TriplePatternBlock block) {
        Map<String, Set<Selectable>> groupByFragments = selections.stream().collect(Collectors.groupingBy(sel -> sel.getDefinedInType().getId(), Collectors.toCollection(LinkedHashSet::new)));
        this.pushTypenameToUnionFragments(groupByFragments);
        UnionCollection unionCollection = new UnionCollection();
        for (Set<Selectable> fragmentSelections : groupByFragments.values()) {
            TriplePatternBlock patternBlock = new TriplePatternBlock();
            this.handleSelections(fragmentSelections, subject, patternBlock);
            for (SparqlNode pattern : patternBlock.getPatterns()) {
                if (pattern instanceof UnionCollection) {
                    pattern.streamNodes().filter(node -> !UnionNode.isEmptyNode(node)).forEach(unionCollection::addNode);
                    continue;
                }
                block.addNode(pattern);
            }
        }
        block.addNode(unionCollection);
    }

    private void pushTypenameToUnionFragments(Map<String, Set<Selectable>> groupByFragments) {
        Iterator<Map.Entry<String, Set<Selectable>>> it = groupByFragments.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Set<Selectable>> entry = it.next();
            if (!entry.getValue().stream().anyMatch(selectable -> selectable.getDefinedInType() != null && selectable.getDefinedInType().isUnion())) continue;
            Shape unionType = entry.getValue().iterator().next().getDefinedInType();
            boolean modified = false;
            for (Shape member : unionType.getUnionOfShapes()) {
                String key = this.determineFragmentToUnionMember(member, groupByFragments::containsKey);
                if (key == null) continue;
                modified = true;
                groupByFragments.get(key).addAll((Collection<Selectable>)entry.getValue());
            }
            if (!modified) continue;
            it.remove();
        }
    }

    private String determineFragmentToUnionMember(Shape member, Predicate<String> memberCheck) {
        if (memberCheck.test(member.getId())) {
            return member.getId();
        }
        List hierarchy = member.getContainedIn().getHierarchy(member.getId());
        for (Shape parent : hierarchy) {
            if (!memberCheck.test(parent.getId())) continue;
            return parent.getId();
        }
        return null;
    }

    private SparqlNode handleSelection(Var subject, Selection selection) {
        boolean requireBoTypeFragment;
        if (selection.isIgnored() || !selection.isTreeQueryable()) {
            return Empty.INSTANCE;
        }
        SparqlBuilderContext subContext = SparqlBuilderContext.of(subject);
        subContext.setFilterBuilder(this.filterBuilder);
        boolean canBeTreatedAsSingleField = this.canTreatAsSingleField((Selectable)selection);
        if (!selection.isQueryable()) {
            return this.generateSparqlForSelection(subject, selection, subContext, canBeTreatedAsSingleField);
        }
        boolean hasConstraints = this.selectionHasConstraints(selection);
        if (this.shouldCreateNewSubquery(selection, hasConstraints)) {
            return this.createSubQuery(selection, subContext);
        }
        SparqlNode node = this.generateSparqlForSelection(subject, selection, subContext, canBeTreatedAsSingleField);
        if (hasConstraints && this.isSelectionMandatory((Selectable)selection) && !this.parentHasSameRbacConstraints(selection)) {
            SparqlNode excludeBlock = this.constraintGenerator.generateExcludeSelection((Selectable)selection, subject, this.filterBuilder);
            return new SparqlNodeSequence(Arrays.asList(node, excludeBlock));
        }
        if (node == Empty.INSTANCE) {
            return node;
        }
        boolean bl = requireBoTypeFragment = hasConstraints || selection.isInFragment() && !this.isUsedForOrder((Selectable)selection) || selection.hasDomainConstraints();
        if (requireBoTypeFragment) {
            node = this.createTypeFragment(subject, selection, node);
        }
        return node;
    }

    private SparqlNode createTypeFragment(Var subject, Selection selection, SparqlNode currentNode) {
        java.util.Optional<Set<Constraint>> fragmentTypeConstraints = this.getFragmentTypeConstraints((Selectable)selection, this.selectionHasConstraints(selection));
        if (fragmentTypeConstraints.isEmpty()) {
            currentNode = Empty.INSTANCE;
        } else {
            currentNode = new BoTypeFragment(this.constraintGenerator, this.filterGenerator(subject), fragmentTypeConstraints.get(), currentNode, subject, (Selectable)selection);
            String service = this.getServiceForFragment(selection);
            if (service != null) {
                currentNode = this.addFederationBlockInTheBoTypeFragment(service, (BoTypeFragment)currentNode, selection.isCollection());
            }
        }
        return currentNode;
    }

    private boolean selectionHasConstraints(Selection selection) {
        return selection.hasConstraints() && selection.getConstraints().hasFragmentConstraints();
    }

    private String getServiceForFragment(Selection selection) {
        String service = selection.getDomainConstraints().isEmpty() ? selection.getDefinedInType().getServiceAddress() : ((Shape)selection.getDomainConstraints().get(0)).getServiceAddress();
        if (service != null && selection.getParent() != null && Objects.equals(service, selection.getParent().getService())) {
            return null;
        }
        return service;
    }

    private boolean parentHasSameRbacConstraints(Selection selection) {
        return selection.getParent() != null && selection.getParent().hasConstraints() && selection.getParent().getConstraints().hasTypeConstraints() && selection.getParent().getConstraints().getTypeConstraints().equals(selection.getConstraints().getFragmentConstraints());
    }

    private SparqlNode generateSparqlForSelection(Var subject, Selection selection, SparqlBuilderContext subContext, boolean canBeTreatedAsSingleField) {
        java.util.Optional<SpecialPredicate> specialPredicate = this.isSpecialPredicateSelection((Selectable)selection);
        SparqlNode node = this.shouldSpecialPredicateBeHandled(canBeTreatedAsSingleField, specialPredicate) ? this.handleSpecialPredicate(subject, selection, subContext, specialPredicate) : (canBeTreatedAsSingleField ? this.handleSingeFieldSelection(selection, subContext) : this.handleComplexSelection(selection, subContext));
        return node;
    }

    private SparqlNode addFederationBlockInTheBoTypeFragment(String service, BoTypeFragment node, boolean isMultiValued) {
        Optional optionalNode = (Optional)node.getSparqlNode();
        TriplePatternBlock federatedBlock = new TriplePatternBlock((SparqlNode)FederatedBlock.of(new Iri(service), optionalNode.getNode()));
        if (isMultiValued) {
            return new UnionNode(federatedBlock);
        }
        return new Optional(federatedBlock, false);
    }

    private boolean shouldSpecialPredicateBeHandled(boolean canBeTreatedAsSingleField, java.util.Optional<SpecialPredicate> specialPredicate) {
        if (specialPredicate.isEmpty()) {
            return false;
        }
        if (specialPredicate.get().useRaw()) {
            return true;
        }
        return canBeTreatedAsSingleField;
    }

    private SparqlNode handleSpecialPredicate(Var subject, Selection selection, SparqlBuilderContext subContext, java.util.Optional<SpecialPredicate> specialPredicate) {
        UnaryOperator postOperation = UnaryOperator.identity();
        if (!specialPredicate.orElseThrow(IllegalArgumentException::new).useRaw()) {
            postOperation = intermediateNode -> (SparqlNode)this.addFilters(subject, (Selectable)selection).andThen(this.addNodeToOptional((Selectable)selection)).apply((SparqlNode)intermediateNode);
        }
        SparqlNode node = SpecialPredicates.handle(selection.getName(), (Selectable)selection, subContext.getSubject(), this.constraintGenerator, UnaryOperator.identity(), postOperation).orElseGet(() -> Empty.INSTANCE);
        return node;
    }

    private boolean isSelectionMandatory(Selectable selection) {
        return selection.getName().equals("id");
    }

    private java.util.Optional<Set<Constraint>> getFragmentTypeConstraints(Selectable selection, boolean hasConstraints) {
        String definedIn = selection.getDefinedInType().getId();
        if (this.isDomainConstraintsFree(selection)) {
            if (!hasConstraints) {
                return java.util.Optional.of(Constraints.fromShapeIds((String[])new String[]{definedIn}));
            }
            Set<Constraint> selectionConstraints = this.getConstraints(selection);
            java.util.Optional definedInConstraint = selectionConstraints.stream().filter(Constraint.byShapeId((String)definedIn)).findFirst();
            return definedInConstraint.map(Collections::singleton).or(() -> java.util.Optional.of(selectionConstraints));
        }
        Set<String> definedInConstraints = selection.getDomainConstraints().stream().map(Shape::getId).collect(Collectors.toSet());
        if (!hasConstraints) {
            return java.util.Optional.of(Constraints.fromShapeIds(definedInConstraints));
        }
        Set selectionConstraints = selection.getConstraints().getFragmentConstraints().stream().map(this.toConstraintAndAllowedTypePair()).collect(Collectors.toCollection(LinkedHashSet::new));
        Set constraintIntersection = selectionConstraints.stream().filter(this.byAllowedTypes(definedInConstraints)).map(Pair::getKey).collect(Collectors.toSet());
        if (constraintIntersection.isEmpty()) {
            return java.util.Optional.empty();
        }
        return java.util.Optional.of(constraintIntersection);
    }

    private Set<Constraint> getConstraints(Selectable selection) {
        Set selectionConstraints = selection.isRestrictive() ? this.removeMatchingParentConstraints(selection) : selection.getConstraints().getFragmentConstraints();
        return selectionConstraints;
    }

    private Set<Constraint> removeMatchingParentConstraints(Selectable selection) {
        if (selection.getParent() == null || selection.getParent().getConstraints() == null) {
            return Collections.emptySet();
        }
        Set parentSelectionConstraints = selection.getParent().getConstraints().getTypeConstraints();
        return selection.getConstraints().getFragmentConstraints().stream().filter(constraint -> !parentSelectionConstraints.contains(constraint)).collect(Collectors.toSet());
    }

    @NotNull
    private Function<Constraint, Pair<Constraint, Set<String>>> toConstraintAndAllowedTypePair() {
        return constraint -> {
            Shape shape = (Shape)this.schema.getObjects().get((Object)constraint.getShapeId());
            if (shape.isAbstract() || shape.isUnion()) {
                Set subTypeIds = shape.getConcreteSubTypes().stream().map(Shape::getId).collect(Collectors.toSet());
                return Pair.of((Object)constraint, subTypeIds);
            }
            return Pair.of((Object)constraint, Collections.singleton(shape.getId()));
        };
    }

    @NotNull
    private Predicate<Pair<Constraint, Set<String>>> byAllowedTypes(Set<String> definedInConstraints) {
        return pair -> {
            Constraint constraint = (Constraint)pair.getKey();
            Set types = (Set)pair.getValue();
            if (definedInConstraints.contains(constraint.getShapeId())) return true;
            if (types.size() <= 1) return false;
            if (!definedInConstraints.stream().anyMatch(types::contains)) return false;
            return true;
        };
    }

    private boolean isDomainConstraintsFree(Selectable selection) {
        List definedInConstraints = selection.getDomainConstraints();
        return definedInConstraints.isEmpty();
    }

    private SparqlNode handleSingeFieldSelection(Selection selection, SparqlBuilderContext sparqlContext) {
        SparqlNode nodeToAdd;
        if (LITERAL.equals(selection.getDefinedIn())) {
            return Empty.INSTANCE;
        }
        PatternNode selectionNode = this.createTriplePattern((Selectable)selection, sparqlContext.getSubject());
        if (selection.getArguments().getWhere().isPresent()) {
            TriplePatternBlock block = new TriplePatternBlock();
            block.addNode(selectionNode);
            Var subjForFilter = (Var)selectionNode.getObject();
            this.addFilter(subjForFilter, (Selectable)selection, block);
            nodeToAdd = block;
        } else {
            nodeToAdd = selectionNode;
        }
        if (selection.isInFragment() && selection.getArguments().isInheritedOrderBy() && Empty.INSTANCE == (nodeToAdd = this.createTypeFragment((Var)selectionNode.getSubject(), selection, nodeToAdd))) {
            return Empty.INSTANCE;
        }
        return (SparqlNode)this.addNodeToOptional((Selectable)selection).apply(nodeToAdd);
    }

    private SparqlNode handleComplexSelection(Selection selection, SparqlBuilderContext sparqlContext) {
        if (LITERAL.equals(selection.getDefinedIn())) {
            return Empty.INSTANCE;
        }
        PatternNode selectionNode = this.createTriplePattern((Selectable)selection, sparqlContext.getSubject());
        Var object = (Var)selectionNode.getObject();
        TriplePatternBlock objBlock = new TriplePatternBlock();
        TriplePatternBlock blockInParentService = new TriplePatternBlock();
        if (selection.isQueryable()) {
            this.addLinkNode(selection, selectionNode, blockInParentService);
            this.generateIdConstrain(objBlock, (Selectable)selection, object);
            this.generateBoTypeConstraints(objBlock, (Selectable)selection, object);
            this.addOrder(object, (Selectable)selection);
            this.addFilter(object, (Selectable)selection, blockInParentService);
            this.handleSelections((Selectable)selection, object, objBlock);
        } else {
            this.handleSelections((Selectable)selection, object, objBlock);
        }
        TriplePatternBlock block = this.mergeObjectBlockWithParentScopeBlock(selection, blockInParentService, objBlock);
        if (block.getPatterns().isEmpty()) {
            return Empty.INSTANCE;
        }
        this.mergeFederatedBlocks(block);
        if (!selection.isQueryable()) {
            return block;
        }
        if ((selection.isCollection() || selection.isComplexType() && !this.isSelectionConsideredSingleValued((Selectable)selection)) && this.notLiteralOrder((Selectable)selection) && !selection.getArguments().isInheritedOrderBy()) {
            return new UnionNode(block);
        }
        return (SparqlNode)this.addNodeToOptional((Selectable)selection).apply(block);
    }

    /*
     * Unable to fully structure code
     */
    private TriplePatternBlock mergeObjectBlockWithParentScopeBlock(Selection selection, TriplePatternBlock blockInParentService, TriplePatternBlock objBlock) {
        if (blockInParentService.getPatterns().isEmpty()) {
            return objBlock;
        }
        combined = new TriplePatternBlock();
        combined.addAll(blockInParentService.getPatterns());
        if (selection.getService() == null || this.isIdPropertyInService((Selectable)selection) || selection.getService().equals(selection.getParent().getService())) ** GOTO lbl-1000
        if (!objBlock.getPatterns().stream().allMatch((Predicate<SparqlNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lcom/ontotext/graphql/compiler/querymodel/SparqlNode;)Z)(SelectQuery.class))) {
            objBlock = FederatedBlock.of(new Iri(selection.getService()), objBlock);
            combined.addNode(objBlock);
        } else lbl-1000:
        // 2 sources

        {
            combined.addAll(objBlock.getPatterns());
        }
        combined = this.flattenTriplePatternBlock(combined);
        this.mergeFederatedBlocks(combined);
        return combined;
    }

    private TriplePatternBlock flattenTriplePatternBlock(TriplePatternBlock combined) {
        if (combined.getPatterns().stream().noneMatch(SparqlNodeSequence.class::isInstance)) {
            return combined;
        }
        TriplePatternBlock newBlock = new TriplePatternBlock();
        for (SparqlNode pattern : combined.getPatterns()) {
            if (pattern instanceof SparqlNodeSequence) {
                SparqlNodeSequence sequence = (SparqlNodeSequence)pattern;
                newBlock.addAll(sequence.getNodes());
                continue;
            }
            newBlock.addNode(pattern);
        }
        return newBlock;
    }

    private void mergeFederatedBlocks(TriplePatternBlock block) {
        Map<Iri, List<FederatedBlock>> groupedFederations = block.getPatterns().stream().filter(FederatedBlock.class::isInstance).map(FederatedBlock.class::cast).collect(Collectors.groupingBy(FederatedBlock::getService));
        for (Map.Entry<Iri, List<FederatedBlock>> iriFederatedBlockEntry : groupedFederations.entrySet()) {
            if (iriFederatedBlockEntry.getValue().size() <= 1) continue;
            FederatedBlock combined = new FederatedBlock(iriFederatedBlockEntry.getKey());
            int idx = 0;
            for (FederatedBlock toBeMerged : iriFederatedBlockEntry.getValue()) {
                idx = block.removeNode(toBeMerged);
                combined.addAll(toBeMerged.getPatterns());
            }
            block.addNode(idx, combined);
        }
    }

    private boolean notLiteralOrder(Selectable selection) {
        return selection.getSelections().stream().noneMatch(item -> item.getAlias() != null && item.getName().equals("value") && item.getArguments().isAscendingOrder().isPresent());
    }

    private void createRootQuery(Query parsedQuery, SparqlBuilderContext sparqlContext) {
        Values iterateOver = this.getIterateOverValues(sparqlContext);
        if (iterateOver == null) {
            this.query = new SelectQuery();
            Arguments arguments = parsedQuery.getArguments();
            arguments.getExpandOverOwlSameAs().filter(Boolean.FALSE::equals).ifPresent(val -> this.query.addFrom(DISABLE_SAME_AS));
            arguments.getFrom().ifPresent(fromList -> fromList.forEach(from -> this.query.addFrom(new Iri((String)from))));
            arguments.getFromNamed().ifPresent(fromList -> fromList.forEach(from -> this.query.addFromNamed(new Iri((String)from))));
        } else {
            if (this.containsLimitOrOffset((Selectable)parsedQuery) && this.isSplitQueryUsed()) {
                this.query = new LateralJoinQuery();
            } else {
                this.query = new SelectQuery();
                this.query.setValues(iterateOver);
            }
            if (sparqlContext.getIterateOver().getLinkNode() != null) {
                this.query.getWhereBlock().addNode(sparqlContext.getIterateOver().getLinkNode());
            }
            this.query.setIterateOver(iterateOver);
        }
    }

    @Nullable
    private Values getIterateOverValues(SparqlBuilderContext sparqlContext) {
        Values iterateOver = null;
        if (sparqlContext != null && sparqlContext.getIterateOver() != null) {
            SparqlBuilderContext.ExternalBinding binding = sparqlContext.getIterateOver();
            iterateOver = new Values(binding.getVar(), binding.getValues().stream().map(arg_0 -> ((Prefixes)this.schema.getPrefixes()).toRelativeIri(arg_0)).map(Iri::new).collect(Collectors.toList()));
        }
        return iterateOver;
    }

    private boolean isSplitQueryUsed() {
        return this.subSelectStrategy != SubSelectStrategy.SUB_SELECT;
    }

    private SparqlNode createSubQuery(Selection selection, SparqlBuilderContext context) {
        Query subQuery = new Query();
        Var subjVar = SpecialPredicates.getVar(selection.getName(), (Selectable)selection, context.getSubject()).orElseGet(() -> new Var(context.getSubject(), selection.getResponseName(), selection.isCollection()));
        subQuery.setName(subjVar.getName());
        subQuery.setSelections(selection.getSelections().stream().map(Selection::deepCopy).collect(Collectors.toList()));
        subQuery.getWhereSelections().addAll(selection.getWhereSelections().stream().map(Selection::deepCopy).collect(Collectors.toList()));
        subQuery.setArguments(selection.getArguments());
        subQuery.setReturnType(selection.getType());
        subQuery.setRangeCheck(selection.isRangeCheck());
        subQuery.setReturnTypeInstance(selection.getShapeType().orElse(selection.getDefinedInType()));
        subQuery.setConstraints(selection.getConstraints());
        subQuery.setDomainConstraints((Collection)selection.getDomainConstraints());
        subQuery.setService(selection.getService());
        SparqlBuilderContext subContext = SparqlBuilderContext.of(subjVar);
        SparqlNode linkNode = SpecialPredicates.handle(selection.getName(), (Selectable)selection, context.getSubject(), this.constraintGenerator, UnaryOperator.identity(), this.addNodeToOptional((Selectable)selection)).orElseGet(() -> this.createPatternNode(context.getSubject(), (Selectable)selection, subjVar));
        if (linkNode instanceof UnionNode) {
            UnionNode unionNode = (UnionNode)linkNode;
            linkNode = new UnionCollection(Collections.singletonList(unionNode));
        }
        linkNode = this.addInFederatedBlockIfNeeded(selection, linkNode);
        subContext.setIterateOver(new SparqlBuilderContext.ExternalBinding(linkNode, context.getSubject()));
        SparqlBuilder subQueryBuilder = this.createBuilderCopy();
        subQuery.accept((OperationVisitor)subQueryBuilder, (OperationVisitorContext)subContext);
        return (SparqlNode)this.subSelectStrategy.apply(this, subQueryBuilder);
    }

    private SparqlNode addInFederatedBlockIfNeeded(Selection selection, SparqlNode linkNode) {
        PropertyShape propShape = selection.getProperty().orElse(null);
        String targetService = propShape != null && propShape.getInverseAlias() != null ? propShape.getRangeShape().getServiceAddress() : selection.getParent().getService();
        if (targetService != null) {
            linkNode = FederatedBlock.of(new Iri(targetService), linkNode);
        }
        return linkNode;
    }

    private SparqlBuilder createBuilderCopy() {
        return new SparqlBuilder(this.schema, this.queryOptimizer, this.filterFactory, this.subSelectStrategy, this.options);
    }

    private <T> List<T> extractAllMatchingClass(List<SparqlNode> allNodes, Class<T> clazz) {
        return allNodes.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    private java.util.Optional<SpecialPredicate> isSpecialPredicateSelection(Selectable selection) {
        return SpecialPredicates.get(selection.getName());
    }

    private UnaryOperator<SparqlNode> addFilters(Var subject, Selectable selection) {
        return node -> {
            if (Empty.INSTANCE.equals(node)) {
                return node;
            }
            if ("__typename".equals(selection.getName())) {
                return node;
            }
            if (selection.getArguments().getWhere().isPresent()) {
                TriplePatternBlock block = new TriplePatternBlock();
                block.addNode((SparqlNode)node);
                if (node instanceof PatternNode) {
                    this.addFilter((Var)((TriplePattern)node).getObject(), selection, block);
                } else {
                    this.addFilter(subject, selection, block);
                }
                return block;
            }
            return node;
        };
    }

    private UnaryOperator<SparqlNode> addNodeToOptional(Selectable selection) {
        return node -> {
            if (Empty.INSTANCE.equals(node)) {
                return node;
            }
            if (this.shouldAlwaysBeOutsideOfOptional(selection)) {
                return node;
            }
            if (!this.notLiteralOrder(selection)) {
                return new Optional((SparqlNode)node, false);
            }
            if (!this.nodeInOptional((SparqlNode)node) && !this.isLiteralValue(selection)) {
                return this.shouldPutInUnion(selection, (SparqlNode)node) ? new UnionNode((SparqlNode)node) : new Optional((SparqlNode)node, false);
            }
            if (node instanceof BoTypeFragment && selection.getArguments().isInheritedOrderBy()) {
                return new UnionExclusionSparqlNode((SparqlNode)node);
            }
            return node;
        };
    }

    private boolean shouldAlwaysBeOutsideOfOptional(Selectable selection) {
        if ("__typename".equals(selection.getName()) && !selection.isSubscription()) {
            return true;
        }
        if (selection.getDefinedInType().isSubClassOf("SubscriptionResponse")) {
            return true;
        }
        return selection.isRestrictive();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldPutInUnion(Selectable selection, SparqlNode node) {
        if (selection.isCollection()) return true;
        if (SparqlBuilder.isSelectionNameLiteral(selection)) return true;
        if (!this.isSelectionConsideredSingleValued(selection)) return true;
        if (!node.streamNodes().allMatch(BoTypeFragment.class::isInstance)) return false;
        return true;
    }

    private static boolean isSelectionNameLiteral(Selectable selection) {
        java.util.Optional propShape = selection.getProperty();
        return "name".equals(selection.getName()) && propShape.isPresent() && (((PropertyShape)propShape.get()).isMultivalued() || ((PropertyShape)propShape.get()).isLiteral());
    }

    private boolean isLiteralValue(Selectable selection) {
        return selection.getName().equals("value") && LITERAL.equals(selection.getDefinedIn());
    }

    private boolean nodeInOptional(SparqlNode node) {
        return node instanceof Optional || node instanceof BoTypeFragment || node instanceof UnionNode;
    }

    private void addProjections(Query parsedQuery) {
        this.bindings = new LinkedHashSet<Var>();
        Set usedVars = this.getUsedVars().stream().filter(var -> !(var instanceof HelperVar)).collect(Collectors.toSet());
        this.bindings.addAll(Var.sortVarsByDepth(new ArrayList<Var>(usedVars)));
        Set varNames = this.usedInOrderOnly.stream().map(Var::getName).collect(Collectors.toSet());
        this.bindings.removeIf(var -> varNames.contains(var.getName()));
        this.bindings.removeAll(this.usedInOrderOnly.stream().map(var -> new TempVar((Var)var, "so_type")).collect(Collectors.toSet()));
        this.bindings.removeIf(var -> var instanceof TempVar && this.bindings.stream().filter(var1 -> !(var1 instanceof TempVar)).anyMatch(var1 -> var1.getName().equals(var.getName())));
        if (parsedQuery.isCountSelection()) {
            Var rootProjection = this.createCountedVar(parsedQuery);
            Var countSelection = new Var(null, parsedQuery.getResponseName(), false);
            Count count = new Count(rootProjection, countSelection, (Boolean)parsedQuery.getArguments().getOrDefault((Object)"distinct", (Object)false));
            this.bindings.clear();
            this.bindings.add(countSelection);
            this.query.setProjectionSegment(Collections.singleton(count));
        } else if (parsedQuery.getArguments().isFromExplainGraph()) {
            Var countSelection = new Var(null, "plan", false);
            this.bindings.clear();
            this.bindings.add(countSelection);
        } else {
            this.query.setProjectionSegment(this.bindings);
        }
    }

    private Set<Var> getUsedVars() {
        return this.query.getWhereBlock().streamNodes().flatMap(this::getVars).collect(Collectors.toSet());
    }

    private void removeTempVars() {
        Stream.concat(this.query.getWhereBlock().streamNodes(), this.query.getOrderBy().stream()).flatMap(this::getVars).forEach(this.disableTempVar());
    }

    private Consumer<Var> disableTempVar() {
        return currentVar -> {
            if (currentVar instanceof TempVar) {
                TempVar tempVar = (TempVar)currentVar;
                tempVar.setAsNotTemporary();
            }
        };
    }

    private void optimizeSubQueries() {
        List<SparqlNode> patterns = this.query.getWhereBlock().getPatterns();
        if (patterns.stream().allMatch(SelectQuery.class::isInstance)) {
            Var binding;
            List subSelections;
            Map<Var, List<SelectQuery>> bindingToQuery = patterns.stream().map(SelectQuery.class::cast).filter(subQuery -> subQuery.getIterateOver() != null).collect(Collectors.groupingBy(subQuery -> subQuery.getIterateOver().getVar()));
            if (bindingToQuery.size() == 1 && (subSelections = bindingToQuery.getOrDefault(binding = bindingToQuery.keySet().iterator().next(), Collections.emptyList())).size() == patterns.size()) {
                List values = subSelections.stream().flatMap(subQuery -> subQuery.getWhereBlock().getPatterns().stream().flatMap(SparqlNodeSequence::flatten)).filter(SparqlFragment.class::isInstance).map(SparqlFragment.class::cast).map(node -> node.getBindValue(binding).orElse(null)).filter(Objects::nonNull).distinct().map(SimpleValue::new).collect(Collectors.toList());
                patterns.add(0, new Values(binding, values));
            }
        }
    }

    private boolean canTreatAsSingleField(Selectable selection) {
        return selection.getSelections().isEmpty() || this.isLiteral(selection) && !this.isUsedForOrder(selection) || selection.isCountSelection();
    }

    private boolean isUsedForOrder(Selectable selection) {
        if (selection.getArguments().containsKey((Object)"dir")) {
            return true;
        }
        return selection.getSelections().stream().anyMatch(selectable -> selectable.getArguments().containsKey((Object)"dir"));
    }

    private void addLimitAndOffset(Query parsedQuery) {
        Arguments arguments = parsedQuery.getArguments();
        arguments.getLimit().ifPresent(this.query::setLimit);
        arguments.getOffset().ifPresent(this.query::setOffset);
    }

    private void addOrder(Var subject, Selectable selectable) {
        List<Order> orders = Order.createOrderList(subject, selectable, OrderVariableBuilder::build, (orderVar, orderSelection) -> {
            if (orderSelection.getType().equals(LITERAL)) {
                this.usedInOrderOnly.add(new Var(orderVar.getParent(), orderSelection.getResponseName(), orderSelection.isCollection()));
            }
            if (this.areThereMultipleSelectionsForThisField((Selectable)orderSelection)) {
                return;
            }
            if (!"id".equals(orderSelection.getName())) {
                this.usedInOrderOnly.add((Var)orderVar);
            }
        }, this.query.getWhereBlock()::addNode);
        this.query.getOrderBy().addAll(orders);
    }

    private boolean areThereMultipleSelectionsForThisField(Selectable orderSelection) {
        return orderSelection.getParent() != null && orderSelection.getParent().getSelections().stream().filter(sel -> sel.getName().equals(orderSelection.getName())).count() > 1L;
    }

    private void addFilter(Var subject, Selectable selectable, TriplePatternBlock block) {
        if (selectable instanceof Subscription || !(selectable instanceof Operation) && selectable.isCountSelection()) {
            return;
        }
        java.util.Optional<FilterBuildResult> filterBuildResult = this.filterFactory.getFilterFromExistingBuilder(subject, selectable, this.filterBuilder);
        filterBuildResult.ifPresent(result -> block.addNode(result.getSparql()));
    }

    private Var getSubject(Query parsedQuery, SparqlBuilderContext sparqlContext) {
        Var subject = sparqlContext != null && sparqlContext.getSubject() != null ? sparqlContext.getSubject() : (parsedQuery.isCountSelection() ? this.createCountedVar(parsedQuery) : new Var(null, parsedQuery.getResponseName(), parsedQuery.isCollection()));
        return subject;
    }

    @NotNull
    private Var createCountedVar(Query parsedQuery) {
        return new Var(null, parsedQuery.getResponseName() + "_counted", true);
    }

    private boolean shouldCreateNewSubquery(Selection selection, boolean hasConstraints) {
        boolean isActualPropMultivalued;
        if (selection.getName().equals("id")) {
            return false;
        }
        if (selection.getName().equals("name") && this.isLiteral((Selectable)selection) && !this.isUsedForOrder((Selectable)selection) && this.containsLimitOrOffset(selection.getParent())) {
            return true;
        }
        if (selection.isComplexType() && selection.getService() == null && selection.getParent().getService() != null) {
            return true;
        }
        java.util.Optional propShape = selection.getProperty();
        boolean bl = isActualPropMultivalued = propShape.isPresent() && ((PropertyShape)propShape.get()).isMultivalued();
        if (!hasConstraints && !selection.hasDomainConstraints() && this.isSingleValuedFragment(selection) && this.isComplexSelectionUsedForOderOrCanBeTreatedAsSingleField(selection) && !isActualPropMultivalued && !selection.isCollection()) {
            return false;
        }
        if (!(!this.containsLimitOrOffset(selection.getParent()) || this.isLiteral((Selectable)selection) && this.isUsedForOrder((Selectable)selection))) {
            return true;
        }
        if (this.containsLimitOrOffset((Selectable)selection)) {
            return true;
        }
        if (this.containsOrder((Selectable)selection)) {
            return true;
        }
        return this.options.isForceLateralQueries() && isActualPropMultivalued && this.parentHasComplexFilter(selection) && !this.isSplitQueryUsed() && !selection.isRestrictive();
    }

    private boolean isSingleValuedFragment(Selection selection) {
        return !selection.isInFragment() || this.isUsedForOrder((Selectable)selection) || this.isSelectionConsideredSingleValued((Selectable)selection);
    }

    private boolean isComplexSelectionUsedForOderOrCanBeTreatedAsSingleField(Selection selection) {
        return this.canTreatAsSingleField((Selectable)selection) || this.isSelectionConsideredSingleValued((Selectable)selection) && this.isUsedForOrder((Selectable)selection);
    }

    private boolean parentHasComplexFilter(Selection selection) {
        return selection.getParent() != null && selection.getParent().getArguments().getWhere().filter(this::isComplexFilter).isPresent();
    }

    private boolean isComplexFilter(ExpressionValue<Object> expression) {
        return (Boolean)expression.accept((ExpressionVisitor)new AbstractExpressionVisitor<Boolean, ExpressionVisitorContext>(this){

            public Boolean visit(Node target, ExpressionVisitorContext context) {
                if (target.getPropertyShape().isObjectType()) {
                    return true;
                }
                return (Boolean)super.visit(target, context);
            }

            protected Boolean visitExpression(Expression target, ExpressionVisitorContext context) {
                return target.getTerms().stream().anyMatch(term -> (Boolean)term.accept((ExpressionVisitor)this, context));
            }

            protected Boolean visitExpressionTerm(ExpressionTerm target, ExpressionVisitorContext context) {
                return false;
            }
        }, null);
    }

    private Stream<Var> getVars(SparqlNode node) {
        return Stream.concat(node.streamNodes().filter(Var.class::isInstance).map(Var.class::cast), node.streamNodes().flatMap(this::getVars)).filter(var -> !(var instanceof FilterVar));
    }

    private boolean containsLimitOrOffset(Selectable selection) {
        return selection.getArguments().getLimit().isPresent() || selection.getArguments().getOffset().isPresent();
    }

    private boolean containsOrder(Selectable selection) {
        return selection.getArguments().getOrder().isPresent();
    }

    private void addLinkNode(Selection selection, PatternNode selectionNode, TriplePatternBlock block) {
        SparqlNode node = null;
        if (selectionNode instanceof TriplePattern) {
            TriplePattern pattern = (TriplePattern)selectionNode;
            if (selection.isPassThrough()) {
                node = new Bind(pattern.getSubject(), pattern.getObject());
            } else {
                pattern.setRestrictive(true);
                node = pattern;
            }
        } else if (selectionNode instanceof SparqlFragment) {
            selectionNode.setRestrictive(true);
            node = selectionNode;
        }
        if (node != null) {
            Shape rangeShape;
            PropertyShape propShape = selection.getProperty().orElse(null);
            if (propShape != null && propShape.getInverseAlias() != null && (rangeShape = propShape.getRangeShape()) != null && rangeShape.getServiceAddress() != null) {
                node = FederatedBlock.of(new Iri(rangeShape.getServiceAddress()), node);
            }
            block.addNode(node);
        }
    }

    private boolean isLiteral(Selectable selection) {
        return selection.getProperty().filter(PropertyShape::isLiteral).isPresent();
    }

    private void optimize() {
        if (this.queryOptimizer != null) {
            this.queryOptimizer.optimize(this.query);
        }
        this.query.getWhereBlock().getPatterns().removeIf(node -> {
            TriplePatternBlock block;
            return node instanceof TriplePatternBlock && (block = (TriplePatternBlock)node).getPatterns().isEmpty();
        });
    }

    private void generateIdConstrain(TriplePatternBlock parentBlock, Selectable selectable, Var object) {
        Arguments arguments = selectable.getArguments();
        if (arguments != null) {
            List ids = arguments.getId().orElse(Collections.emptyList());
            if (ids.size() == 1) {
                parentBlock.addNodeFirst(new Values(object, Collections.singletonList(new Iri(this.toRelativeIri((String)ids.get(0))))));
            } else if (!ids.isEmpty()) {
                parentBlock.addNodeFirst(new Values(object, ids.stream().map(this::toRelativeIri).map(Iri::new).collect(Collectors.toList())));
            }
        }
    }

    private void generateBoTypeConstraints(TriplePatternBlock parentBlock, Selectable selectable, Var subject) {
        if (selectable instanceof Subscription) {
            return;
        }
        boolean hasTypeConstraints = selectable.hasConstraints() && selectable.getConstraints().hasTypeConstraints();
        Set<Constraint> typeConstraints = this.getTypeConstraints(selectable, hasTypeConstraints);
        LinkedList<SparqlNode> constraints = new LinkedList<SparqlNode>();
        if (this.willSoTypeBeNeeded(selectable, hasTypeConstraints)) {
            if (this.isIdPropertyInService(selectable)) {
                parentBlock.addNode(new Bind(Literal.asString(selectable.getType()), new Var(subject, "so_type")));
            } else {
                this.constraintGenerator.addBoTypeConstraint(typeConstraints, constraints, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(subject).boTypeAlias(BoType.getAlias(selectable)).filterGenerator(this.filterGenerator(subject)).service(selectable.getService()).soTypeOptimizationThreshold(this.options.getSoTypeOptimizationThreshold()).setSinglePredicateTypeOptimization(this.options.isSingleSoTypeOptimizationEnabled()).build());
            }
        }
        if (!constraints.isEmpty()) {
            if (this.isInSubscription(selectable)) {
                parentBlock.addNode(new Optional(new SparqlNodeSequence(constraints)));
            } else {
                parentBlock.addAll(constraints);
            }
        }
    }

    private Set<Constraint> getTypeConstraints(Selectable selectable, boolean hasTypeConstraints) {
        Set typeConstraints;
        if (hasTypeConstraints) {
            typeConstraints = selectable.getConstraints().getTypeConstraints();
        } else if (selectable.isCountSelection() && selectable instanceof Operation) {
            Operation operation = (Operation)selectable;
            Shape shape = (Shape)operation.getCountedType().orElseThrow();
            typeConstraints = shape.isUnion() ? Constraints.fromShapeIds(shape.getUnionOfShapes().stream().map(Shape::getId).collect(Collectors.toSet())) : Constraints.fromShapeIds((String[])new String[]{shape.getId()});
        } else if (selectable.getShapeType().filter(Shape::isUnion).isPresent()) {
            Set<String> unionMembers = ((Shape)selectable.getShapeType().orElseThrow()).getUnionOfShapes().stream().map(Shape::getId).collect(Collectors.toSet());
            typeConstraints = Constraints.fromShapeIds((String[])((String[])selectable.getSelections().stream().map(Selectable::getDefinedInType).filter(type -> !type.isUnion()).flatMap(this.toAllowedSelectionForUnion(unionMembers)).map(Shape::getId).distinct().toArray(String[]::new)));
            if (typeConstraints.isEmpty() && selectable.getSelections().stream().anyMatch(Selectable.byName((String)"__typename"))) {
                typeConstraints = selectable.getShapeType().map(Shape::getConcreteSubTypes).map(collection -> Constraints.fromShapeIds(collection.stream().map(Shape::getId).collect(Collectors.toSet()))).orElse(Set.of());
            }
        } else {
            typeConstraints = Constraints.fromShapeIds((String[])new String[]{this.schema.getPrefixes().nameToShortIri(selectable.getType())});
        }
        return typeConstraints;
    }

    private Function<Shape, Stream<Shape>> toAllowedSelectionForUnion(Set<String> unionMembers) {
        return type -> {
            if (type.isAbstract()) {
                return type.getSubTypes().stream().filter(subType -> unionMembers.contains(subType.getId()));
            }
            return Stream.of(type);
        };
    }

    private boolean isIdPropertyInService(Selectable selectable) {
        if (selectable instanceof Selection && selectable.getService() != null) {
            return selectable.getSelections().stream().allMatch(sel -> sel.getName().equals("id") || sel.getName().equals("__typename"));
        }
        return false;
    }

    private boolean isInSubscription(Selectable selectable) {
        Selectable offer = selectable;
        while (!(offer instanceof Subscription) && offer.getParent() != null) {
            offer = offer.getParent();
        }
        return offer instanceof Subscription;
    }

    private boolean willSoTypeBeNeeded(Selectable selectable, boolean hasTypeConstraints) {
        return selectable.getSelections().stream().anyMatch(subSel -> subSel.getName().equals("__typename")) || selectable.getSelections().stream().anyMatch(Selectable::isInFragment) || selectable.isRangeCheck() || hasTypeConstraints || selectable.getSelections().stream().anyMatch(sel -> sel.hasConstraints() && sel.getConstraints().hasFragmentConstraints()) || selectable.getSelections().stream().anyMatch(subSel -> subSel.getName().equals("name")) && BoName.isThereConcreteSubtypesWithDifferentName((Shape)selectable.getShapeType().orElseThrow());
    }

    Function<ActionFilter, java.util.Optional<SparqlNode>> filterGenerator(Var subject) {
        return FilterFactory.filterGenerator(subject, this.filterBuilder);
    }

    private void generateFragmentConstraints(TriplePatternBlock parentBlock, Query parsedQuery, Var subject) {
        if (!(parsedQuery.hasConstraints() && parsedQuery.getConstraints().hasFragmentConstraints() || parsedQuery.hasDomainConstraints())) {
            return;
        }
        LinkedList constraints = new LinkedList();
        boolean hasConstraints = parsedQuery.hasConstraints() && parsedQuery.getConstraints().hasFragmentConstraints();
        this.getFragmentTypeConstraints((Selectable)parsedQuery, hasConstraints).ifPresent(fragmentTypeConstraints -> this.constraintGenerator.addBoTypeConstraint((Set<Constraint>)fragmentTypeConstraints, constraints, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(subject.getParent()).boTypeAlias(BoType.getAlias((Selectable)parsedQuery)).filterGenerator(this.filterGenerator(subject.getParent())).service(parsedQuery.getService()).soTypeOptimizationThreshold(this.options.getSoTypeOptimizationThreshold()).setSinglePredicateTypeOptimization(this.options.isSingleSoTypeOptimizationEnabled()).build()));
        if (!constraints.isEmpty()) {
            parentBlock.addAll(constraints);
        }
    }

    protected PatternNode createTriplePattern(Selectable selection, Var subject) {
        return this.patternBuilder.createTriplePattern(selection, subject);
    }

    @NotNull
    private PatternNode createPatternNode(Var subject, Selectable selection, Var object) {
        return this.patternBuilder.createPatternNode(subject, selection, object, false);
    }

    protected void addBase() {
        this.schema.getSpecialPrefixes().getBaseIri().map(Base::new).ifPresent(this.query::setBase);
    }

    protected void addPrefixes() {
        this.query.getUsedPrefixes().distinct().sorted().filter(arg_0 -> this.schema.getPrefixes().containsKey(arg_0)).map(pref -> new Prefix((String)pref, (String)this.schema.getPrefixes().get(pref))).forEach(this.query.getPrefixes()::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationResult getQuery() {
        try {
            SparqlCompilationResult result = new SparqlCompilationResult();
            if (this.mutationQueries != null) {
                this.mutationQueries.getSteps().forEach(result::add);
            }
            if (this.query != null) {
                String compiledQuery = this.query.toSparql();
                SparqlCompilationResult.Builder<CompilationResult> rootQueryResult = result.addStep().addQuery(compiledQuery).addBindings(this.bindings);
                for (SparqlBuilder subQuery : this.subQueries) {
                    subQuery.getExecutionStep(rootQueryResult);
                }
                CompilationResult compilationResult = rootQueryResult.register();
                return compilationResult;
            }
            SparqlCompilationResult sparqlCompilationResult = new SparqlCompilationResult();
            return sparqlCompilationResult;
        }
        finally {
            SparqlFragment.resetVariableOffset();
        }
    }

    private <P> void getExecutionStep(SparqlCompilationResult.Builder<P> parentBuilder) {
        SparqlCompilationResult.Builder<SparqlCompilationResult.Builder<P>> subBuilder = parentBuilder.addSubExecution().addQueryBuilder(this.buildQuery(this.query)).addBindings(this.bindings);
        for (SparqlBuilder subQuery : this.subQueries) {
            subQuery.getExecutionStep(subBuilder);
        }
        subBuilder.register();
    }

    private Function<PreviousExecution, String> buildQuery(SelectQuery query) {
        return execution -> {
            if (query.getIterateOver() != null) {
                if (execution.getRdfTree() == null) {
                    throw new IllegalArgumentException("Could not generate next query as previous query failed!");
                }
                this.fillValues((PreviousExecution)execution, query.getIterateOver());
            }
            return query.toSparql();
        };
    }

    private void fillValues(PreviousExecution execution, Values value) {
        String[] path = this.getPreviousResultPath(execution, value);
        execution.getRdfTree().getPath(path).stream().map(String.class::cast).filter(SparqlBuilder.nonResultValue()).map(this::toRelativeIri).map(Iri::new).forEach(value.getValues()::add);
    }

    private String[] getPreviousResultPath(PreviousExecution execution, Values value) {
        String queryName = SparqlBuilder.getQueryName(execution.getRdfTree());
        Prefixes prefixes = this.schema.getPrefixes();
        LinkedList<String> path = new LinkedList<String>();
        for (Var current = value.getVar(); current != null; current = current.getParent()) {
            if (current.getName().equals(queryName)) {
                path.addFirst(queryName);
                break;
            }
            path.addFirst(prefixes.toIri(current.getLocalName()));
        }
        return path.toArray(new String[0]);
    }

    private static String getQueryName(RdfTree data) {
        Collection queries = data.getQueries();
        if (queries.size() > 1) {
            throw new IllegalArgumentException("Previous data is expected to be from 1 query, but he number of queries is " + queries.size());
        }
        if (queries.isEmpty()) {
            return null;
        }
        return (String)queries.iterator().next();
    }

    protected String toRelativeIri(String id) {
        return this.schema.getPrefixes().toRelativeIri(id);
    }

    private static Predicate<String> nonResultValue() {
        return val -> !RES.equals(val);
    }

    public static enum SubSelectStrategy implements BiFunction<SparqlBuilder, SparqlBuilder, SparqlNode>
    {
        SPLIT_QUERY{

            @Override
            public SparqlNode apply(SparqlBuilder parent, SparqlBuilder child) {
                parent.subQueries.add(child);
                return Empty.INSTANCE;
            }
        }
        ,
        SUB_SELECT{

            @Override
            public SparqlNode apply(SparqlBuilder parent, SparqlBuilder child) {
                child.query.convertToSubSelect();
                return child.query;
            }
        };

    }
}

