/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.EntityCreateSparqlGenerator;
import com.ontotext.graphql.compiler.EntityDeleteSparqlGenerator;
import com.ontotext.graphql.compiler.EntityUpdateSparqlGenerator;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.MutationVisitorContext;
import com.ontotext.graphql.compiler.SparqlCompilationResult;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.models.OperationVisitor;
import com.ontotext.models.OperationVisitorContext;
import com.ontotext.models.Selection;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Query;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.soaas.common.sparql.CompilationResult;
import com.ontotext.soaas.common.sparql.OperationBuilder;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.function.Supplier;

class MutationSparqlGenerator
implements OperationVisitor<CompilationResult, MutationVisitorContext> {
    private final OperationBuilderOptions.MutationMode mutationMode;
    private final EntityCreateSparqlGenerator createSparqlGenerator;
    private final EntityUpdateSparqlGenerator updateSparqlGenerator;
    private final EntityDeleteSparqlGenerator deleteSparqlGenerator;

    MutationSparqlGenerator(SomlSchema schema, OperationBuilderOptions.MutationMode mutationMode, FilterFactory filterFactory, OperationBuilderOptions options) {
        this.mutationMode = mutationMode;
        this.createSparqlGenerator = new EntityCreateSparqlGenerator(schema, options, filterFactory);
        this.updateSparqlGenerator = new EntityUpdateSparqlGenerator(schema, options, filterFactory);
        this.deleteSparqlGenerator = new EntityDeleteSparqlGenerator(schema, options, filterFactory);
    }

    public CompilationResult generate(Mutation mutation, Supplier<OperationBuilder> queryBuilder) {
        return (CompilationResult)mutation.accept((OperationVisitor)this, (OperationVisitorContext)new MutationVisitorContext(queryBuilder));
    }

    private void checkIfMutationsAreAllowed() {
        if (this.mutationMode == OperationBuilderOptions.MutationMode.READ_ONLY) {
            throw new IllegalArgumentException("Mutations are not allowed in " + String.valueOf(this.mutationMode) + " mode!");
        }
    }

    public CompilationResult visit(Query query, MutationVisitorContext context) {
        throw new UnsupportedOperationException();
    }

    public CompilationResult visit(Selection selection, MutationVisitorContext context) {
        throw new UnsupportedOperationException();
    }

    public CompilationResult visit(CreateMutation mutation, MutationVisitorContext context) {
        this.checkIfMutationsAreAllowed();
        SparqlCompilationResult compilationResult = new SparqlCompilationResult();
        for (SparqlNode node : this.createSparqlGenerator.generate(mutation)) {
            compilationResult.addStep().addUpdate(node.toSparql()).register();
        }
        return compilationResult;
    }

    public CompilationResult visit(UpdateMutation mutation, MutationVisitorContext context) {
        this.checkIfMutationsAreAllowed();
        return this.updateSparqlGenerator.generate(mutation);
    }

    public CompilationResult visit(DeleteMutation deleteMutation, MutationVisitorContext context) {
        this.checkIfMutationsAreAllowed();
        SparqlCompilationResult compilationResult = new SparqlCompilationResult();
        for (SparqlNode node : this.deleteSparqlGenerator.generate(deleteMutation)) {
            compilationResult.addStep().addUpdate(node.toSparql()).register();
        }
        return compilationResult;
    }

    public CompilationResult visit(Subscription subscription, MutationVisitorContext context) {
        throw new UnsupportedOperationException();
    }
}

