/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.querymodel.FilterVar;
import com.ontotext.graphql.compiler.querymodel.Var;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class FilterVarProvider {
    private Map<Object, Integer> varMap = new HashMap<Object, Integer>();
    private final int initialVarIndex;

    FilterVarProvider() {
        this(1);
    }

    FilterVarProvider(int initialVarIndex) {
        this.initialVarIndex = initialVarIndex;
    }

    FilterVar getNewVar(Var var) {
        Integer currentId = this.varMap.compute(var.getName(), (key, value) -> {
            if (value == null) {
                return this.initialVarIndex;
            }
            return value + 1;
        });
        return new FilterVar(var.getParent(), var.getLocalName(), currentId);
    }

    Optional<Var> getExistingVar(Var var) {
        Integer currentId = this.varMap.get(var.getName());
        if (currentId != null) {
            return Optional.of(new FilterVar(var.getParent(), var.getLocalName(), currentId));
        }
        return Optional.empty();
    }
}

