/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.EntityUpdateSparqlGenerator;
import com.ontotext.graphql.compiler.FilterBuildResult;
import com.ontotext.graphql.compiler.FilterBuilder;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.ActionFilter;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.FilteredSelection;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class FilterFactory {
    @NotNull
    public static FilterBuilder getFilterBuilder(ConstraintGenerator constraintGenerator, SomlSchema schema, OperationBuilderOptions options, FilterFactory filterFactory) {
        return new FilterBuilder(schema, constraintGenerator, options, filterFactory);
    }

    @NotNull
    public static FilterBuilder getFilterBuilder(SomlSchema schema, OperationBuilderOptions options, FilterFactory filterFactory) {
        return FilterFactory.getFilterBuilder(new ConstraintGenerator(schema, options), schema, options, filterFactory);
    }

    public Optional<FilterBuildResult> getFilter(Var subject, Selectable selectable, ConstraintGenerator constraintGenerator, OperationBuilderOptions options) {
        SomlSchema schema = selectable.getDefinedInType().getContainedIn().getContainedIn();
        FilterBuilder filterBuilder = FilterFactory.getFilterBuilder(constraintGenerator, schema, options, this);
        return this.buildQueryFilter(subject, selectable, filterBuilder);
    }

    FilterBuildResult getMutationFilter(Var subject, Shape shape, FilteredSelection filter, String blankSuffix, OperationBuilderOptions options) {
        SomlSchema schema = shape.getContainedIn().getContainedIn();
        FilterBuilder filterBuilder = FilterFactory.getFilterBuilder(new ConstraintGenerator(schema, options), schema, options, this);
        return this.buildMutationFilter(shape, subject, filter, filterBuilder, blankSuffix);
    }

    public Optional<FilterBuildResult> getFilterFromExistingBuilder(Var subject, Selectable selectable, FilterBuilder filterBuilder) {
        FilterBuilder newFilterBuilder = new FilterBuilder(filterBuilder);
        return this.buildQueryFilter(subject, selectable, newFilterBuilder);
    }

    static Function<ActionFilter, Optional<SparqlNode>> filterGenerator(Var subject, FilterBuilder filterBuilder) {
        return filter -> {
            if (filter == null) {
                return Optional.empty();
            }
            FilterBuilder.Context context = new FilterBuilder.Context(subject, (Selectable)filter.getSelections().get(0));
            SparqlNode sparql = (SparqlNode)filter.getFilter().accept((ExpressionVisitor)filterBuilder, (ExpressionVisitorContext)context);
            return Optional.of(sparql);
        };
    }

    private Optional<FilterBuildResult> buildQueryFilter(Var subject, Selectable selectable, FilterBuilder filterBuilder) {
        Optional expression = selectable.getArguments().getWhere();
        if (!expression.isPresent()) {
            return Optional.empty();
        }
        ExpressionValue exprValue = (ExpressionValue)expression.get();
        FilterBuilder.Context context = new FilterBuilder.Context(subject, selectable);
        SparqlNode filter = (SparqlNode)exprValue.accept((ExpressionVisitor)filterBuilder, (ExpressionVisitorContext)context);
        return Optional.of(new FilterBuildResult(filter, filterBuilder));
    }

    private FilterBuildResult buildMutationFilter(Shape shape, Var subject, FilteredSelection filteredSelection, FilterBuilder filterBuilder, String blankSuffix) {
        ExpressionValue expressionValue = filteredSelection.getExpression();
        Selectable selection = filteredSelection.getSelection();
        if (selection == null) {
            throw new IllegalArgumentException("Missing selection for mutation filter: " + String.valueOf(expressionValue));
        }
        FilterBuilder.Context context = new FilterBuilder.Context(subject, selection);
        SparqlNode filter = (SparqlNode)expressionValue.accept((ExpressionVisitor)filterBuilder, (ExpressionVisitorContext)context);
        if (context.needsBlankNode()) {
            SparqlNodeSequence sequence = new SparqlNodeSequence();
            Var subjectVar = subject.getName().startsWith(EntityUpdateSparqlGenerator.ENTITY_IRI_VAR.getName()) ? subject : EntityUpdateSparqlGenerator.ENTITY_IRI_VAR;
            sequence.add(new TriplePattern((Value)subjectVar, (Value)new Iri(shape.getTypeProp()), new Iri("_:blank" + blankSuffix)));
            sequence.add(filter);
            return new FilterBuildResult(sequence, filterBuilder);
        }
        return new FilterBuildResult(filter, filterBuilder);
    }
}

