/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.FilterBuilder;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.Bound;
import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.Equals;
import com.ontotext.graphql.compiler.querymodel.FederatedBlock;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.FilterVar;
import com.ontotext.graphql.compiler.querymodel.In;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.SparqlFragment;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.TempVar;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Union;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.ActionFilter;
import com.ontotext.models.Constraint;
import com.ontotext.models.Constraints;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.ExpressionsFactory;
import com.ontotext.models.query.Node;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintGenerator {
    public static final String HIDE = "_hide";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstraintGenerator.class);
    private static final Predicate<Constraint> NOT_LITERAL = constr -> !"Literal".equals(constr.getShapeId());
    private static final int DEFAULT_FILTER_VAR_IDX = 0;
    public static final String NO_SERVICE = "%no_service%";
    private final SomlSchema schema;
    private final OperationBuilderOptions options;
    private final Map<String, List<Iri>> typeMap;
    private final Map<String, List<Shape>> subTypes;

    public ConstraintGenerator(SomlSchema schema, OperationBuilderOptions options) {
        this.schema = schema;
        this.options = options;
        this.typeMap = new HashMap<String, List<Iri>>();
        this.subTypes = new HashMap<String, List<Shape>>();
    }

    public void addBoTypeConstraint(Set<Constraint> boTypes, List<SparqlNode> constraints, SparqlBuildingContext context) {
        Set<Constraint> filteredTypes = this.filter(boTypes);
        if (filteredTypes.isEmpty()) {
            return;
        }
        Var typeVar = (Var)context.varProcessor.apply(new TempVar(context.subject, context.boTypeAlias));
        if (filteredTypes.size() > 1) {
            this.oneOfMultipleTypes(constraints::add, typeVar, filteredTypes, context);
        } else {
            Constraint type = filteredTypes.iterator().next();
            this.handleShape(constraints::add, typeVar, type, context);
        }
    }

    private Set<Pair<List<Shape>, Constraint>> expand(Collection<Constraint> filteredTypes) {
        Set allShapes = filteredTypes.stream().map(Constraint::getShapeId).collect(Collectors.toSet());
        Set expanded = filteredTypes.stream().map(constraint -> {
            Shape shape = (Shape)this.schema.getObjects().get((Object)constraint.getShapeId());
            if (shape.isAbstract() || shape.isUnion()) {
                return Pair.of(this.getConcreteSubTypes(shape.getId()).stream().filter((? super T subShape) -> !allShapes.contains(subShape.getId())).toList(), (Object)constraint);
            }
            return Pair.of(Collections.singletonList(shape), (Object)constraint);
        }).collect(Collectors.toCollection(LinkedHashSet::new));
        Map<ExpressionValue, List<Pair>> groupByFilter = expanded.stream().filter((? super T pair) -> ((Constraint)pair.getValue()).getFilter() != null).collect(Collectors.groupingBy(pair -> ((Constraint)pair.getValue()).getFilter().getFilter()));
        for (List<Pair> commonFilter : groupByFilter.values()) {
            if (commonFilter.size() <= 1) continue;
            commonFilter.stream().reduce((left, right) -> Pair.of(Stream.concat(((List)left.getLeft()).stream(), ((List)right.getLeft()).stream()).distinct().toList(), (Object)((Constraint)left.getRight()))).ifPresent(pair -> {
                commonFilter.forEach(expanded::remove);
                expanded.add(pair);
            });
        }
        return expanded;
    }

    public SparqlNode generateExcludeSelection(Selectable selection, Var subject, FilterBuilder filterBuilder) {
        return this.generateExcludeSelection(selection, subject, selection.getName().equals("id") ? "" : selection.getName(), filterBuilder);
    }

    public SparqlNode generateExcludeSelection(Selectable selection, Var subject, String object, FilterBuilder filterBuilder) {
        Set constraints = selection.getConstraints().getFragmentConstraints();
        SparqlNode excludeByFilters = this.generateExclusionBlockForTheFilters(subject, object, constraints, filterBuilder);
        if (Constraints.constrainOnlyByFilters((Collection)constraints, (Shape)selection.getDefinedInType())) {
            return excludeByFilters;
        }
        SparqlNode excludeBySoType = this.generateExclusionBlockForSoTypes(selection, subject, object, constraints);
        SparqlNodeSequence combined = new SparqlNodeSequence();
        combined.add(excludeBySoType);
        combined.add(excludeByFilters);
        return combined;
    }

    @NotNull
    private SparqlNode generateExclusionBlockForTheFilters(Var subject, String object, Set<Constraint> constraints, FilterBuilder filterBuilder) {
        HashSet uniqueExpressions = new HashSet();
        LinkedList<SparqlNode> sparql = new LinkedList<SparqlNode>();
        constraints.forEach(constraint -> {
            if (constraint.getFilter() != null && !uniqueExpressions.contains(constraint.getFilter().getFilter())) {
                uniqueExpressions.add(constraint.getFilter().getFilter());
                ActionFilter filter = constraint.getFilter();
                SparqlNode sparqlNode = this.createFilter(subject, filterBuilder, filter);
                sparql.add(sparqlNode);
            }
        });
        if (sparql.isEmpty()) {
            return Empty.INSTANCE;
        }
        sparql.add(new Bind(new Literal("true"), new Var(subject, HIDE + object)));
        return new Optional(new SparqlNodeSequence(sparql));
    }

    private SparqlNode generateExclusionBlockForSoTypes(Selectable selection, Var subject, String object, Set<Constraint> constraints) {
        Set excludedTypes = selection.getDefinedInType().getConcreteSubTypes().stream().filter((? super T shape) -> shape.isSynthetic() == false && !shape.isSystem()).map(Shape::getId).collect(Collectors.toSet());
        constraints.forEach(constraint -> excludedTypes.remove(constraint.getShapeId()));
        if (selection.getParent() != null && selection.getParent().hasConstraints() && selection.getParent().getConstraints().hasTypeConstraints()) {
            Set possibleTypes = selection.getParent().getConstraints().getTypeConstraints().stream().map(Constraint::getShapeId).collect(Collectors.toSet());
            excludedTypes.removeIf(type -> !possibleTypes.contains(type));
        }
        if (excludedTypes.isEmpty()) {
            return Empty.INSTANCE;
        }
        LinkedList<SparqlNode> sparql = new LinkedList<SparqlNode>();
        this.addBoTypeConstraint(Constraints.fromShapeIds(excludedTypes), sparql, SparqlBuildingContext.contextBuilder().subject(subject).boTypeAlias("_ignore").service(selection.getService()).build());
        sparql.add(new Bind(new Literal("true"), new Var(subject, HIDE + object)));
        return new Optional(new SparqlNodeSequence(sparql));
    }

    private SparqlNode createFilter(Var object, FilterBuilder filterBuilder, ActionFilter actionFilter) {
        FilterBuilder.Context context = new FilterBuilder.Context(object, (Selectable)actionFilter.getSelections().getFirst());
        ExpressionValue<?> exprFilter = this.negate(actionFilter.getFilter());
        return (SparqlNode)exprFilter.accept((ExpressionVisitor)filterBuilder, (ExpressionVisitorContext)context);
    }

    private ExpressionValue<?> negate(ExpressionValue<?> filter) {
        if (filter instanceof Node) {
            Node node = (Node)filter.deepCopy();
            node.setSubExpression(ExpressionsFactory.not().addTerm((ExpressionTerm)node.getValue()));
            return node;
        }
        return ExpressionsFactory.not().addTerm((ExpressionTerm)ExpressionsFactory.exists().addTerm((ExpressionTerm)filter));
    }

    private void handleShape(Consumer<SparqlNode> nodeConsumer, Var typeVar, Constraint type, SparqlBuildingContext context) {
        Shape shape = (Shape)this.schema.getObjects().get((Object)type.getShapeId());
        if (shape.isAbstract() || shape.isUnion()) {
            this.handleAbstract(shape, nodeConsumer, typeVar, context);
        } else if (context.isSinglePredicateTypeOptimizationEnabled()) {
            TriplePatternBlock block = new TriplePatternBlock();
            this.handleNonAbstract(shape, block::addNode, typeVar, context);
            Union union = new Union();
            union.addNode(block);
            SparqlNode node = this.optimizeTypeSelectionUnion(union, context);
            if (node instanceof Union) {
                Union un = (Union)node;
                un.getNodes().stream().flatMap(SparqlNode::streamNodes).forEach(nodeConsumer);
            } else if (node instanceof SparqlNodeSequence || node.getClass().equals(TriplePatternBlock.class)) {
                node.streamNodes().forEach(nodeConsumer);
            } else {
                nodeConsumer.accept(node);
            }
        } else {
            this.handleNonAbstract(shape, nodeConsumer, typeVar, context);
        }
        context.filterGenerator.apply(type.getFilter()).ifPresent(nodeConsumer);
    }

    private Set<Constraint> filter(Set<Constraint> boTypes) {
        return boTypes.stream().filter(NOT_LITERAL).filter(this::isTypeApplicableAsConstraint).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private boolean isTypeApplicableAsConstraint(Constraint contr) {
        Shape shape = (Shape)this.schema.getObjects().get((Object)contr.getShapeId());
        if (shape == null) {
            return false;
        }
        return shape.isAbstract() || shape.isUnion() || !shape.isIgnoredType();
    }

    private void handleAbstract(Shape shape, Consumer<SparqlNode> nodesConsumer, Var typeVar, SparqlBuildingContext context) {
        Collection<Shape> childTypes = this.getConcreteSubTypes(shape.getId());
        if (childTypes.isEmpty()) {
            LOGGER.warn("Could not find concrete types for the shape {}", (Object)shape);
            return;
        }
        if (this.canPreFetchedSoTypeBeUsed(context)) {
            nodesConsumer.accept(this.filterSoTypeInOneOfShapes(context, childTypes));
        } else {
            this.oneOfMultipleTypes(nodesConsumer, typeVar, Constraints.fromShapeIds((Set)childTypes.stream().map(Shape::getId).collect(Collectors.toCollection(LinkedHashSet::new))), context);
        }
    }

    private boolean canPreFetchedSoTypeBeUsed(SparqlBuildingContext context) {
        return context.soTypePresent && (!context.serviceAware || !context.service.isPresent());
    }

    @NotNull
    private Filter filterSoTypeInOneOfShapes(SparqlBuildingContext context, Collection<Shape> subTypes) {
        return this.buildFilter(context.newSoTypeVar(), subTypes.stream().filter((? super T child) -> child.isSynthetic() == false && !child.isSystem()).flatMap(this::shapeToIdLiteralOptimized).toList());
    }

    private Stream<Value> shapeToIdLiteralOptimized(Shape shape) {
        Stream.Builder<Value> builder = Stream.builder();
        if (shape.isTypePropRdfType()) {
            for (String type : shape.getTypeAsList()) {
                builder.add(new Iri(type));
            }
        }
        return builder.add(this.shapeToIdLiteral(shape)).build();
    }

    private Literal shapeToIdLiteral(Shape shape) {
        return Literal.asString(shape.asGraphQl());
    }

    private void oneOfMultipleTypes(Consumer<SparqlNode> nodesConsumer, Var typeVar, Collection<Constraint> subTypes, SparqlBuildingContext context) {
        if (this.canPreFetchedSoTypeBeUsed(context) && subTypes.stream().allMatch(constraint -> constraint.getFilter() == null)) {
            nodesConsumer.accept(this.filterSoTypeInOneOfShapes(context, this.flatToConcreteClasses(subTypes)));
        } else {
            this.oneOfMultipleTypesWithSoTypeCollection(nodesConsumer, typeVar, subTypes, context);
        }
    }

    private Set<Shape> flatToConcreteClasses(Collection<Constraint> subTypes) {
        return subTypes.stream().map(Constraint::getShapeId).map(arg_0 -> this.schema.getObjects().get(arg_0)).flatMap(shape -> {
            if (shape.isAbstract() || shape.isUnion()) {
                return shape.getConcreteSubTypes().stream().filter((? super T child) -> !child.isSystem() && child.isSynthetic() == false);
            }
            return Stream.of(shape);
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void oneOfMultipleTypesWithSoTypeCollection(Consumer<SparqlNode> nodesConsumer, Var typeVar, Collection<Constraint> subTypes, SparqlBuildingContext context) {
        Union union = new Union();
        for (Pair<List<Shape>, Constraint> constraintTypes : this.expand(subTypes)) {
            Constraint constraint = (Constraint)constraintTypes.getRight();
            TriplePatternBlock tripleBlock = new TriplePatternBlock();
            List subTypeShapes = (List)constraintTypes.getLeft();
            if (subTypeShapes.size() == 1) {
                this.handleNonAbstract((Shape)subTypeShapes.getFirst(), tripleBlock::addNode, typeVar, context);
            } else if (!subTypeShapes.isEmpty()) {
                Union typesUnion = new Union();
                for (Shape subType : subTypeShapes) {
                    TriplePatternBlock block = new TriplePatternBlock();
                    this.handleNonAbstract(subType, block::addNode, typeVar, context);
                    typesUnion.addNode(block);
                }
                SparqlNode node = this.optimizeTypeSelectionUnion(typesUnion, context);
                node = this.optimizeReusedTypeSelectionUnion(node, context);
                tripleBlock.addNode(node);
            }
            context.filterGenerator.apply(constraint.getFilter()).ifPresent(tripleBlock::addNode);
            if (tripleBlock.getPatterns().isEmpty()) continue;
            union.addNode(tripleBlock);
        }
        SparqlNode node = this.optimizeTypeSelectionUnion(union, context);
        if ((node = this.optimizeReusedTypeSelectionUnion(node, context)) instanceof Union) {
            Union uni = (Union)node;
            this.addUnionNode(nodesConsumer, typeVar, uni, context);
        } else if (node.getClass().equals(TriplePatternBlock.class)) {
            node.streamNodes().forEach(nodesConsumer);
        } else {
            nodesConsumer.accept(node);
        }
    }

    private void addUnionNode(Consumer<SparqlNode> nodesConsumer, Var typeVar, Union union, SparqlBuildingContext context) {
        List<SparqlNode> nodes = union.getNodes().stream().filter(Empty.notEmpty()).filter((? super T item) -> !item.getClass().equals(TriplePatternBlock.class) || !((TriplePatternBlock)item).getPatterns().isEmpty()).toList();
        if (nodes.size() == 1) {
            SparqlNode sparqlNode = nodes.getFirst();
            if (sparqlNode.getClass().equals(TriplePatternBlock.class)) {
                nodesConsumer.accept(((TriplePatternBlock)sparqlNode).asSequence());
            } else {
                nodesConsumer.accept(sparqlNode);
            }
        } else {
            nodesConsumer.accept(union);
            if (context.requireSoTypeExport) {
                nodesConsumer.accept(new Filter(new Bound(typeVar)));
            }
        }
    }

    private SparqlNode optimizeTypeSelectionUnion(Union union, SparqlBuildingContext context) {
        if (!context.isTypePatternOptimizationsEnabled()) {
            return union;
        }
        List<UnionTypeOptimization> optimizations = this.analyzeUnion(union, context);
        if (optimizations.size() == 1) {
            return optimizations.getFirst().optimize();
        }
        Union optimizedUnion = new Union();
        optimizations.stream().map(UnionTypeOptimization::optimize).forEach(optimizedUnion::addNode);
        return optimizedUnion;
    }

    private static SparqlNode wrapInFederatedBlockIfNeeded(String service, SparqlNode node) {
        if (service.equals(NO_SERVICE)) {
            return node;
        }
        return FederatedBlock.of(new Iri(service), node);
    }

    private SparqlNode optimizeReusedTypeSelectionUnion(SparqlNode source, SparqlBuildingContext context) {
        Union union;
        block7: {
            block6: {
                if (!(source instanceof Union)) break block6;
                union = (Union)source;
                if (!context.isSoTypeOptimizationDisabled()) break block7;
            }
            return source;
        }
        LinkedHashMap<String, List<Value>> rdfTypeValuesMapping = new LinkedHashMap<String, List<Value>>();
        LinkedHashMap<String, List<SparqlNode>> nodesToReplaceMapping = new LinkedHashMap<String, List<SparqlNode>>();
        Map<String, UnionTypeNode> firstNodes = ConstraintGenerator.analyzeUnion(union, rdfTypeValuesMapping, nodesToReplaceMapping);
        for (Map.Entry<String, UnionTypeNode> entry : firstNodes.entrySet()) {
            String service = entry.getKey();
            List rdfTypeValues = (List)rdfTypeValuesMapping.get(service);
            List nodesToReplace = nodesToReplaceMapping.getOrDefault(service, List.of());
            if (nodesToReplace.size() < context.soTypeOptimizationThreshold) continue;
            UnionTypeNode firstNode = entry.getValue();
            Var binding = firstNode.filter.streamNodes().filter(Var.class::isInstance).map(Var.class::cast).findFirst().orElseThrow();
            union.getNodes().removeIf(nodesToReplace::contains);
            if (union.isEmpty() && firstNodes.size() == 1) {
                return ConstraintGenerator.wrapInFederatedBlockIfNeeded(service, this.buildFilter(binding, rdfTypeValues));
            }
            FilterVar tmp = new FilterVar(binding, "tmp", 0);
            Filter filter = this.buildFilter(tmp, rdfTypeValues);
            if (service.equals(NO_SERVICE)) {
                union.addNode(new TriplePatternBlock(new Bind(binding, tmp), filter));
                continue;
            }
            union.addNode(new FederatedBlock(new Iri(service), new Bind(binding, tmp), filter));
        }
        return union;
    }

    private void addTypePropBasedFilter(Shape shape, Consumer<SparqlNode> nodesConsumer, SparqlBuildingContext context) {
        List type = shape.getTypeAsList();
        if (type == null || type.isEmpty()) {
            return;
        }
        String typeProp = shape.getTypeProp();
        String varName = this.schema.getPrefixes().toName(typeProp);
        java.util.Optional typePropertyShape = shape.getProperty(typeProp);
        boolean isRestrictive = typePropertyShape.filter(PropertyShape::isRestrictive).isPresent();
        List<Iri> types = this.getTypes(shape);
        Var typePropVar = (Var)context.varProcessor.apply(new FilterVar(context.subject, varName, 0));
        Var typeVar = isRestrictive && types.size() == 1 ? (Value)types.getFirst() : typePropVar;
        SparqlNodeSequence nodes = new SparqlNodeSequence();
        if (typePropertyShape.filter(PropertyShape::isSparqlTemplate).isPresent()) {
            typePropertyShape.map(PropertyShape::getRdfProp).map(rdfProp -> SparqlFragment.create(rdfProp, context.subject, typeVar, isRestrictive)).ifPresent(nodes::add);
        } else {
            TriplePattern triplePattern = new TriplePattern(context.subject, new Iri(shape.getTypePropIri()), typeVar, isRestrictive);
            nodes.add(triplePattern);
        }
        if (typeVar instanceof Var) {
            nodes.add(this.buildFilter(typeVar, types));
        }
        nodesConsumer.accept(nodes);
    }

    private List<Iri> getTypes(Shape shape) {
        return this.typeMap.computeIfAbsent(shape.getId(), key -> shape.getTypeAsList().stream().map(arg_0 -> ((Prefixes)this.schema.getPrefixes()).toRelativeIri(arg_0)).map(Iri::new).toList());
    }

    private Filter buildFilter(SparqlNode varNode, List<? extends Value> types) {
        if (types.size() > 1) {
            return new Filter(new In(varNode, types, this.options.getInThreshold()));
        }
        return new Filter(new Equals(varNode, types.getFirst()));
    }

    private Collection<Shape> getConcreteSubTypes(String type) {
        return this.subTypes.computeIfAbsent(type, parent -> ((Collection)this.schema.getObjects().getIfPresent(parent).map(Shape::getConcreteSubTypes).orElse(List.of())).stream().filter((? super T shape) -> shape.isSynthetic() == false && !shape.isSystem() && !shape.isIgnoredType()).toList());
    }

    private void handleNonAbstract(Shape shape, Consumer<SparqlNode> nodesConsumer, Var typeVar, SparqlBuildingContext context) {
        if (this.canPreFetchedSoTypeBeUsed(context)) {
            List<Value> list = this.shapeToIdLiteralOptimized(shape).toList();
            nodesConsumer.accept(this.buildFilter(context.newSoTypeVar(), list));
        } else {
            HashSet<String> addedProps = new HashSet<String>();
            if (shape.getType() != null) {
                addedProps.add(shape.getTypeProp());
            }
            LinkedList<SparqlNode> shapeNodes = new LinkedList<SparqlNode>();
            this.addParentConstraint(shape, shapeNodes::add, context, addedProps);
            this.addTypePropBasedFilter(shape, shapeNodes::add, context);
            this.addShapeNodesInParentSparqlBlock(shape, nodesConsumer, context, shapeNodes);
            if (context.requireSoTypeExport) {
                nodesConsumer.accept(new Bind(Literal.asString(shape.asGraphQl()), typeVar));
            }
        }
    }

    private void addShapeNodesInParentSparqlBlock(Shape shape, Consumer<SparqlNode> nodesConsumer, SparqlBuildingContext context, List<SparqlNode> shapeNodes) {
        SparqlNode target = shapeNodes.size() == 1 || !context.isSinglePredicateTypeOptimizationEnabled() ? shapeNodes.getFirst() : new SparqlNodeSequence(shapeNodes.stream().map(ConstraintGenerator::optimizeSingleTypeCheckFromHierarchy).toList());
        if (context.serviceAware && shape.getServiceAddress() != null && !shape.getServiceAddress().equals(context.service.orElse(null))) {
            nodesConsumer.accept(FederatedBlock.of(new Iri(shape.getServiceAddress()), target));
        } else {
            nodesConsumer.accept(target);
        }
    }

    private static SparqlNode optimizeSingleTypeCheckFromHierarchy(SparqlNode shapeNode) {
        SparqlNode node = shapeNode.getClass().equals(TriplePatternBlock.class) ? shapeNode : new TriplePatternBlock(shapeNode);
        AtomicReference reference = new AtomicReference();
        java.util.Optional<UnionTypeNode> typeNode = UnionTypeNode.parseUnionNode(node, reference::set);
        UnionTypeNode unionTypeNode = typeNode.orElse((UnionTypeNode)reference.get());
        if (unionTypeNode != null) {
            return new SinglePredicateOptimization(unionTypeNode, shapeNode).optimize();
        }
        return shapeNode;
    }

    private void addParentConstraint(Shape child, Consumer<SparqlNode> nodesConsumer, SparqlBuildingContext context, Set<String> alreadyAdded) {
        List parents = child.getInheritsAsList();
        if (parents.isEmpty()) {
            return;
        }
        for (String parent : parents) {
            Shape parentShape = (Shape)this.schema.getObjects().get((Object)parent);
            if (parentShape == null) {
                return;
            }
            if (!parentShape.isIgnoredType() && !alreadyAdded.contains(parentShape.getTypeProp()) && parentShape.getType() != null) {
                this.addTypePropBasedFilter(parentShape, nodesConsumer, context);
                alreadyAdded.add(parentShape.getTypeProp());
            }
            this.addParentConstraint(parentShape, nodesConsumer, context, alreadyAdded);
        }
    }

    static Map<String, UnionTypeNode> analyzeUnion(Union union, Map<String, List<Value>> rdfTypeValues, Map<String, List<SparqlNode>> nodesToReplace) {
        LinkedHashMap<String, UnionTypeNode> nodes = new LinkedHashMap<String, UnionTypeNode>();
        for (SparqlNode unionNode : union.getNodes()) {
            java.util.Optional<UnionTypeNode> unionTypeNode = UnionTypeNode.parseUnionNode(unionNode, null);
            if (unionTypeNode.isEmpty()) continue;
            UnionTypeNode typeNode = unionTypeNode.get();
            String service = unionTypeNode.flatMap(UnionTypeNode::getService).orElse(NO_SERVICE);
            nodes.putIfAbsent(service, typeNode);
            typeNode.forEachValue(rdfTypeValues.computeIfAbsent(service, k -> new ArrayList())::add);
            nodesToReplace.computeIfAbsent(service, k -> new ArrayList()).add(unionNode);
        }
        return nodes;
    }

    List<UnionTypeOptimization> analyzeUnion(Union union, SparqlBuildingContext context) {
        boolean allowMultiNodeOptimization = !context.isSoTypeOptimizationDisabled();
        boolean allowSingleNodeOptimization = context.isSinglePredicateTypeOptimizationEnabled();
        LinkedHashMap<String, UnionTypeOptimization> nodesByService = new LinkedHashMap<String, UnionTypeOptimization>();
        ArrayList<UnionTypeOptimization> nodes = new ArrayList<UnionTypeOptimization>(union.getNodes().size());
        Function<SparqlNode, Consumer> onNonRdfTypeCheck = typeNode -> node -> nodes.add(new SinglePredicateOptimization((UnionTypeNode)node, (SparqlNode)typeNode));
        for (SparqlNode unionNode : union.getNodes()) {
            int lastSize = nodes.size();
            java.util.Optional<UnionTypeNode> unionTypeNode = UnionTypeNode.parseUnionNode(unionNode, onNonRdfTypeCheck.apply(unionNode));
            if (unionTypeNode.filter(UnionTypeNode::isComplete).isEmpty()) {
                if (lastSize != nodes.size()) continue;
                nodes.add(() -> unionNode);
                continue;
            }
            UnionTypeNode typeNode2 = unionTypeNode.get();
            if (allowMultiNodeOptimization) {
                String service = typeNode2.getService().orElse(NO_SERVICE);
                MultiNodeOptimization optimization2 = (MultiNodeOptimization)nodesByService.computeIfAbsent(service, k -> {
                    MultiNodeOptimization opt = new MultiNodeOptimization(typeNode2, context);
                    nodes.add(opt);
                    return opt;
                });
                typeNode2.forEachValue(optimization2.rdfTypeValue::add);
                optimization2.nodesToReplace.add(unionNode);
                continue;
            }
            if (!allowSingleNodeOptimization) continue;
            nodes.add(new SinglePredicateOptimization(typeNode2, unionNode));
        }
        return nodes.stream().flatMap(optimization -> {
            if (optimization instanceof MultiNodeOptimization) {
                MultiNodeOptimization multi = (MultiNodeOptimization)optimization;
                return multi.convertToSingleIfApplicable(context.soTypeOptimizationThreshold);
            }
            return Stream.of(optimization);
        }).toList();
    }

    public static class SparqlBuildingContext {
        Var subject;
        String boTypeAlias;
        UnaryOperator<Var> varProcessor;
        Function<ActionFilter, java.util.Optional<SparqlNode>> filterGenerator;
        java.util.Optional<String> service;
        boolean serviceAware;
        boolean soTypePresent;
        boolean requireSoTypeExport;
        int soTypeOptimizationThreshold;
        final boolean singlePredicateTypeOptimization;

        public static Builder contextBuilder() {
            return new Builder();
        }

        private SparqlBuildingContext(Builder builder) {
            this.subject = builder.subject;
            this.boTypeAlias = this.getOrDefault(builder.boTypeAlias, "ignore");
            this.varProcessor = this.getOrDefault(builder.varProcessor, UnaryOperator.identity());
            this.filterGenerator = this.getOrDefault(builder.filterGenerator, filter -> java.util.Optional.empty());
            this.service = builder.service;
            this.serviceAware = builder.serviceAware;
            this.soTypePresent = builder.soTypePresent;
            this.requireSoTypeExport = builder.requireSoTypeExport;
            this.soTypeOptimizationThreshold = builder.soTypeOptimizationThreshold;
            this.singlePredicateTypeOptimization = builder.singlePredicateTypeOptimization;
        }

        public boolean isTypePatternOptimizationsEnabled() {
            return !this.isSoTypeOptimizationDisabled() || this.isSinglePredicateTypeOptimizationEnabled();
        }

        boolean isSoTypeOptimizationDisabled() {
            return this.soTypeOptimizationThreshold <= 1 || this.soTypeOptimizationThreshold == Integer.MAX_VALUE;
        }

        boolean isSinglePredicateTypeOptimizationEnabled() {
            return this.singlePredicateTypeOptimization;
        }

        private <T> T getOrDefault(T value, T def) {
            if (value != null) {
                return value;
            }
            return def;
        }

        Var newSoTypeVar() {
            return new Var(this.subject, this.boTypeAlias);
        }

        public static class Builder {
            Var subject;
            String boTypeAlias;
            UnaryOperator<Var> varProcessor;
            Function<ActionFilter, java.util.Optional<SparqlNode>> filterGenerator;
            java.util.Optional<String> service;
            boolean serviceAware = false;
            private boolean soTypePresent = false;
            private boolean requireSoTypeExport = true;
            private int soTypeOptimizationThreshold = 2;
            private boolean singlePredicateTypeOptimization = true;

            public SparqlBuildingContext build() {
                return new SparqlBuildingContext(this);
            }

            public Builder subject(Var subject) {
                this.subject = subject;
                return this;
            }

            public Builder boTypeAlias(String soTypeAlias) {
                this.boTypeAlias = soTypeAlias;
                return this;
            }

            public Builder varProcessor(UnaryOperator<Var> varProcessor) {
                this.varProcessor = varProcessor;
                return this;
            }

            public Builder filterGenerator(Function<ActionFilter, java.util.Optional<SparqlNode>> filterGenerator) {
                this.filterGenerator = filterGenerator;
                return this;
            }

            public Builder service(String service) {
                this.service = java.util.Optional.ofNullable(service);
                this.serviceAware = true;
                return this;
            }

            public Builder soTypePresent(boolean soTypePresent) {
                this.soTypePresent = soTypePresent;
                return this;
            }

            public Builder exportSoType(boolean requireSoTypeExport) {
                this.requireSoTypeExport = requireSoTypeExport;
                return this;
            }

            public Builder soTypeOptimizationThreshold(int soTypeOptimizationThreshold) {
                this.soTypeOptimizationThreshold = soTypeOptimizationThreshold;
                return this;
            }

            public Builder disableSoTypeOptimization() {
                return this.soTypeOptimizationThreshold(Integer.MAX_VALUE).setSinglePredicateTypeOptimization(false);
            }

            public Builder setSinglePredicateTypeOptimization(boolean soTypeOptimizationEnabled) {
                this.singlePredicateTypeOptimization = soTypeOptimizationEnabled;
                return this;
            }
        }
    }

    private static interface UnionTypeOptimization {
        public SparqlNode optimize();
    }

    private static class UnionTypeNode {
        private FederatedBlock federatedBlock;
        private TriplePattern pattern;
        private Filter filter;
        private Bind bind;
        private boolean valid = true;

        private UnionTypeNode() {
        }

        static java.util.Optional<UnionTypeNode> parseUnionNode(SparqlNode unionNode, Consumer<UnionTypeNode> onNonRdfTypeCheck) {
            UnionTypeNode typeNode;
            if (!(unionNode instanceof TriplePatternBlock)) {
                return java.util.Optional.empty();
            }
            TriplePatternBlock block = (TriplePatternBlock)unionNode;
            List<SparqlNode> patterns = block.getPatterns().stream().flatMap(SparqlNodeSequence::flatten).toList();
            if (patterns.size() == 3) {
                if (patterns.stream().noneMatch(FederatedBlock.class::isInstance)) {
                    UnionTypeNode typeNode2 = UnionTypeNode.buildFrom(patterns);
                    if (typeNode2.isComplete()) {
                        return UnionTypeNode.checkIfRdfTypePattern(typeNode2, onNonRdfTypeCheck);
                    }
                    return java.util.Optional.empty();
                }
            }
            if (patterns.size() == 2) {
                UnionTypeNode typeNode3 = UnionTypeNode.buildFrom(patterns);
                if (typeNode3.isComplete() && typeNode3.federatedBlock != null) {
                    return UnionTypeNode.checkIfRdfTypePattern(typeNode3, onNonRdfTypeCheck);
                }
                if (typeNode3.isEqualsFilterPattern()) {
                    onNonRdfTypeCheck.accept(typeNode3);
                }
                return java.util.Optional.empty();
            }
            if (patterns.size() == 1 && (typeNode = UnionTypeNode.buildFrom(patterns)).isEqualityFilterOnly()) {
                return java.util.Optional.of(typeNode);
            }
            return java.util.Optional.empty();
        }

        @NotNull
        private static java.util.Optional<UnionTypeNode> checkIfRdfTypePattern(UnionTypeNode typeNode, Consumer<UnionTypeNode> onNonRdfTypeCheck) {
            if (typeNode.isRdfTypeCheck()) {
                return java.util.Optional.of(typeNode);
            }
            if (onNonRdfTypeCheck != null) {
                onNonRdfTypeCheck.accept(typeNode);
            }
            return java.util.Optional.empty();
        }

        static UnionTypeNode buildFrom(Collection<SparqlNode> sparqlNodes) {
            UnionTypeNode typeNode = new UnionTypeNode();
            for (SparqlNode node : sparqlNodes) {
                if (node instanceof SparqlNodeSequence) {
                    SparqlNodeSequence sequence = (SparqlNodeSequence)node;
                    sequence.getNodes().forEach(typeNode::set);
                    continue;
                }
                typeNode.set(node);
            }
            return typeNode;
        }

        void set(SparqlNode node) {
            if (node instanceof TriplePattern) {
                TriplePattern pattr = (TriplePattern)node;
                if (this.pattern == null) {
                    this.pattern = pattr;
                } else {
                    this.valid = false;
                }
            } else if (node instanceof Filter) {
                Filter flt;
                this.filter = flt = (Filter)node;
            } else if (node instanceof Bind) {
                Bind bnd;
                this.bind = bnd = (Bind)node;
            } else if (node instanceof FederatedBlock) {
                FederatedBlock fb;
                this.federatedBlock = fb = (FederatedBlock)node;
                fb.getPatterns().stream().flatMap(sn -> {
                    Stream<SparqlNode> stream;
                    if (sn instanceof SparqlNodeSequence) {
                        SparqlNodeSequence sequence = (SparqlNodeSequence)sn;
                        stream = sequence.getNodes().stream();
                    } else {
                        stream = Stream.of(sn);
                    }
                    return stream;
                }).flatMap(sn -> {
                    Stream<SparqlNode> stream;
                    if (sn instanceof SparqlNodeSequence) {
                        SparqlNodeSequence sequence = (SparqlNodeSequence)sn;
                        stream = sequence.getNodes().stream();
                    } else {
                        stream = Stream.of(sn);
                    }
                    return stream;
                }).forEach(this::set);
            } else {
                this.valid = false;
            }
        }

        boolean isComplete() {
            return this.valid && this.pattern != null && this.filter != null && this.bind != null;
        }

        boolean isRdfTypeCheck() {
            return "rdf:type".equals(this.pattern.getPredicate().toSparql());
        }

        void forEachValue(Consumer<Value> valueConsumer) {
            if (this.isEqualsFilter()) {
                valueConsumer.accept((Value)((Equals)this.filter.getNode()).getConstant());
            } else if (this.isInFilter()) {
                ((In)this.filter.getNode()).getValues().forEach(valueConsumer);
            }
        }

        boolean isEqualsFilterPattern() {
            return this.valid && this.pattern != null && this.isEqualsFilter();
        }

        boolean isEqualityFilterOnly() {
            return this.valid && this.pattern == null && (this.isEqualsFilter() || this.isInFilter());
        }

        boolean isEqualsFilter() {
            Equals eq;
            SparqlNode sparqlNode;
            return this.filter != null && (sparqlNode = this.filter.getNode()) instanceof Equals && (eq = (Equals)sparqlNode).getConstant() instanceof Value;
        }

        Value getFilterValue() {
            Equals eq;
            SparqlNode sparqlNode;
            if (this.filter != null && (sparqlNode = this.filter.getNode()) instanceof Equals && (sparqlNode = (eq = (Equals)sparqlNode).getConstant()) instanceof Value) {
                Value value = (Value)sparqlNode;
                return value;
            }
            return null;
        }

        boolean isInFilter() {
            return this.filter != null && this.filter.getNode() instanceof In;
        }

        java.util.Optional<String> getService() {
            if (this.federatedBlock != null) {
                return java.util.Optional.of(this.federatedBlock.getService().toString());
            }
            return java.util.Optional.empty();
        }

        Var resolveTypeVar(boolean requireFilterVar) {
            if (this.filter == null || !requireFilterVar) {
                if (this.bind != null) {
                    return (Var)this.bind.getVar();
                }
                return null;
            }
            return this.filter.streamNodes().flatMap(SparqlNode::streamNodes).filter(FilterVar.class::isInstance).map(Var.class::cast).findFirst().orElseGet(() -> this.bind != null ? (Var)this.bind.getVar() : null);
        }
    }

    private static class SinglePredicateOptimization
    implements UnionTypeOptimization {
        private final UnionTypeNode unionTypeNode;
        private final SparqlNode typeNode;

        public SinglePredicateOptimization(UnionTypeNode unionTypeNode, SparqlNode typeNode) {
            this.unionTypeNode = unionTypeNode;
            this.typeNode = typeNode;
        }

        public SinglePredicateOptimization(SparqlNode node) {
            this.unionTypeNode = UnionTypeNode.parseUnionNode(node, null).orElseThrow();
            this.typeNode = node;
        }

        @Override
        public SparqlNode optimize() {
            if (this.unionTypeNode.isEqualsFilter() && this.unionTypeNode.valid) {
                TriplePattern triplePattern = new TriplePattern(this.unionTypeNode.pattern.getSubject(), this.unionTypeNode.pattern.getPredicate(), this.unionTypeNode.getFilterValue());
                String service = this.unionTypeNode.getService().orElse(ConstraintGenerator.NO_SERVICE);
                if (this.unionTypeNode.bind != null) {
                    if (this.unionTypeNode.getService().isEmpty()) {
                        SparqlNodeSequence sequence = new SparqlNodeSequence();
                        sequence.add(triplePattern);
                        sequence.add(this.unionTypeNode.bind);
                        return sequence;
                    }
                    return new SparqlNodeSequence(ConstraintGenerator.wrapInFederatedBlockIfNeeded(service, triplePattern), this.unionTypeNode.bind);
                }
                return ConstraintGenerator.wrapInFederatedBlockIfNeeded(service, triplePattern);
            }
            return this.typeNode;
        }
    }

    private class MultiNodeOptimization
    implements UnionTypeOptimization {
        private final UnionTypeNode unionTypeNode;
        private final String service;
        private final SparqlBuildingContext context;
        private final List<SparqlNode> nodesToReplace = new LinkedList<SparqlNode>();
        private final List<Value> rdfTypeValue = new LinkedList<Value>();

        public MultiNodeOptimization(UnionTypeNode unionTypeNode, SparqlBuildingContext context) {
            this.unionTypeNode = unionTypeNode;
            this.service = unionTypeNode.getService().orElse(ConstraintGenerator.NO_SERVICE);
            this.context = context;
        }

        @Override
        public SparqlNode optimize() {
            SparqlNodeSequence sequence = new SparqlNodeSequence();
            boolean requireFilterVar = this.isRequireFilterVar(this.context, this.service);
            Var bindVar = this.unionTypeNode.resolveTypeVar(requireFilterVar);
            sequence.add(new TriplePattern(this.unionTypeNode.pattern.getSubject(), this.unionTypeNode.pattern.getPredicate(), bindVar));
            sequence.add(ConstraintGenerator.this.buildFilter(bindVar, this.rdfTypeValue));
            if (requireFilterVar && this.unionTypeNode.bind != null) {
                sequence.add(new Bind(bindVar, this.unionTypeNode.bind.getVar()));
            }
            return ConstraintGenerator.wrapInFederatedBlockIfNeeded(this.service, sequence);
        }

        private boolean isRequireFilterVar(SparqlBuildingContext context, String service) {
            if (this.unionTypeNode.bind == null) {
                return false;
            }
            return !service.equals(ConstraintGenerator.NO_SERVICE) && context.soTypePresent || service.equals(ConstraintGenerator.NO_SERVICE) && context.serviceAware && context.service.isPresent();
        }

        Stream<UnionTypeOptimization> convertToSingleIfApplicable(int threshold) {
            if (this.rdfTypeValue.size() == 1) {
                return Stream.of(new SinglePredicateOptimization(this.unionTypeNode, this.nodesToReplace.getFirst()));
            }
            if (this.nodesToReplace.size() < threshold) {
                return this.nodesToReplace.stream().map(SinglePredicateOptimization::new);
            }
            return Stream.of(this);
        }
    }
}

