/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.querymodel.AbstractQuery;
import com.ontotext.graphql.compiler.querymodel.Base;
import com.ontotext.graphql.compiler.querymodel.DeleteInsertQuery;
import com.ontotext.graphql.compiler.querymodel.Equals;
import com.ontotext.graphql.compiler.querymodel.In;
import com.ontotext.graphql.compiler.querymodel.Inverse;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Prefix;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlUpdateQuery;
import com.ontotext.graphql.compiler.querymodel.TriplePatternChain;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.query.Arguments;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;

public abstract class BaseMutationSparqlGenerator {
    public static final String NG = "/ng";
    private static final Iri DISABLE_SAME_AS = new Iri("http://www.ontotext.com/disable-sameAs");
    protected final SomlSchema schema;
    protected final OperationBuilderOptions options;
    protected final OperationBuilderOptions.MutationMode mutationMode;
    protected final FilterFactory filterFactory;

    BaseMutationSparqlGenerator(SomlSchema schema, OperationBuilderOptions options, FilterFactory filterFactory) {
        this.schema = schema;
        this.options = options;
        this.mutationMode = options.getMutationMode();
        this.filterFactory = filterFactory;
    }

    protected void configureMutation(SparqlUpdateQuery mutationQuery, Mutation mutation) {
        Arguments arguments = mutation.getArguments();
        boolean disableOwlSameAs = arguments.getExpandOverOwlSameAs().filter(Boolean.FALSE::equals).isPresent();
        for (AbstractQuery query : mutationQuery.getQueries()) {
            if (!(query instanceof DeleteInsertQuery)) continue;
            DeleteInsertQuery deleteInsertQuery = (DeleteInsertQuery)query;
            if (disableOwlSameAs) {
                deleteInsertQuery.addUsingGraph(DISABLE_SAME_AS);
            }
            arguments.getWith().ifPresent(with -> deleteInsertQuery.setWithGraph(new Iri((String)with)));
            arguments.getUsing().ifPresent(usingList -> usingList.forEach(using -> deleteInsertQuery.addUsingGraph(new Iri((String)using))));
            arguments.getUsingNamed().ifPresent(usingList -> usingList.forEach(using -> deleteInsertQuery.addUsingNamedGraph(new Iri((String)using))));
        }
    }

    protected String toRelativeIri(String id) {
        return this.schema.getPrefixes().toRelativeIri(id);
    }

    protected void addBase(AbstractQuery query) {
        this.schema.getSpecialPrefixes().getBaseIri().map(Base::new).ifPresent(query::setBase);
    }

    protected void addPrefixes(AbstractQuery query) {
        query.getUsedPrefixes().distinct().sorted().filter(arg_0 -> this.schema.getPrefixes().containsKey(arg_0)).map(pref -> new Prefix((String)pref, (String)this.schema.getPrefixes().get(pref))).forEach(query.getPrefixes()::add);
    }

    protected Value createPredicate(String property, Shape shape) {
        String predicate = shape.getPropertyOrFail(this.schema.getPrefixes().nameToShortIri(property)).getRdfProperty();
        return new Iri(predicate);
    }

    protected Value createInversePredicate(String alias, String property, Shape shape) {
        String predicate = shape.getPropertyOrFail(this.schema.getPrefixes().nameToShortIri(property)).getRdfProperty();
        return new Inverse(this.schema.getPrefixes().toShortIri(alias), predicate);
    }

    protected void convertValue(Object value, Consumer<Value> valueConsumer) {
        if (value instanceof Collection) {
            for (Object val : (Collection)value) {
                this.convertValue(val, valueConsumer);
            }
        } else if (value instanceof IRI || value instanceof BNode) {
            valueConsumer.accept(new Iri(value.toString()));
        } else {
            valueConsumer.accept(new Literal(value));
        }
    }

    protected void appendToInsertBlock(Value id, Object graph, DeleteInsertQuery query, TriplePatternChain insertChain) {
        if (insertChain.isEmpty()) {
            return;
        }
        SparqlNode block = insertChain;
        if (graph == null) {
            if (this.mutationMode.allowEntityGraph()) {
                block = this.createNamedGraph(this.createEntityGraph(id), insertChain);
            }
        } else if (this.mutationMode.allowCustomGraph()) {
            block = this.createNamedGraph(graph, insertChain);
        } else if (this.mutationMode.allowEntityGraph()) {
            block = this.createNamedGraph(this.createEntityGraph(id), insertChain);
        }
        query.getInsert().addNode(block);
    }

    protected void appendToDeleteBlock(Value id, DeleteInsertQuery query, TriplePatternChain deleteChain) {
        if (deleteChain.isEmpty()) {
            return;
        }
        SparqlNode toAppend = deleteChain;
        if (this.mutationMode == OperationBuilderOptions.MutationMode.APPEND_ONLY) {
            toAppend = this.createNamedGraph(this.createEntityGraph(id), deleteChain);
        }
        query.getDelete().addNode(toAppend);
    }

    private NamedGraphTriplePatternBlock createNamedGraph(Object graphName, TriplePatternChain graphContents) {
        Value graph;
        if (graphName instanceof String) {
            String string = (String)graphName;
            graph = new Iri(string);
        } else if (graphName instanceof Value) {
            Value value = (Value)graphName;
            graph = value;
        } else {
            throw new IllegalArgumentException(String.format("Unsupported graph argument type: %s as %s", graphName, graphName == null ? "NULL" : graphName.getClass().getSimpleName()));
        }
        NamedGraphTriplePatternBlock graphBlock = new NamedGraphTriplePatternBlock(graph);
        graphBlock.addNode(graphContents);
        return graphBlock;
    }

    private Value createEntityGraph(Value id) {
        return id instanceof Iri ? new Iri(id.getName() + NG) : id;
    }

    protected static class EqualsOrInNode
    implements SparqlNode {
        private final Var subject;
        private final int inThreshold;
        private final List<Value> values = new LinkedList<Value>();

        EqualsOrInNode(Var subject, int inThreshold) {
            this.subject = subject;
            this.inThreshold = inThreshold;
        }

        @Override
        public String toSparql() {
            if (this.values.size() == 1) {
                return new Equals(this.subject, this.values.getFirst()).toSparql();
            }
            return new In(this.subject, this.values, this.inThreshold).toSparql();
        }

        @Override
        public Stream<SparqlNode> streamNodes() {
            return Stream.concat(Stream.of(this.subject), this.values.stream());
        }

        void add(Value value) {
            this.values.add(value);
        }
    }
}

