/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl;

import com.ontotext.trree.big.collections.ModifiablePairCollection;
import com.ontotext.trree.plugin.externalsync.api.CloseableIterator;
import com.ontotext.trree.plugin.externalsync.api.LongLongIndex;
import com.ontotext.trree.transactions.TransactionException;
import com.ontotext.trree.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;

public class LongLongIndexModifiablePairCollection
implements LongLongIndex {
    public static int CACHE_SIZE = 1000;
    Path collectionDirectory;
    ModifiablePairCollection collection1;
    ModifiablePairCollection collection2;
    ModifiablePairCollection.ModifiablePairConnection connection1;
    ModifiablePairCollection.ModifiablePairConnection connection2;

    public LongLongIndexModifiablePairCollection(String storeName, Path pluginDir, int entityIdSize) {
        this.collectionDirectory = pluginDir.resolve(storeName).resolve("dependees-collection");
        try {
            Files.createDirectories(this.collectionDirectory, new FileAttribute[0]);
            this.collection1 = new ModifiablePairCollection(this.collectionDirectory.resolve("col1").toFile(), CACHE_SIZE, entityIdSize);
            this.collection1.initialize();
            this.collection2 = new ModifiablePairCollection(this.collectionDirectory.resolve("col2").toFile(), CACHE_SIZE, entityIdSize);
            this.collection2.initialize();
        }
        catch (TransactionException | IOException e) {
            throw new RuntimeException(e);
        }
        this.connection1 = this.collection1.getConnection();
        this.connection2 = this.collection2.getConnection();
        this.begin();
    }

    public void begin() {
        try {
            this.connection1.beginTransaction();
            this.connection2.beginTransaction();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(long docId, Collection<Long> chainIds) {
        chainIds.forEach(value -> {
            this.connection1.add(docId, value.longValue());
            this.connection2.add(value.longValue(), docId);
        });
    }

    @Override
    public void set(long docId, Collection<Long> chainIds) {
        this.remove(docId);
        this.add(docId, chainIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(long docId) {
        try (ModifiablePairCollection.ModifiablePairIterator iter = this.connection1.get(docId, Long.MIN_VALUE, docId, Long.MAX_VALUE);){
            while (iter.hasNext()) {
                iter.remove();
                this.connection2.remove(iter.right, iter.left);
                iter.next();
            }
        }
    }

    @Override
    public void removeAll() {
        this.connection1.clear();
        this.connection2.clear();
    }

    @Override
    public CloseableIterator<Long> find(long chainId) {
        return new IteratorConverter(this.connection2.get(chainId, Long.MIN_VALUE, chainId, Long.MAX_VALUE));
    }

    @Override
    public int size() {
        return (int)this.connection1.getCollectionSize(Long.MIN_VALUE, Long.MIN_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void commit() {
        try {
            this.connection1.commit();
            this.connection2.commit();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
        this.begin();
    }

    @Override
    public void rollback() {
        try {
            this.connection1.rollback();
            this.connection2.rollback();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
        this.begin();
    }

    @Override
    public void close() {
        try {
            this.connection1.rollback();
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
        this.connection1.close();
        try {
            this.connection2.rollback();
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
        this.connection2.close();
        this.collection1.shutdown();
        this.collection2.shutdown();
    }

    @Override
    public void drop() throws Exception {
        this.close();
        FileUtils.recursiveDelete((File)this.collectionDirectory.toFile());
    }

    public Path getDirectory() {
        return this.collectionDirectory;
    }

    private static class IteratorConverter
    implements CloseableIterator<Long> {
        ModifiablePairCollection.ModifiablePairIterator iter;

        IteratorConverter(ModifiablePairCollection.ModifiablePairIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            boolean next = this.iter.hasNext();
            if (!next) {
                this.iter.close();
            }
            return next;
        }

        @Override
        public Long next() {
            try {
                Long l = this.iter.right;
                return l;
            }
            finally {
                this.iter.next();
            }
        }

        @Override
        public void close() throws IOException {
            this.iter.close();
        }
    }
}

