/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.filter;

import com.ontotext.trree.plugin.externalsync.filter.AbstractComparisonExpression;
import com.ontotext.trree.plugin.externalsync.filter.Operand;
import com.ontotext.trree.plugin.externalsync.filter.ValueProvider;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.Value;

public class RegexExpression
extends AbstractComparisonExpression {
    private final Pattern pattern;

    public RegexExpression(Operand operand, String pattern, String flags) {
        super(operand);
        this.operand = operand;
        this.pattern = Pattern.compile(pattern, RegexExpression.parseFlags(flags));
    }

    private static int parseFlags(String flags) {
        if (flags == null || flags.isEmpty()) {
            return 0;
        }
        if (flags.equals("i")) {
            return 2;
        }
        throw new IllegalArgumentException("Unsupported flag option: " + flags);
    }

    @Override
    protected boolean evaluateSingleValue(ValueProvider valueProvider, Value documentValue, long documentId) {
        return this.pattern.matcher(documentValue.stringValue()).find();
    }
}

